/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.deserializier;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.admin.util.TenantIdDeserializer;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.support.serializer.DeserializationException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/kafka/deserializier/TenantArrayDeserializer;", "Lorg/apache/kafka/common/serialization/Deserializer;", "", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "topic", "", "data", "", "(Ljava/lang/String;[B)[Lde/justsoftware/admin/model/itemid/impl/TenantId;", "admin-service"})
public final class TenantArrayDeserializer
implements Deserializer<TenantId[]> {
    @NotNull
    private final ObjectMapper jsonMapper;

    public TenantArrayDeserializer() {
        Module[] moduleArray = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ObjectMapper().configure\u2026NKNOWN_PROPERTIES, false)");
        this.jsonMapper = moduleArray;
        moduleArray = new Module[]{(Module)TenantIdDeserializer.INSTANCE};
        this.jsonMapper.registerModules(moduleArray);
    }

    @NotNull
    public TenantId[] deserialize(@Nullable String topic, @Nullable byte[] data) {
        TenantId[] tenantIdArray;
        try {
            tenantIdArray = this.jsonMapper.readValue(data, TenantId[].class);
            Intrinsics.checkNotNullExpressionValue((Object)tenantIdArray, (String)"{\n        jsonMapper.rea\u2026antId>::class.java)\n    }");
            tenantIdArray = tenantIdArray;
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to deserialize data to TenantIds", data, false, (Throwable)e);
        }
        return tenantIdArray;
    }
}

