/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.consumer.configuration;

import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.kafka.consumer.configuration.KafkaConsumerConfiguration;
import de.justsoftware.admin.kafka.deserializier.UserGroupDeserializer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.SeekToCurrentErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@Configuration
@EnableKafka
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0012J\u001a\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/kafka/consumer/configuration/KafkaUserGroupConfiguration;", "", "kafkaConsumerConfiguration", "Lde/justsoftware/admin/kafka/consumer/configuration/KafkaConsumerConfiguration;", "(Lde/justsoftware/admin/kafka/consumer/configuration/KafkaConsumerConfiguration;)V", "consumerConfig", "", "", "userGroupListenerContainerFactory", "Lorg/springframework/kafka/config/KafkaListenerContainerFactory;", "Lorg/springframework/kafka/listener/ConcurrentMessageListenerContainer;", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "admin-service"})
public class KafkaUserGroupConfiguration {
    @NotNull
    private final KafkaConsumerConfiguration kafkaConsumerConfiguration;

    public KafkaUserGroupConfiguration(@NotNull KafkaConsumerConfiguration kafkaConsumerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerConfiguration, (String)"kafkaConsumerConfiguration");
        this.kafkaConsumerConfiguration = kafkaConsumerConfiguration;
    }

    private Map<String, Object> consumerConfig() {
        Map props = this.kafkaConsumerConfiguration.defaultConsumerConfig();
        props.put("group.id", "just.admin-service.userGroupConsumer");
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", UserGroupDeserializer.class);
        return props;
    }

    @Bean
    @NotNull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, UserGroup>> userGroupListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(this.consumerConfig()));
        factory.setErrorHandler((ErrorHandler)new SeekToCurrentErrorHandler((BackOff)new FixedBackOff(1000L, 1L)));
        return (KafkaListenerContainerFactory)factory;
    }
}

