/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.PeopleSettingsApplicationService;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.domain.appsettings.model.PeopleSettings;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.AppPermission;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0017J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J0\u0010\u0014\u001a\u00020\u000f2\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/PeopleSettingsFetcher;", "", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "peopleSettingsApplicationService", "Lde/justsoftware/admin/application/web/PeopleSettingsApplicationService;", "(Lde/justsoftware/admin/application/web/TenantApplicationService;Lde/justsoftware/admin/application/web/PeopleSettingsApplicationService;)V", "exporters", "", "Lde/justsoftware/admin/graphql/generated/types/AppPermission;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "peopleSettings", "Lde/justsoftware/admin/graphql/generated/types/PeopleSettings;", "setHasManualPeopleExporters", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "hasManualPeopleExporters", "", "setPeopleExporterPermissions", "add", "", "remove", "admin-service"})
public class PeopleSettingsFetcher {
    @NotNull
    private final TenantApplicationService tenantApplicationService;
    @NotNull
    private final PeopleSettingsApplicationService peopleSettingsApplicationService;

    public PeopleSettingsFetcher(@NotNull TenantApplicationService tenantApplicationService, @NotNull PeopleSettingsApplicationService peopleSettingsApplicationService) {
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsApplicationService, (String)"peopleSettingsApplicationService");
        this.tenantApplicationService = tenantApplicationService;
        this.peopleSettingsApplicationService = peopleSettingsApplicationService;
    }

    @DgsData(parentType="Tenant", field="peopleSettings")
    @NotNull
    public de.justsoftware.admin.graphql.generated.types.PeopleSettings peopleSettings(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        return ModelConverterKt.toGql((PeopleSettings)this.peopleSettingsApplicationService.getPeopleSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    /*
     * WARNING - void declaration
     */
    @DgsData(parentType="PeopleSettings", field="exporters")
    @NotNull
    public List<AppPermission> exporters(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((de.justsoftware.admin.graphql.generated.types.PeopleSettings)dfe.getSource()).getTenantId();
        Iterable $this$map$iv = this.peopleSettingsApplicationService.getExporterPermissions(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            de.justsoftware.admin.domain.appsettings.model.AppPermission appPermission = (de.justsoftware.admin.domain.appsettings.model.AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModelConverterKt.toGql((de.justsoftware.admin.domain.appsettings.model.AppPermission)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsMutation(field="setHasManualPeopleExporters")
    @NotNull
    public Tenant setHasManualPeopleExporters(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument boolean hasManualPeopleExporters) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.peopleSettingsApplicationService.setHasManualPeopleExporters(tenantId, hasManualPeopleExporters, authContext);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(tenantId, authContext));
    }

    /*
     * WARNING - void declaration
     */
    @DgsMutation(field="setPeopleExporterPermissions")
    @NotNull
    public Tenant setPeopleExporterPermissions(@InputArgument(collectionType=String.class) @NotNull List<String> add, @InputArgument(collectionType=String.class) @NotNull List<String> remove, @NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        Iterable $this$map$iv = add;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.from((String)it));
        }
        List addGranteeIds = (List)destination$iv$iv;
        Iterable $this$map$iv2 = remove;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(GranteeId.Companion.from((String)it));
        }
        List removeGranteeIds = (List)destination$iv$iv2;
        this.peopleSettingsApplicationService.setExporterPermissions(addGranteeIds, removeGranteeIds, authContext);
        if (authContext.getTenantId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext.getTenantId(), authContext));
    }
}

