/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.IdpApplicationService;
import de.justsoftware.admin.application.web.model.WebIdpConfiguration;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.domain.tenant.model.IdpConfiguration;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.AddIdentityProviderInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.UpdateIdentityProviderInput;
import de.justsoftware.admin.model.itemid.impl.ClientRegistrationId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0017J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u0013\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/IdpFetcher;", "", "idpApplicationService", "Lde/justsoftware/admin/application/web/IdpApplicationService;", "(Lde/justsoftware/admin/application/web/IdpApplicationService;)V", "addIdentityProvider", "Lde/justsoftware/admin/application/web/model/WebIdpConfiguration;", "input", "Lde/justsoftware/admin/graphql/generated/types/AddIdentityProviderInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "identityProviders", "", "removeDefaultProviderForTenant", "removeIdentityProvider", "", "id", "", "setAsDefaultProvider", "updateIdentityProvider", "Lde/justsoftware/admin/graphql/generated/types/UpdateIdentityProviderInput;", "admin-service"})
public class IdpFetcher {
    @NotNull
    private final IdpApplicationService idpApplicationService;

    public IdpFetcher(@NotNull IdpApplicationService idpApplicationService) {
        Intrinsics.checkNotNullParameter((Object)idpApplicationService, (String)"idpApplicationService");
        this.idpApplicationService = idpApplicationService;
    }

    /*
     * WARNING - void declaration
     */
    @DgsData(parentType="Tenant", field="identityProviders")
    @NotNull
    public Set<WebIdpConfiguration> identityProviders(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((Tenant)dfe.getSource()).getId();
        Iterable $this$map$iv = this.idpApplicationService.getIdps(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdpConfiguration idpConfiguration = (IdpConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebIdpConfiguration.Companion.fromIdpConfiguration((IdpConfiguration)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @DgsMutation(field="addIdentityProvider")
    @NotNull
    public WebIdpConfiguration addIdentityProvider(@InputArgument @NotNull AddIdentityProviderInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return WebIdpConfiguration.Companion.fromIdpConfiguration(this.idpApplicationService.addIdp(ModelConverterKt.toDomain((AddIdentityProviderInput)input), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateIdentityProvider")
    @NotNull
    public WebIdpConfiguration updateIdentityProvider(@InputArgument @NotNull UpdateIdentityProviderInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return WebIdpConfiguration.Companion.fromIdpConfiguration(this.idpApplicationService.updateIdp(ModelConverterKt.toDomain((UpdateIdentityProviderInput)input), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="removeIdentityProvider")
    public boolean removeIdentityProvider(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ClientRegistrationId configId = ClientRegistrationId.Companion.fromString(id);
        this.idpApplicationService.removeIdp(configId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @DgsMutation(field="setAsDefaultProvider")
    @NotNull
    public Set<WebIdpConfiguration> setAsDefaultProvider(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ClientRegistrationId configId = ClientRegistrationId.Companion.fromString(id);
        Iterable iterable = this.idpApplicationService.setAsDefaultId(configId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdpConfiguration idpConfiguration = (IdpConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebIdpConfiguration.Companion.fromIdpConfiguration((IdpConfiguration)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @DgsMutation(field="removeDefaultProviderForTenant")
    @NotNull
    public Set<WebIdpConfiguration> removeDefaultProviderForTenant(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable $this$map$iv = this.idpApplicationService.removeDefaultProviderForTenant((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdpConfiguration idpConfiguration = (IdpConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebIdpConfiguration.Companion.fromIdpConfiguration((IdpConfiguration)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

