/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user.persistence;

import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.domain.user.persistence.repository.UserGroupRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.admin.model.itemid.impl.UserGroupId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0001J\u0013\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0096\u0001J\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u0010J)\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0015\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0002\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;", "Lde/justsoftware/admin/domain/user/persistence/repository/UserGroupRepository;", "repository", "(Lde/justsoftware/admin/domain/user/persistence/repository/UserGroupRepository;)V", "delete", "", "id", "Lde/justsoftware/admin/model/itemid/impl/UserGroupId;", "findBy", "", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "findOne", "getAll", "getOne", "getOne$admin_service", "insertOrUpdate", "name", "", "isAllTenantUsersGroup", "", "save", "userGroup", "save$admin_service", "admin-service"})
public class UserGroupDao
implements UserGroupRepository {
    @NotNull
    private final UserGroupRepository repository;

    public UserGroupDao(@NotNull UserGroupRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public void delete(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.delete(id);
    }

    @NotNull
    public List<UserGroup> findBy(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.repository.findBy(tenantId);
    }

    @Nullable
    public UserGroup findOne(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.repository.findOne(id);
    }

    @NotNull
    public List<UserGroup> getAll() {
        return this.repository.getAll();
    }

    public void insertOrUpdate(@NotNull UserGroupId id, @NotNull String name, @NotNull TenantId tenantId, boolean isAllTenantUsersGroup) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.repository.insertOrUpdate(id, name, tenantId, isAllTenantUsersGroup);
    }

    public void save$admin_service(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.repository.insertOrUpdate(userGroup.getId(), userGroup.getName(), userGroup.getTenantId(), userGroup.isAllTenantUsersGroup());
    }

    @NotNull
    public UserGroup getOne$admin_service(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        UserGroup userGroup = this.repository.findOne(id);
        if (userGroup == null) {
            throw new NotFoundException("UserGroup with id " + id + " doesnt exist!");
        }
        return userGroup;
    }
}

