/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user.persistence;

import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.persistence.repository.ProfileRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "", "repository", "Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;", "(Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;)V", "delete", "", "id", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "findOne", "Lde/justsoftware/admin/domain/user/model/Profile;", "profileId", "getOne", "save", "profile", "admin-service"})
public class ProfileDao {
    @NotNull
    private final ProfileRepository repository;

    public ProfileDao(@NotNull ProfileRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public void save(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.repository.insertOrUpdate(profile.getId(), profile.getFirstName(), profile.getLastName(), profile.getEmail(), profile.getImageUrl(), profile.getActive(), profile.getBlocked());
    }

    @Nullable
    public Profile findOne(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.repository.findOne(profileId);
    }

    @NotNull
    public Profile getOne(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Profile profile = this.repository.findOne(id);
        if (profile == null) {
            throw new NotFoundException("Profile with id " + id + " doesnt exist.");
        }
        return profile;
    }

    public void delete(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.delete(id);
    }
}

