/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantDefaultsKt;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.tenant.persistence.TenantRepository;
import de.justsoftware.admin.domain.tenant.persistence.TenantSettingsRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.itemid.impl.DocumentId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010 \u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantService;", "", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "tenantRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantRepository;", "tenantSettingsRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantSettingsRepository;", "(Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/domain/tenant/persistence/TenantRepository;Lde/justsoftware/admin/domain/tenant/persistence/TenantSettingsRepository;)V", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "name", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "globalHighlightColor", "Lde/justsoftware/admin/model/HexColor;", "logoId", "Lde/justsoftware/admin/model/itemid/impl/DocumentId;", "deleteOldTenantLogoFile", "", "user", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "deleteTenant", "findTenant", "getSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "getTenant", "getTenants", "", "resetHighlightColor", "setLogo", "updateDeeplKey", "deeplKey", "updateHighlightColor", "color", "updateName", "tenantName", "admin-service"})
public class TenantService {
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final TenantRepository tenantRepo;
    @NotNull
    private final TenantSettingsRepository tenantSettingsRepo;

    public TenantService(@NotNull DriveApiConnector driveApiConnector, @NotNull TenantRepository tenantRepo, @NotNull TenantSettingsRepository tenantSettingsRepo) {
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        Intrinsics.checkNotNullParameter((Object)tenantSettingsRepo, (String)"tenantSettingsRepo");
        this.driveApiConnector = driveApiConnector;
        this.tenantRepo = tenantRepo;
        this.tenantSettingsRepo = tenantSettingsRepo;
    }

    @NotNull
    public Tenant createTenant(@NotNull String name, @NotNull TenantId tenantId, @NotNull HexColor globalHighlightColor, @Nullable DocumentId logoId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)globalHighlightColor, (String)"globalHighlightColor");
        this.tenantRepo.insertOrUpdateTenant(tenantId, name);
        this.tenantSettingsRepo.upsertTenantSettings(tenantId, globalHighlightColor, logoId, TenantDefaultsKt.getDefaultTenantSettings().getDeeplKey());
        return this.getTenant(tenantId);
    }

    public static /* synthetic */ Tenant createTenant$default(TenantService tenantService, String string, TenantId tenantId, HexColor hexColor, DocumentId documentId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTenant");
        }
        if ((n & 2) != 0) {
            tenantId = TenantId.Companion.random();
        }
        if ((n & 4) != 0) {
            hexColor = TenantDefaultsKt.getDefaultTenantSettings().getGlobalHighlightColor();
        }
        if ((n & 8) != 0) {
            documentId = TenantDefaultsKt.getDefaultTenantSettings().getLogoId();
        }
        return tenantService.createTenant(string, tenantId, hexColor, documentId);
    }

    public void deleteTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantRepo.deleteOne(tenantId);
    }

    @NotNull
    public TenantSettings getSettings(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        TenantSettings tenantSettings = this.tenantSettingsRepo.findOne(tenantId);
        if (tenantSettings == null) {
            throw new NotFoundException("No TenantSettings with tenantId '" + tenantId + "' found!");
        }
        return tenantSettings;
    }

    @Nullable
    public Tenant findTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantRepo.findOne(tenantId);
    }

    @NotNull
    public Tenant getTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Tenant tenant = this.tenantRepo.findOne(tenantId);
        if (tenant == null) {
            throw new NotFoundException("No Tenant with id '" + tenantId + "' found!");
        }
        return tenant;
    }

    @NotNull
    public List<Tenant> getTenants() {
        return this.tenantRepo.getAll();
    }

    @NotNull
    public TenantSettings resetHighlightColor(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantSettingsRepo.updateGlobalHighlightColor(tenantId, TenantDefaultsKt.getDefaultTenantSettings().getGlobalHighlightColor());
        return this.getSettings(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TenantSettings setLogo(@NotNull TenantId tenantId, @Nullable String logoId, @NotNull ProfileId user) {
        DocumentId documentId;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        String string = logoId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.driveApiConnector.addFile(DocumentId.Companion.parse$admin_service(logoId), tenantId, user);
        }
        this.deleteOldTenantLogoFile(tenantId, user);
        TenantSettings tenantSettings = this.getSettings(tenantId);
        TenantSettingsRepository tenantSettingsRepository = this.tenantSettingsRepo;
        TenantId tenantId2 = tenantId;
        HexColor hexColor = tenantSettings.getGlobalHighlightColor();
        String string2 = logoId;
        if (string2 == null) {
            documentId = null;
        } else {
            void it;
            String bl = string2;
            HexColor hexColor2 = hexColor;
            TenantId tenantId3 = tenantId2;
            TenantSettingsRepository tenantSettingsRepository2 = tenantSettingsRepository;
            boolean bl2 = false;
            DocumentId documentId2 = DocumentId.Companion.parse$admin_service((String)it);
            tenantSettingsRepository = tenantSettingsRepository2;
            tenantId2 = tenantId3;
            hexColor = hexColor2;
            documentId = documentId2;
        }
        tenantSettingsRepository.upsertTenantSettings(tenantId2, hexColor, documentId, tenantSettings.getDeeplKey());
        return this.getSettings(tenantId);
    }

    public void updateDeeplKey(@NotNull TenantId tenantId, @Nullable String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantSettingsRepo.updateDeeplKey(tenantId, deeplKey);
    }

    @NotNull
    public TenantSettings updateHighlightColor(@NotNull TenantId tenantId, @NotNull HexColor color) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.tenantSettingsRepo.updateGlobalHighlightColor(tenantId, color);
        return this.getSettings(tenantId);
    }

    @NotNull
    public Tenant updateName(@NotNull TenantId tenantId, @NotNull String tenantName) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)tenantName, (String)"tenantName");
        this.tenantRepo.insertOrUpdateTenant(tenantId, tenantName);
        return this.getTenant(tenantId);
    }

    private void deleteOldTenantLogoFile(TenantId tenantId, ProfileId user) {
        TenantSettings tenantSettings = this.getSettings(tenantId);
        if (tenantSettings.getLogoId() == null) {
            return;
        }
        this.driveApiConnector.deleteFile(tenantSettings.getLogoId(), user);
    }
}

