/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.persistence.TenantPermissionRepository;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0012J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J+\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "", "tenantPermissionRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;)V", "countRemainingManagers", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "add", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "remove", "deleteAllFor", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "granteeId", "findBy", "forEachPermission", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tenantPermission", "save", "tenantPermissions", "savePermission", "updateManagers", "admin-service"})
public class TenantPermissionService {
    @NotNull
    private final TenantPermissionRepository tenantPermissionRepo;

    public TenantPermissionService(@Qualifier(value="TenantPermissionRepository") @NotNull TenantPermissionRepository tenantPermissionRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantPermissionRepo, (String)"tenantPermissionRepo");
        this.tenantPermissionRepo = tenantPermissionRepo;
    }

    @NotNull
    public TenantPermission savePermission(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        this.tenantPermissionRepo.upsert(tenantPermission.getTenantId(), tenantPermission.getGranteeId().asItemId(), tenantPermission.getRole());
        return tenantPermission;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TenantPermission> save(@NotNull List<TenantPermission> tenantPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Iterable $this$map$iv = tenantPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.tenantPermissionRepo.upsert(it.getTenantId(), it.getGranteeId().asItemId(), it.getRole());
            collection.add(it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<TenantPermission> findBy(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantPermissionRepo.findByTenantId(tenantId);
    }

    public void forEachPermission(@NotNull Function1<? super TenantPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.tenantPermissionRepo.forEach(consumer);
    }

    @NotNull
    public List<TenantPermission> updateManagers(@NotNull TenantId tenantId, @NotNull List<? extends GranteeId> add, @NotNull List<? extends GranteeId> remove) {
        TenantPermission tenantPermission;
        GranteeId it;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        if (this.countRemainingManagers(tenantId, add, remove) < 1) {
            throw new IllegalArgumentException("Cant delete the last Manager of a Tenant!");
        }
        Iterable $this$forEach$iv = add;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GranteeId)element$iv;
            boolean bl = false;
            tenantPermission = new TenantPermission(tenantId, it, Role.MANAGER);
            this.tenantPermissionRepo.upsert(tenantPermission.getTenantId(), tenantPermission.getGranteeId().asItemId(), tenantPermission.getRole());
        }
        $this$forEach$iv = remove;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GranteeId)element$iv;
            boolean bl = false;
            tenantPermission = new TenantPermission(tenantId, it, Role.MANAGER);
            this.tenantPermissionRepo.deleteOne(tenantPermission.getTenantId(), tenantPermission.getGranteeId().asItemId());
        }
        return this.tenantPermissionRepo.findByTenantIdAndPermission(tenantId, Role.MANAGER);
    }

    /*
     * WARNING - void declaration
     */
    private int countRemainingManagers(TenantId tenantId, List<? extends GranteeId> add, List<? extends GranteeId> remove) {
        int n;
        void $this$count$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.tenantPermissionRepo.findByTenantIdAndPermission(tenantId, Role.MANAGER);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        $this$map$iv = CollectionsKt.union((Iterable)((List)destination$iv$iv), (Iterable)add);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GranteeId it = (GranteeId)element$iv;
                boolean bl = false;
                if (!(!remove.contains(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @NotNull
    public List<TenantPermission> deleteAllFor(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List permissions = this.tenantPermissionRepo.findBy(granteeId.asItemId());
        this.tenantPermissionRepo.deleteManyBy(granteeId.asItemId());
        return permissions;
    }
}

