/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.IdpConfiguration;
import de.justsoftware.admin.domain.tenant.persistence.TenantIdpConfigRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.itemid.impl.ClientRegistrationId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantIdpConfigService;", "", "tenantIdpConfigRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantIdpConfigRepository;", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantIdpConfigRepository;)V", "findIdpConfiguration", "Lde/justsoftware/admin/domain/tenant/model/IdpConfiguration;", "configId", "Lde/justsoftware/admin/model/itemid/impl/ClientRegistrationId;", "getAll", "", "getIdpConfigurationsForTenant", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "removeDefaultIdpForTenant", "removeIdpConfiguration", "", "setAsDefaultIdpForTenant", "upsertIdpConfiguration", "configuration", "admin-service"})
public class TenantIdpConfigService {
    @NotNull
    private final TenantIdpConfigRepository tenantIdpConfigRepo;

    public TenantIdpConfigService(@NotNull TenantIdpConfigRepository tenantIdpConfigRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantIdpConfigRepo, (String)"tenantIdpConfigRepo");
        this.tenantIdpConfigRepo = tenantIdpConfigRepo;
    }

    @NotNull
    public Set<IdpConfiguration> getAll() {
        return this.tenantIdpConfigRepo.getAll();
    }

    @NotNull
    public IdpConfiguration upsertIdpConfiguration(@NotNull IdpConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.tenantIdpConfigRepo.upsertIdpConfig(configuration);
        IdpConfiguration idpConfiguration = this.tenantIdpConfigRepo.findOne(configuration.getConfigId());
        if (idpConfiguration == null) {
            throw new NotFoundException("No IdP configuration found for configId '" + configuration.getConfigId() + "'!");
        }
        return idpConfiguration;
    }

    @Nullable
    public IdpConfiguration findIdpConfiguration(@NotNull ClientRegistrationId configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return this.tenantIdpConfigRepo.findOne(configId);
    }

    @NotNull
    public Set<IdpConfiguration> getIdpConfigurationsForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }

    public void removeIdpConfiguration(@NotNull ClientRegistrationId configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        this.tenantIdpConfigRepo.deleteOne(configId);
    }

    @NotNull
    public Set<IdpConfiguration> setAsDefaultIdpForTenant(@NotNull ClientRegistrationId configId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantIdpConfigRepo.setAsDefaultForTenant(configId, tenantId);
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }

    @NotNull
    public Set<IdpConfiguration> removeDefaultIdpForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantIdpConfigRepo.removeDefaultIdpForTenant(tenantId);
        return this.tenantIdpConfigRepo.getAllByTenant(tenantId);
    }
}

