/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.domain.appsettings.model.PeopleSettings;
import de.justsoftware.admin.domain.appsettings.persistence.PeopleSettingsRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;", "", "peopleSettingsRepository", "Lde/justsoftware/admin/domain/appsettings/persistence/PeopleSettingsRepository;", "(Lde/justsoftware/admin/domain/appsettings/persistence/PeopleSettingsRepository;)V", "create", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "getSettings", "Lde/justsoftware/admin/domain/appsettings/model/PeopleSettings;", "updateHasManualPeopleExporters", "hasManualPeopleExporters", "", "admin-service"})
public class PeopleSettingsService {
    @NotNull
    private final PeopleSettingsRepository peopleSettingsRepository;

    public PeopleSettingsService(@NotNull PeopleSettingsRepository peopleSettingsRepository) {
        Intrinsics.checkNotNullParameter((Object)peopleSettingsRepository, (String)"peopleSettingsRepository");
        this.peopleSettingsRepository = peopleSettingsRepository;
    }

    public void create(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PeopleSettingsRepository.DefaultImpls.insert$default((PeopleSettingsRepository)this.peopleSettingsRepository, (TenantId)tenantId, (boolean)false, (int)2, null);
    }

    @NotNull
    public PeopleSettings getSettings(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PeopleSettings peopleSettings = this.peopleSettingsRepository.findPeopleSettings(tenantId);
        if (peopleSettings == null) {
            throw new NotFoundException("Cant find PeopleSettings with tenantId: '" + tenantId + "'!");
        }
        return peopleSettings;
    }

    public void updateHasManualPeopleExporters(@NotNull TenantId tenantId, boolean hasManualPeopleExporters) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.peopleSettingsRepository.updateHasManualPeopleExporters(tenantId, hasManualPeopleExporters);
    }
}

