/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.domain.appsettings.AppDefaultsKt;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.PermissionChanges;
import de.justsoftware.admin.domain.appsettings.persistence.AppPermissionRepository;
import de.justsoftware.admin.domain.appsettings.persistence.AppSettingsRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J+\u0010\u0013\u001a\u00020\u00142!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J \u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0016J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\bH\u0016J \u0010$\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0016J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020*0)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "", "appPermissionRepo", "Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;", "appSettingsRepo", "Lde/justsoftware/admin/domain/appsettings/persistence/AppSettingsRepository;", "(Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;Lde/justsoftware/admin/domain/appsettings/persistence/AppSettingsRepository;)V", "deletePermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "granteeId", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "role", "Lde/justsoftware/admin/model/Role;", "findPermission", "forEachPermission", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "appPermission", "getPermission", "getPermissions", "getSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "getSettingsList", "resetAppColors", "save", "appSettings", "saveOrCreateDefault", "presentAppSettings", "setPermissions", "permissionChanges", "Lde/justsoftware/admin/domain/appsettings/model/PermissionChanges;", "updateAppColors", "appColors", "", "Lde/justsoftware/admin/model/HexColor;", "admin-service"})
public class AppSettingsService {
    @NotNull
    private final AppPermissionRepository appPermissionRepo;
    @NotNull
    private final AppSettingsRepository appSettingsRepo;

    public AppSettingsService(@Qualifier(value="AppPermissionRepository") @NotNull AppPermissionRepository appPermissionRepo, @NotNull AppSettingsRepository appSettingsRepo) {
        Intrinsics.checkNotNullParameter((Object)appPermissionRepo, (String)"appPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)appSettingsRepo, (String)"appSettingsRepo");
        this.appPermissionRepo = appPermissionRepo;
        this.appSettingsRepo = appSettingsRepo;
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List toDelete = this.appPermissionRepo.getAllForGrantee(granteeId);
        this.appPermissionRepo.deleteAllForGrantee(granteeId);
        return toDelete;
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        List toDelete = this.appPermissionRepo.getMany(tenantId, app);
        this.appPermissionRepo.deleteAll(tenantId, app);
        return toDelete;
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        List toDelete = this.appPermissionRepo.findByAppAndRole(tenantId, app, role);
        this.appPermissionRepo.deleteByAppAndRole(tenantId, app, role);
        return toDelete;
    }

    @NotNull
    public AppSettings save(@NotNull AppSettings appSettings) {
        Intrinsics.checkNotNullParameter((Object)appSettings, (String)"appSettings");
        this.appSettingsRepo.upsertAppSettings(appSettings.getTenantId(), appSettings.getApp(), appSettings.getColor().toString(), appSettings.getHasManualAppWriterPermissions());
        return this.getSettings(appSettings.getTenantId(), appSettings.getApp());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> saveOrCreateDefault(@NotNull TenantId tenantId, @NotNull List<AppSettings> presentAppSettings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(presentAppSettings, (String)"presentAppSettings");
        CoreApp[] $this$map$iv = CoreApp.values();
        boolean $i$f$map = false;
        CoreApp[] coreAppArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var8_8).length;
        while (n < n2) {
            AppSettings appSettings;
            AppSettings appSettings2;
            Object v0;
            void it;
            Collection collection;
            block3: {
                void item$iv$iv = var8_8[n];
                ++n;
                void var12_12 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                for (Object t : (Iterable)presentAppSettings) {
                    AppSettings appSettings3 = (AppSettings)t;
                    boolean bl2 = false;
                    if (!(appSettings3.getApp() == it)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((appSettings2 = (appSettings = (AppSettings)v0)) == null) {
                appSettings2 = AppDefaultsKt.buildDefaultAppSettings((TenantId)tenantId, (CoreApp)it);
            }
            collection.add(this.save(appSettings2));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List saveOrCreateDefault$default(AppSettingsService appSettingsService, TenantId tenantId, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveOrCreateDefault");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return appSettingsService.saveOrCreateDefault(tenantId, list);
    }

    @NotNull
    public AppSettings setPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull PermissionChanges permissionChanges) {
        AppPermission it;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)permissionChanges, (String)"permissionChanges");
        Iterable iterable = permissionChanges.getRemovePermissions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            this.appPermissionRepo.delete(it.getTenantId(), it.getApp(), it.getGranteeId());
        }
        $this$forEach$iv = permissionChanges.getAddPermissions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            this.appPermissionRepo.upsert(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
        }
        return this.getSettings(tenantId, app);
    }

    @Nullable
    public AppPermission findPermission(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        return this.appPermissionRepo.getOne(tenantId, app, granteeId);
    }

    public void forEachPermission(@NotNull Function1<? super AppPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.appPermissionRepo.forEach(consumer);
    }

    @NotNull
    public AppPermission getPermission(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        AppPermission appPermission = this.appPermissionRepo.getOne(tenantId, app, granteeId);
        if (appPermission == null) {
            throw new NotFoundException("No AppPermission with " + tenantId + ", " + app + ", " + granteeId + " exists!");
        }
        return appPermission;
    }

    @NotNull
    public List<AppPermission> getPermissions(@NotNull TenantId tenantId, @Nullable CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return app != null ? this.appPermissionRepo.getMany(tenantId, app) : this.appPermissionRepo.findBy(tenantId);
    }

    @NotNull
    public AppSettings getSettings(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        AppSettings appSettings = this.appSettingsRepo.findAppSettings(tenantId, app);
        if (appSettings == null) {
            throw new NotFoundException("No app settings found for tenant with id '" + tenantId + "'!");
        }
        return appSettings;
    }

    @NotNull
    public List<AppSettings> getSettingsList(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.appSettingsRepo.getAllAppSettingsByTenantId(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> resetAppColors(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        CoreApp[] $this$map$iv = CoreApp.values();
        boolean $i$f$map = false;
        CoreApp[] coreAppArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var11_13 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSettings(tenantId, (CoreApp)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppSettings it = (AppSettings)element$iv;
            boolean bl = false;
            this.appSettingsRepo.upsertAppSettings(tenantId, it.getApp(), AppDefaultsKt.getDefaultAppSettings().getColor(it.getApp()).toString(), it.getHasManualAppWriterPermissions());
        }
        return this.getSettingsList(tenantId);
    }

    @NotNull
    public List<AppSettings> updateAppColors(@NotNull TenantId tenantId, @NotNull Map<CoreApp, HexColor> appColors) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(appColors, (String)"appColors");
        Map<CoreApp, HexColor> $this$forEach$iv = appColors;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CoreApp, HexColor>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CoreApp, HexColor> element$iv;
            Map.Entry<CoreApp, HexColor> it = element$iv = iterator.next();
            boolean bl = false;
            this.appSettingsRepo.updateColor(tenantId, it.getKey(), it.getValue().toString());
        }
        return this.getSettingsList(tenantId);
    }
}

