/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.drive;

import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.drive.exceptions.DriveApiException;
import de.justsoftware.admin.model.itemid.impl.DocumentId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "", "driveInternalUrl", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "addFile", "Lde/justsoftware/admin/model/itemid/impl/DocumentId;", "documentId", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "userId", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "deleteFile", "", "user", "Companion", "admin-service"})
public class DriveApiConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private static final Logger log;

    public DriveApiConnector(@Value(value="${just.drive.internal}") @NotNull String driveInternalUrl, @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.driveInternalUrl = driveInternalUrl;
        this.restTemplate = restTemplate;
    }

    public void deleteFile(@NotNull DocumentId documentId, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        try {
            this.restTemplate.delete(this.driveInternalUrl + "/file/" + documentId.getId() + "/delete?deletingUser=" + user.getId(), new Object[0]);
        }
        catch (HttpClientErrorException ex) {
            log.warn("deleteFile failed: '" + ex.getResponseBodyAsString() + "'!");
        }
    }

    @NotNull
    public DocumentId addFile(@NotNull DocumentId documentId, @NotNull TenantId tenantId, @NotNull ProfileId userId) {
        Object firstResult;
        Object v1;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)tenantId.asItemId()), TuplesKt.to((Object)"tempFileIds", (Object)SetsKt.setOf((Object)documentId.getId())), TuplesKt.to((Object)"ownerId", (Object)userId.getId())};
        ResponseEntity it = this.restTemplate.postForEntity(this.driveInternalUrl + "/tmp/move", (Object)MapsKt.mapOf((Pair[])pairArray), Map.class, new Object[0]);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            HttpStatus httpStatus = it.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatus, (String)"it.statusCode");
            throw new DriveApiException(documentId, httpStatus);
        }
        Map map = (Map)it.getBody();
        if (map == null) {
            v1 = null;
        } else {
            Collection collection = map.values();
            if (collection == null) {
                v1 = null;
            } else {
                Iterator iterator = collection.iterator();
                v1 = iterator == null ? null : iterator.next();
            }
        }
        Object v4 = firstResult = v1;
        if (v4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.LinkedHashMap<*, *>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<*, *> }");
        }
        String responseId = String.valueOf(((Map)v4).get("id"));
        UUID uUID = UUID.fromString(responseId);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(responseId)");
        return new DocumentId(uUID);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DriveApiConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DriveApiConnector::class.java)");
        log = logger;
    }
}

