/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.application.web.model.ColorThemeInput;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.config.ServerConfigService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.PeopleSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.deletedtenant.DeletedTenantService;
import de.justsoftware.admin.domain.deletedtenant.model.DeletedTenant;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0012J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0017J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0017JN\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u001f2\b\b\u0002\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0012J@\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u001f2\b\b\u0002\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0012J\u001a\u0010/\u001a\u0004\u0018\u00010\u001f2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020#H\u0016J\u001e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u00101\u001a\u00020#H\u0016J\u0018\u00105\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020#H\u0016J\u001a\u00106\u001a\u0004\u0018\u00010*2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00101\u001a\u00020#H\u0016J\u0018\u00107\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00101\u001a\u00020#H\u0016J\u0018\u00108\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0017J\u0018\u00109\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0017J\"\u0010:\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010;\u001a\u0004\u0018\u00010!2\u0006\u00101\u001a\u00020#H\u0017J \u0010<\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020>2\u0006\u00101\u001a\u00020#H\u0017J \u0010?\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020A2\u0006\u0010\"\u001a\u00020#H\u0017J\"\u0010B\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010C\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J:\u0010D\u001a\b\u0012\u0004\u0012\u0002030\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020!0\u001c2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\"\u001a\u00020#H\u0017J \u0010G\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020#H\u0017R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lde/justsoftware/admin/application/web/TenantApplicationService;", "", "deletedTenantService", "Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "peopleSettingsService", "Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "serverConfigService", "Lde/justsoftware/admin/config/ServerConfigService;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/config/ServerConfigService;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "checkAllGranteesAreMemberOfTenant", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "granteesToAdd", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "name", "", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "deleteTenant", "fetchAndPublishNewTenant", "tenant", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "tenantManagers", "allAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "fetchAndPublishUpdatedTenant", "findOne", "id", "authorizationContext", "findPermissionsBy", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "getAllTenants", "getOne", "getTenantInvitation", "getTenantSettings", "resetAppColors", "resetGlobalHighlightColor", "setLogo", "logoId", "setTenantInvitationActive", "isInvitationActive", "", "updateColorTheme", "input", "Lde/justsoftware/admin/application/web/model/ColorThemeInput;", "updateDeeplKey", "deeplKey", "updateManagers", "add", "remove", "updateTenantName", "admin-service"})
public class TenantApplicationService {
    @NotNull
    private final DeletedTenantService deletedTenantService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final PeopleSettingsService peopleSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ServerConfigService serverConfigService;
    @NotNull
    private final TransactionSupport transactionSupport;

    public TenantApplicationService(@NotNull DeletedTenantService deletedTenantService, @NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService, @NotNull TenantInvitationService tenantInvitationService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull AppSettingsService appSettingsService, @NotNull PeopleSettingsService peopleSettingsService, @NotNull Publisher publisher, @NotNull ServerConfigService serverConfigService, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)deletedTenantService, (String)"deletedTenantService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsService, (String)"peopleSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)serverConfigService, (String)"serverConfigService");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.deletedTenantService = deletedTenantService;
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
        this.tenantInvitationService = tenantInvitationService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.appSettingsService = appSettingsService;
        this.peopleSettingsService = peopleSettingsService;
        this.publisher = publisher;
        this.serverConfigService = serverConfigService;
        this.transactionSupport = transactionSupport;
    }

    @Transactional
    @NotNull
    public Tenant createTenant(@NotNull String name, @NotNull AuthorizationContext authContext) {
        boolean tenantExists;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkSuperAdmin();
        boolean bl = tenantExists = !((Collection)this.tenantService.getTenants()).isEmpty();
        if (tenantExists && !this.serverConfigService.isMultiTenantCreationEnabled()) {
            throw new NotAllowedException("Tenant creation is disabled.");
        }
        ProfileId currentUserId = authContext.getUserProfileId();
        Tenant tenant = TenantService.createTenant$default((TenantService)this.tenantService, (String)name, null, null, null, (int)14, null);
        ArrayList<GranteeId> tenantManagers = new ArrayList<GranteeId>();
        if (!Intrinsics.areEqual((Object)currentUserId, (Object)new ProfileId(0L))) {
            TenantPermission tenantPermission = this.tenantPermissionService.savePermission(new TenantPermission(tenant.getId(), (GranteeId)currentUserId, de.justsoftware.admin.model.Role.MANAGER));
            tenantManagers.add(tenantPermission.getGranteeId());
        }
        List allDefaultAppSettings = AppSettingsService.saveOrCreateDefault$default((AppSettingsService)this.appSettingsService, (TenantId)tenant.getId(), null, (int)2, null);
        this.peopleSettingsService.create(tenant.getId());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteTenant(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        List tenantPermissions = this.tenantPermissionService.findBy(tenantId);
        CoreApp[] coreAppArray = CoreApp.values();
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var15_14 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.appSettingsService.deletePermissions(tenantId, (CoreApp)it));
        }
        List deletedAppPermissions = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        this.tenantService.deleteTenant(tenantId);
        this.deletedTenantService.create(new DeletedTenant(tenantId, tenant.getName(), authContext.getUserProfileId()));
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    @NotNull
    public Tenant resetAppColors(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        List allAppSettings = this.appSettingsService.resetAppColors(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant resetGlobalHighlightColor(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = this.tenantService.resetHighlightColor(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant updateColorTheme(@NotNull TenantId tenantId, @NotNull ColorThemeInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = input.getHighlight() != null ? this.tenantService.updateHighlightColor(tenantId, HexColor.Companion.fromString(input.getHighlight())) : this.tenantService.getSettings(tenantId);
        List allAppSettings = this.appSettingsService.updateAppColors(tenantId, input.toAppColorMap());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @NotNull
    public Tenant updateDeeplKey(@NotNull TenantId tenantId, @Nullable String deeplKey, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        this.tenantService.updateDeeplKey(tenantId, deeplKey);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        TenantApplicationService.fetchAndPublishUpdatedTenant$default((TenantApplicationService)this, (TenantId)tenantId, (Tenant)tenant, null, null, null, (int)28, null);
        return tenant;
    }

    @NotNull
    public List<Tenant> getAllTenants(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkSuperAdmin();
        return this.tenantService.getTenants();
    }

    @Transactional
    @NotNull
    public Tenant updateTenantName(@NotNull TenantId id, @NotNull String name, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        Tenant tenant = this.tenantService.updateName(id, name);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public Tenant findOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.findTenant(id);
    }

    @NotNull
    public Tenant getOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.getTenant(id);
    }

    @NotNull
    public List<TenantPermission> findPermissionsBy(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.tenantPermissionService.findBy(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public List<TenantPermission> updateManagers(@NotNull TenantId tenantId, @NotNull List<String> add, @NotNull List<String> remove, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Iterable $this$map$iv = add;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.from((String)it));
        }
        List addGranteeIds = (List)destination$iv$iv;
        this.checkAllGranteesAreMemberOfTenant(tenantId, addGranteeIds);
        Iterable $this$map$iv2 = remove;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(GranteeId.Companion.from((String)it));
        }
        List removeGranteeIds = (List)destination$iv$iv2;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantPermissionService.updateManagers(tenantId, addGranteeIds, removeGranteeIds);
    }

    @NotNull
    public TenantSettings getTenantSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.tenantService.getSettings(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant setLogo(@NotNull TenantId tenantId, @Nullable String logoId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = this.tenantService.setLogo(tenantId, logoId, authorizationContext.getUserProfileId());
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public TenantInvitation getTenantInvitation(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(tenantId));
    }

    @Transactional
    @NotNull
    public Tenant setTenantInvitationActive(@NotNull TenantId tenantId, boolean isInvitationActive, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        this.tenantInvitationService.setTenantInvitationActive(tenantId, isInvitationActive);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    /*
     * WARNING - void declaration
     */
    private void checkAllGranteesAreMemberOfTenant(TenantId tenantId, List<? extends GranteeId> granteesToAdd) {
        void $this$mapTo$iv$iv;
        if (granteesToAdd.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = granteesToAdd;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GranteeId granteeId = (GranteeId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.asItemId()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)tenantId.asItemId()), granteeRoles)) {
            throw new NotAllowedException("Not all users are members of " + tenantId);
        }
    }

    private void fetchAndPublishNewTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<? extends GranteeId> tenantManagers, List<AppSettings> allAppSettings) {
        this.publisher.publishNewTenant(tenant, tenantSettings, allAppSettings, tenantManagers, tenantInvitation);
    }

    static /* synthetic */ void fetchAndPublishNewTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishNewTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x20) != 0) {
            list2 = tenantApplicationService.appSettingsService.getSettingsList(tenantId);
        }
        tenantApplicationService.fetchAndPublishNewTenant(tenantId, tenant, tenantSettings, tenantInvitation, list, list2);
    }

    private void fetchAndPublishUpdatedTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<AppSettings> allAppSettings) {
        this.publisher.publishUpdatedTenant(tenant, tenantSettings, tenantInvitation, allAppSettings);
    }

    static /* synthetic */ void fetchAndPublishUpdatedTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishUpdatedTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x10) != 0) {
            list = tenantApplicationService.appSettingsService.getSettingsList(tenantId);
        }
        tenantApplicationService.fetchAndPublishUpdatedTenant(tenantId, tenant, tenantSettings, tenantInvitation, list);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(TenantApplicationService $this) {
        return $this.publisher;
    }
}

