/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.PeopleSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.PeopleSettings;
import de.justsoftware.admin.domain.appsettings.model.PermissionChanges;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/admin/application/web/PeopleSettingsApplicationService;", "", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "peopleSettingsService", "Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "getExporterPermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "getPeopleSettings", "Lde/justsoftware/admin/domain/appsettings/model/PeopleSettings;", "setExporterPermissions", "", "add", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "remove", "setHasManualPeopleExporters", "hasManualPeopleExporters", "", "admin-service"})
public class PeopleSettingsApplicationService {
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final PeopleSettingsService peopleSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;

    public PeopleSettingsApplicationService(@NotNull AppSettingsService appSettingsService, @NotNull PeopleSettingsService peopleSettingsService, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsService, (String)"peopleSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.appSettingsService = appSettingsService;
        this.peopleSettingsService = peopleSettingsService;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppPermission> getExporterPermissions(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Iterable $this$filter$iv = this.appSettingsService.getPermissions(tenantId, CoreApp.PEOPLE);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AppPermission it = (AppPermission)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == Role.EXPORTER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public PeopleSettings getPeopleSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.peopleSettingsService.getSettings(tenantId);
    }

    @Transactional
    public void setHasManualPeopleExporters(@NotNull TenantId tenantId, boolean hasManualPeopleExporters, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        PeopleSettings settings = this.peopleSettingsService.getSettings(tenantId);
        if (settings.getHasManualExporters() == hasManualPeopleExporters) {
            return;
        }
        this.peopleSettingsService.updateHasManualPeopleExporters(tenantId, hasManualPeopleExporters);
        List permissionsToRemove = hasManualPeopleExporters ? CollectionsKt.emptyList() : this.appSettingsService.deletePermissions(tenantId, CoreApp.PEOPLE, Role.EXPORTER);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    public void setExporterPermissions(@NotNull List<? extends GranteeId> add, @NotNull List<? extends GranteeId> remove, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        authContext.checkAllTenantReader((Collection)add);
        TenantId tenantId = authContext.getTenantId();
        if (tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TenantId tenantId2 = tenantId;
        PeopleSettings peopleSettings = this.peopleSettingsService.getSettings(tenantId2);
        if (!peopleSettings.getHasManualExporters()) {
            throw new NotAllowedException("Manual exporters are currently disabled!");
        }
        Iterable $this$map$iv = add;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            GranteeId granteeId = (GranteeId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppPermission(tenantId2, CoreApp.PEOPLE, (GranteeId)it, Role.EXPORTER));
        }
        List addPermissions = (List)destination$iv$iv;
        Iterable $this$map$iv2 = remove;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GranteeId bl = (GranteeId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new AppPermission(tenantId2, CoreApp.PEOPLE, (GranteeId)it, Role.EXPORTER));
        }
        List removePermissions = (List)destination$iv$iv2;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        PermissionChanges validChanges = new PermissionChanges(addPermissions, removePermissions);
        this.appSettingsService.setPermissions(tenantId2, CoreApp.PEOPLE, validChanges);
    }

    public static /* synthetic */ void setExporterPermissions$default(PeopleSettingsApplicationService peopleSettingsApplicationService, List list, List list2, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setExporterPermissions");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        peopleSettingsApplicationService.setExporterPermissions(list, list2, authorizationContext);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(PeopleSettingsApplicationService $this) {
        return $this.publisher;
    }
}

