/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.PermissionChanges;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0012J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0017J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J<\u0010\u001c\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/admin/application/web/AppSettingsApplicationService;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "checkAllGranteesAreMemberOfTenant", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "permissionChanges", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "disableManualPermissions", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "authorizationContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "enableManualPermissions", "authCtx", "getAppPermissions", "getAppSettings", "setAppWriterPermissions", "addPermissions", "removePermissions", "admin-service"})
public class AppSettingsApplicationService {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;

    public AppSettingsApplicationService(@NotNull PermissionRequestConnector permissionRequestConnector, @NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.permissionRequestConnector = permissionRequestConnector;
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
    }

    @Transactional
    @NotNull
    public AppSettings setAppWriterPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull List<AppPermission> addPermissions, @NotNull List<AppPermission> removePermissions, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(addPermissions, (String)"addPermissions");
        Intrinsics.checkNotNullParameter(removePermissions, (String)"removePermissions");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)addPermissions, (Iterable)removePermissions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPermission it = (AppPermission)element$iv;
            boolean bl = false;
            if (it.getRole() == de.justsoftware.admin.model.Role.WRITER) continue;
            boolean bl2 = false;
            String string = "Only inputs with Role.WRITER are allowed!";
            throw new IllegalArgumentException(string.toString());
        }
        AppSettings appSettings = this.appSettingsService.getSettings(tenantId, app);
        if (!appSettings.getHasManualAppWriterPermissions()) {
            throw new NotAllowedException("Manual permissions are currently disabled!");
        }
        this.checkAllGranteesAreMemberOfTenant(tenantId, addPermissions);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        PermissionChanges validChanges = new PermissionChanges(addPermissions, removePermissions);
        return this.appSettingsService.setPermissions(tenantId, app, validChanges);
    }

    @Transactional
    @NotNull
    public AppSettings disableManualPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        AppSettings oldSettings = this.appSettingsService.getSettings(tenantId, app);
        List deletedPermissions = this.appSettingsService.deletePermissions(tenantId, app, de.justsoftware.admin.model.Role.WRITER);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.appSettingsService.save(new AppSettings(oldSettings.getTenantId(), oldSettings.getApp(), oldSettings.getColor(), false));
    }

    @Transactional
    @NotNull
    public AppSettings enableManualPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        authCtx.checkTenantManager(tenantId);
        AppSettings oldSettings = this.appSettingsService.getSettings(tenantId, app);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.appSettingsService.save(new AppSettings(oldSettings.getTenantId(), oldSettings.getApp(), oldSettings.getColor(), true));
    }

    @NotNull
    public List<AppSettings> getAppSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getSettingsList(tenantId);
    }

    @NotNull
    public AppSettings getAppSettings(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getSettings(tenantId, app);
    }

    @NotNull
    public List<AppPermission> getAppPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getPermissions(tenantId, app);
    }

    /*
     * WARNING - void declaration
     */
    private void checkAllGranteesAreMemberOfTenant(TenantId tenantId, List<AppPermission> permissionChanges) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = permissionChanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPermission appPermission = (AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.getGranteeId().asItemId()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)tenantId.asItemId()), granteeRoles)) {
            throw new NotAllowedException("Not all users are members of " + tenantId);
        }
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(AppSettingsApplicationService $this) {
        return $this.publisher;
    }
}

