/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.kafka;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.PeopleSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.deletedtenant.DeletedTenantService;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.kafka.model.TenantKafkaDto;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.admin.model.itemid.impl.UserGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0017J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0017JN\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u000e\b\u0002\u0010-\u001a\b\u0012\u0004\u0012\u00020.0+H\u0012J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J\u0018\u00102\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;", "", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "peopleSettingsService", "Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "deletedTenantService", "Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "(Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;Lde/justsoftware/admin/domain/user/UserService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;)V", "addTenantFromKafka", "", "tenantKafkaDto", "Lde/justsoftware/admin/kafka/model/TenantKafkaDto;", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "deleteProfileFromKafka", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "profileId", "deleteProfileTenantRelation", "deleteUserGroupFromKafka", "Lde/justsoftware/admin/model/itemid/impl/UserGroupId;", "userGroupId", "fetchAndPublishNewTenant", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "tenant", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "tenantManagers", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "allAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "saveProfileFromKafka", "Lde/justsoftware/admin/domain/user/model/Profile;", "profile", "saveProfileTenantRelation", "saveUserGroupFromKafka", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "userGroup", "admin-service"})
public class KafkaConsumerApplicationService {
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final PeopleSettingsService peopleSettingsService;
    @NotNull
    private final UserService userService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final DeletedTenantService deletedTenantService;

    public KafkaConsumerApplicationService(@NotNull TenantService tenantService, @NotNull TenantInvitationService tenantInvitationService, @NotNull TenantPermissionService tenantPermissionService, @NotNull AppSettingsService appSettingsService, @NotNull PeopleSettingsService peopleSettingsService, @NotNull UserService userService, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport, @NotNull DeletedTenantService deletedTenantService) {
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsService, (String)"peopleSettingsService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)deletedTenantService, (String)"deletedTenantService");
        this.tenantService = tenantService;
        this.tenantInvitationService = tenantInvitationService;
        this.tenantPermissionService = tenantPermissionService;
        this.appSettingsService = appSettingsService;
        this.peopleSettingsService = peopleSettingsService;
        this.userService = userService;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
        this.deletedTenantService = deletedTenantService;
    }

    @Transactional
    @NotNull
    public ProfileId deleteProfileFromKafka(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Profile profile = this.userService.findProfile(profileId);
        if (profile != null) {
            Profile it = profile;
            boolean bl = false;
            List deletedAppPermissions = this.appSettingsService.deletePermissions((GranteeId)profileId);
            List tenantManagerPermissions = this.tenantPermissionService.deleteAllFor((GranteeId)profileId);
            this.userService.deleteProfile(profileId);
            this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        return profileId;
    }

    @Transactional
    @NotNull
    public UserGroupId deleteUserGroupFromKafka(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        UserGroup userGroup = this.userService.findUserGroup(userGroupId);
        if (userGroup != null) {
            UserGroup it = userGroup;
            boolean bl = false;
            List deletedAppPermissions = this.appSettingsService.deletePermissions((GranteeId)userGroupId);
            this.userService.deleteUserGroup(userGroupId);
            this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        return userGroupId;
    }

    @NotNull
    public Profile saveProfileFromKafka(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.userService.saveProfile(profile);
    }

    public void saveProfileTenantRelation(@NotNull ProfileId profileId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.userService.saveProfileTenantRelation(profileId, tenantId);
    }

    public void deleteProfileTenantRelation(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.userService.deleteProfileTenantRelation(profileId);
    }

    @Transactional
    @NotNull
    public UserGroup saveUserGroupFromKafka(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.userService.saveUserGroup(userGroup);
    }

    @Transactional
    public void addTenantFromKafka(@NotNull TenantKafkaDto tenantKafkaDto) {
        boolean deletedTenant;
        Intrinsics.checkNotNullParameter((Object)tenantKafkaDto, (String)"tenantKafkaDto");
        TenantId tenantId = tenantKafkaDto.getTenantId();
        boolean bl = deletedTenant = this.deletedTenantService.findDeletedTenant(tenantId) != null;
        if (!deletedTenant && this.tenantService.findTenant(tenantId) == null) {
            this.createTenant(tenantKafkaDto);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tenant createTenant(TenantKafkaDto tenantKafkaDto) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Tenant tenant = this.tenantService.createTenant(tenantKafkaDto.getName(), tenantKafkaDto.getTenantId(), tenantKafkaDto.getTenantSettings$admin_service().getGlobalHighlightColor(), tenantKafkaDto.getTenantSettings$admin_service().getLogoId());
        Iterable iterable = this.tenantPermissionService.save(tenantKafkaDto.getTenantManagerPermissions$admin_service());
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        List tenantManagerIds = (List)destination$iv$iv;
        List allAppSettings = this.appSettingsService.saveOrCreateDefault(tenant.getId(), tenantKafkaDto.getAppSettings$admin_service());
        this.peopleSettingsService.create(tenant.getId());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    private void fetchAndPublishNewTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<? extends GranteeId> tenantManagers, List<AppSettings> allAppSettings) {
        this.publisher.publishNewTenant(tenant, tenantSettings, allAppSettings, tenantManagers, tenantInvitation);
    }

    static /* synthetic */ void fetchAndPublishNewTenant$default(KafkaConsumerApplicationService kafkaConsumerApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishNewTenant");
        }
        if ((n & 2) != 0) {
            tenant = kafkaConsumerApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = kafkaConsumerApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)kafkaConsumerApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x20) != 0) {
            list2 = kafkaConsumerApplicationService.appSettingsService.getSettingsList(tenantId);
        }
        kafkaConsumerApplicationService.fetchAndPublishNewTenant(tenantId, tenant, tenantSettings, tenantInvitation, list, list2);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(KafkaConsumerApplicationService $this) {
        return $this.publisher;
    }
}

