/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.external;

import de.justsoftware.admin.application.external.controller.model.FreeTrialForm;
import de.justsoftware.admin.application.external.exceptions.CloudRegistrationFailedException;
import de.justsoftware.admin.application.external.exceptions.CreateFirstUserFailedException;
import de.justsoftware.admin.application.external.exceptions.CreateTenantFailedException;
import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.config.ServerConfigService;
import de.justsoftware.admin.connector.profile.InternalCreateProfileModel;
import de.justsoftware.admin.connector.profile.ProfileConnector;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.PeopleSettingsService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0011\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0011\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/admin/application/external/CloudRegistrationApplicationService;", "", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "peopleSettingsService", "Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;", "jwtGenerator", "Lde/justsoftware/jwtfilter/generator/JwtGenerator;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "profileConnector", "Lde/justsoftware/admin/connector/profile/ProfileConnector;", "serverConfigService", "Lde/justsoftware/admin/config/ServerConfigService;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/PeopleSettingsService;Lde/justsoftware/jwtfilter/generator/JwtGenerator;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/connector/profile/ProfileConnector;Lde/justsoftware/admin/config/ServerConfigService;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "createAndPublishTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantName", "", "createAndPublishTenant$admin_service", "createFirstUserAndPublishPermission", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "freeTrialForm", "Lde/justsoftware/admin/application/external/controller/model/FreeTrialForm;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "createFirstUserAndPublishPermission$admin_service", "createFreeTrial", "createJwt", "profileId", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "admin-service"})
public class CloudRegistrationApplicationService {
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final PeopleSettingsService peopleSettingsService;
    @NotNull
    private final JwtGenerator jwtGenerator;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ProfileConnector profileConnector;
    @NotNull
    private final ServerConfigService serverConfigService;
    @NotNull
    private final TransactionSupport transactionSupport;

    public CloudRegistrationApplicationService(@NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService, @NotNull AppSettingsService appSettingsService, @NotNull PeopleSettingsService peopleSettingsService, @NotNull JwtGenerator jwtGenerator, @NotNull Publisher publisher, @NotNull ProfileConnector profileConnector, @NotNull ServerConfigService serverConfigService, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsService, (String)"peopleSettingsService");
        Intrinsics.checkNotNullParameter((Object)jwtGenerator, (String)"jwtGenerator");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)profileConnector, (String)"profileConnector");
        Intrinsics.checkNotNullParameter((Object)serverConfigService, (String)"serverConfigService");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
        this.appSettingsService = appSettingsService;
        this.peopleSettingsService = peopleSettingsService;
        this.jwtGenerator = jwtGenerator;
        this.publisher = publisher;
        this.profileConnector = profileConnector;
        this.serverConfigService = serverConfigService;
        this.transactionSupport = transactionSupport;
    }

    @NotNull
    public String createFreeTrial(@NotNull FreeTrialForm freeTrialForm) {
        TenantPermission tenantPermission;
        Tenant tenant;
        Intrinsics.checkNotNullParameter((Object)freeTrialForm, (String)"freeTrialForm");
        if (!this.serverConfigService.isCloudRegistrationEnabled()) {
            throw new NotAllowedException("Cloud registration is disabled.");
        }
        if (!this.serverConfigService.isMultiTenantCreationEnabled()) {
            throw new NotAllowedException("Tenant creation is disabled.");
        }
        try {
            tenant = this.createAndPublishTenant$admin_service(freeTrialForm.getTenantName());
        }
        catch (CreateTenantFailedException ex) {
            throw new CloudRegistrationFailedException((Exception)((Object)ex));
        }
        Tenant newTenant = tenant;
        try {
            tenantPermission = this.createFirstUserAndPublishPermission$admin_service(freeTrialForm, newTenant.getId());
        }
        catch (CreateFirstUserFailedException ex) {
            this.tenantService.deleteTenant(newTenant.getId());
            List tenantManagers = CollectionsKt.emptyList();
            Publisher.publishDeletedTenant$default((Publisher)this.publisher, (TenantId)newTenant.getId(), (List)tenantManagers, null, (int)4, null);
            throw new CloudRegistrationFailedException((Exception)((Object)ex));
        }
        TenantPermission tenantPermission2 = tenantPermission;
        return this.createJwt(newTenant.getId(), (ProfileId)tenantPermission2.getGranteeId());
    }

    @Transactional
    @NotNull
    public Tenant createAndPublishTenant$admin_service(@NotNull String tenantName) {
        Tenant tenant;
        Intrinsics.checkNotNullParameter((Object)tenantName, (String)"tenantName");
        try {
            Tenant it = tenant = TenantService.createTenant$default((TenantService)this.tenantService, (String)tenantName, null, null, null, (int)14, null);
            boolean bl = false;
            AppSettingsService.saveOrCreateDefault$default((AppSettingsService)this.appSettingsService, (TenantId)it.getId(), null, (int)2, null);
            this.peopleSettingsService.create(it.getId());
        }
        catch (RuntimeException ex) {
            throw new CreateTenantFailedException();
        }
        Tenant newTenant = tenant;
        this.publisher.publishNewTenant(newTenant, this.tenantService.getSettings(newTenant.getId()), this.appSettingsService.getSettingsList(newTenant.getId()), CollectionsKt.emptyList(), null).waitForCompletion();
        return newTenant;
    }

    @Transactional
    @NotNull
    public TenantPermission createFirstUserAndPublishPermission$admin_service(@NotNull FreeTrialForm freeTrialForm, @NotNull TenantId tenantId) {
        TenantPermission tenantPermission;
        Intrinsics.checkNotNullParameter((Object)freeTrialForm, (String)"freeTrialForm");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        try {
            InternalCreateProfileModel createProfileModel = InternalCreateProfileModel.Companion.fromFreeTrialForm(freeTrialForm, tenantId);
            ProfileId firstUser = this.profileConnector.createProfile(createProfileModel);
            tenantPermission = this.tenantPermissionService.savePermission(new TenantPermission(tenantId, (GranteeId)firstUser, Role.MANAGER));
        }
        catch (RuntimeException ex) {
            throw new CreateFirstUserFailedException((Exception)ex);
        }
        TenantPermission tenantPermission2 = tenantPermission;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenantPermission2;
    }

    private String createJwt(TenantId tenantId, ProfileId profileId) {
        Object object = new JwtClaimsBuilder().withSubject(String.valueOf(profileId.getId())).withCustomClaim("tenantId", tenantId.asItemId()).withLifetime(120L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JwtClaimsBuilder()\n//   \u2026uration.DEFAULT_LIFETIME)");
        JwtClaimsBuilder claimsBuilder = object;
        object = this.jwtGenerator.generateJWT(claimsBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jwtGenerator.generateJWT(claimsBuilder)");
        return object;
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(CloudRegistrationApplicationService $this) {
        return $this.publisher;
    }
}

