--liquibase formatted sql
--preconditions dbms:postgresql

--changeset tsubklewe:initialize_database_from_dump
--preconditions onFail:MARK_RAN onError:HALT
--precondition-sql-check expectedResult:0 select count(*) from person;
--validCheckSum: 8:40ead0f1eac793cd59ff3d8a9bb3e515
/*
The init-data changelog may change after time to setup new systems according to changed configuration.
To avoid broken systems, that applied an old version of the changelog, we configure the correct checksum here.
By doing this, these systems will just ignore the changed checksum.

To generate the validCheckSum after changing this file:

cd juco-services
../gradlew dropAll
../gradlew test

Wait for tests to complete.
Get the new checksum by executing:

psql -h localhost -U justconnect justconnect_test -c "SELECT md5sum from databasechangelog where filename='liquibase/postgresql.init_data.sql'";

Warning: Don't do this with normal patchsets in db.changelog.sql!!
*/


-- following tables were not dumped:
-- version
-- base_property
-- domain_property
-- properties_tmp
-- dbmaintain_scripts
INSERT INTO public.language (id, name, translated) VALUES ('ar', 'Arabic', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('az', 'Azerbaijani', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('bg', 'Bulgarian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('bs', 'Bosnian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ca', 'Catalan', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('cs', 'Czech', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('da', 'Danish', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('el', 'Greek', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('es', 'Español', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('fa', 'Persian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('fi', 'Finnish', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('fr', 'Français', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ga', 'Irish', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('gd', 'Scottish Gaelic', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('hi', 'Hindi', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('hr', 'Croatian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('hu', 'Hungarian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('id', 'Indonesian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('it', 'Italiano', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ja', 'Japanese', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ko', 'Korean', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ku', 'Kurdish', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('nl', 'Dutch', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('no', 'Norwegian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('pl', 'Polski', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ps', 'Pashto', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('pt', 'Português', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('qu', 'Quechua', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ro', 'Romanian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ru', 'Russian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('sk', 'Slovak', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('sl', 'Slovenian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('sq', 'Albanian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('sr', 'Serbian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('su', 'Sundanese', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('sv', 'Swedish', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('th', 'Thai', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('tl', 'Tagalog', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('tr', 'Türkçe', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('uk', 'Ukrainian', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('ur', 'Urdu', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('zu', 'Uzbek', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('vi', 'Vietnamese', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('zh', 'Chinese', 'f');
INSERT INTO public.language (id, name, translated) VALUES ('de', 'Deutsch', 't');
INSERT INTO public.language (id, name, translated) VALUES ('en', 'English', 't');
INSERT INTO public.language (id, name, translated) VALUES ('mt', 'Malti', 'f');
INSERT INTO public.person (id, last_login, show_tempstartpage, account_active, title, firstname, surname, email, newmail, birthday, password_hash, keywords, language_id, password_question, password_answer, registerdate, terms_accepted, image, blocked, default_timezone, modified_at, created_at, birthday_visibility, hashed_id, additional_title, deleted) VALUES (-1, now(), 't', 'f', NULL, 'deleted user', 'deleted user', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, now(), NULL, NULL, 'f', NULL, now(), now(), 'NONE', 'xxxxxxxx', NULL, 't');
INSERT INTO public.person (id, last_login, show_tempstartpage, account_active, title, firstname, surname, email, newmail, birthday, password_hash, keywords, language_id, password_question, password_answer, registerdate, terms_accepted, image, blocked, default_timezone, modified_at, created_at, birthday_visibility, hashed_id, additional_title, deleted) VALUES (0, now(), 't', 't', NULL, 'Admin', 'Just Software AG', 'admin@justsoftwareag.com', NULL, '1900-01-01', '$2y$12$6FLXdVmYLEhCOnmIZWgSu.kqWLn3KSaVoDXRoIOQHpC9CZS6EHiMy', NULL, 'de', NULL, NULL, now(), 't', NULL, 'f', NULL, now(), now(), 'NONE', '35d61ef5a4a09fa225646e57d08506e8', NULL, 'f');
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('news', 'News', 't', 0, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('wiki', 'Wiki', 't', 2, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('chat', 'Connect', 't', 1, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('connect', 'Profile', 't', 3, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('drive', 'Drive', 't', 4, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('tasks', 'List', 't', 5, now(), now());
INSERT INTO public.app (id, name, is_core_app, default_order, ctime, mtime) VALUES ('people', 'People', 't', 6, now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('news', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('chat', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('drive', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('tasks', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('people', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('wiki', 'ALL', 'FORCED', now(), now());
INSERT INTO public.default_app_visibility (app_id, visible_for_role, visibility, ctime, mtime) VALUES ('connect', 'ALL', 'INVISIBLE', now(), now());
INSERT INTO public.entity_type_name (name) VALUES ('NETWORK');
INSERT INTO public.entity_type_name (name) VALUES ('GROUP');
INSERT INTO public.entity_type_name (name) VALUES ('WIKI');
INSERT INTO public.entity_type_name (name) VALUES ('APPOINTMENT');
INSERT INTO public.entity_type_name (name) VALUES ('PUBLICATION');
INSERT INTO public.entity_type_name (name) VALUES ('TOPIC');
INSERT INTO public.entity_type_name (name) VALUES ('PARTNERSITE');
INSERT INTO public.entity_type_name (name) VALUES ('ARTICLE');
INSERT INTO public.entity_type_name (name) VALUES ('SIMPLETASK');
INSERT INTO public.entity_type_name (name) VALUES ('NEUIGKEIT');
INSERT INTO public.entity_type_name (name) VALUES ('ARCHIVE');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (0, '', 'application/octet-stream', 'Binary', 'other.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (1, 'doc', 'application/ms-word', 'Microsoft Word File', 'doc.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (3, 'gif', 'image/gif', 'GIF Image', 'gif.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (4, 'jpg', 'image/jpeg', 'JPEG Image', 'jpg.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (5, 'jpeg', 'image/jpeg', 'JPEG Image', 'jpg.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (6, 'pdf', 'application/pdf', 'Adobe PDF File', 'pdf.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (7, 'png', 'image/png', 'PNG Image', 'png.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (8, 'pps', 'application/ms-powerpoint', 'Microsoft Powerpoint File', 'pps.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (9, 'ppt', 'application/ms-powerpoint', 'Microsoft Powerpoint File', 'ppt.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (11, 'txt', 'text/plain', 'Plain Text', 'txt.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (12, 'xls', 'application/ms-excel', 'Microsoft Excel File', 'xls.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (14, 'zip', 'application/zip', 'Zip Archive', 'zip.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (15, 'odt', 'application/vnd.oasis.opendocument.text', 'OpenDocument Text', 'odt.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (16, 'odp', 'application/vnd.oasis.opendocument.presentation', 'OpenDocument Presentation', 'odp.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (17, 'ods', 'application/vnd.oasis.opendocument.spreadsheet', 'OpenDocument Spreadsheet', 'ods.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (18, 'odg', 'application/vnd.oasis.opendocument.graphics', 'OpenDocument Drawing', 'odg.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (19, 'ott', 'application/vnd.oasis.opendocument.text-template', 'OpenDocument Text Template', 'ott.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (20, 'otp', 'application/vnd.oasis.opendocument.presentation-template', 'OpenDocument Presentation Template', 'otp.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (21, 'ots', 'application/vnd.oasis.opendocument.spreadsheet-template', 'OpenDocument Spreadsheet Template', 'ots.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (22, 'otg', 'application/vnd.oasis.opendocument.graphics-template', 'OpenDocument Drawing Template', 'otg.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (23, 'html', 'text/html', 'HTML File', 'html.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (24, 'htm', 'text/html', 'HTML File', 'html.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (2, 'docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'Microsoft Word File', 'docx.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (10, 'pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'Microsoft Powerpoint File', 'pptx.png');
INSERT INTO public.file_type (id, extension, mime_type, description, icon_url) VALUES (13, 'xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'Microsoft Excel File', 'xlsx.png');
INSERT INTO public.email_notification_setting (person_id, create_date, modify_date, notifications_enabled) VALUES (0, now(), now(), 'f');
INSERT INTO public.email_notification_setting (person_id, create_date, modify_date, notifications_enabled) VALUES (-1, now(), now(), 'f');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('ADMIN', now(), 'ADMINISTRATION');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('CO_ADMIN', now(), 'ADMINISTRATION');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('MEMBER', now(), 'MEMBERSHIP');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('HAS_REJECTED', now(), 'MEMBERSHIP');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('HAS_SENT_JOINREQUEST', now(), 'MEMBERSHIP');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('HAS_INVITATION', now(), 'MEMBERSHIP');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('IS_UNDECIDED', now(), 'MEMBERSHIP');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_IS_INVITED', now(), 'EVENT');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_IS_ATTENDING', now(), 'EVENT');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_IS_NOT_ATTENDING', now(), 'EVENT');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_IS_MAYBE_ATTENDING', now(), 'EVENT');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_IS_ON_WAITINGLIST', now(), 'EVENT');
INSERT INTO public.entity_member_role_name (name, create_date, workflow) VALUES ('EVENT_HAS_REJECTED_INVITATION', now(), 'EVENT');
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'SIMPLETASK', 'NEW', 't', now(), now(), 't', 'f', 'check_empty', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'SIMPLETASK', 'DONE', 'f', now(), now(), 't', 't', 'ok', 1);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'APPOINTMENT', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'ARTICLE', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'GROUP', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'NETWORK', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'PARTNERSITE', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'PUBLICATION', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'TOPIC', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.entity_status (id, entity_type, status_name, default_status, create_date, modify_date, published_status, archived_status, icon_type, status_order) VALUES (nextval('public.entity_status_seq'), 'WIKI', 'DEFAULT', 't', now(), now(), 't', 'f', 'ok', 0);
INSERT INTO public.native (id, native) VALUES (0, 'English');
INSERT INTO public.native (id, native) VALUES (1, 'Arabic');
INSERT INTO public.native (id, native) VALUES (2, 'Azerbaijani');
INSERT INTO public.native (id, native) VALUES (3, 'Bulgarian');
INSERT INTO public.native (id, native) VALUES (4, 'Bosnian');
INSERT INTO public.native (id, native) VALUES (5, 'Catalan');
INSERT INTO public.native (id, native) VALUES (6, 'Czech');
INSERT INTO public.native (id, native) VALUES (7, 'Danish');
INSERT INTO public.native (id, native) VALUES (8, 'Deutsch');
INSERT INTO public.native (id, native) VALUES (9, 'Greek');
INSERT INTO public.native (id, native) VALUES (10, 'Español');
INSERT INTO public.native (id, native) VALUES (11, 'Persian');
INSERT INTO public.native (id, native) VALUES (12, 'Finnish');
INSERT INTO public.native (id, native) VALUES (13, 'Français');
INSERT INTO public.native (id, native) VALUES (14, 'Irish');
INSERT INTO public.native (id, native) VALUES (15, 'Scottish Gaelic');
INSERT INTO public.native (id, native) VALUES (16, 'Hindi');
INSERT INTO public.native (id, native) VALUES (17, 'Croatian');
INSERT INTO public.native (id, native) VALUES (18, 'Hungarian');
INSERT INTO public.native (id, native) VALUES (19, 'Indonesian');
INSERT INTO public.native (id, native) VALUES (20, 'Italiano');
INSERT INTO public.native (id, native) VALUES (21, 'Japanese');
INSERT INTO public.native (id, native) VALUES (22, 'Korean');
INSERT INTO public.native (id, native) VALUES (23, 'Kurdish');
INSERT INTO public.native (id, native) VALUES (24, 'Dutch');
INSERT INTO public.native (id, native) VALUES (25, 'Norwegian');
INSERT INTO public.native (id, native) VALUES (26, 'Polski');
INSERT INTO public.native (id, native) VALUES (27, 'Pashto');
INSERT INTO public.native (id, native) VALUES (28, 'Português');
INSERT INTO public.native (id, native) VALUES (29, 'Quechua');
INSERT INTO public.native (id, native) VALUES (30, 'Romanian');
INSERT INTO public.native (id, native) VALUES (31, 'Russian');
INSERT INTO public.native (id, native) VALUES (32, 'Slovak');
INSERT INTO public.native (id, native) VALUES (33, 'Slovenian');
INSERT INTO public.native (id, native) VALUES (34, 'Albanian');
INSERT INTO public.native (id, native) VALUES (35, 'Serbian');
INSERT INTO public.native (id, native) VALUES (36, 'Sundanese');
INSERT INTO public.native (id, native) VALUES (37, 'Swedish');
INSERT INTO public.native (id, native) VALUES (38, 'Thai');
INSERT INTO public.native (id, native) VALUES (39, 'Tagalog');
INSERT INTO public.native (id, native) VALUES (40, 'Türkçe');
INSERT INTO public.native (id, native) VALUES (41, 'Ukrainian');
INSERT INTO public.native (id, native) VALUES (42, 'Urdu');
INSERT INTO public.native (id, native) VALUES (43, 'Uzbek');
INSERT INTO public.native (id, native) VALUES (44, 'Vietnamese');
INSERT INTO public.native (id, native) VALUES (45, 'Chinese');
INSERT INTO public.native (id, native) VALUES (46, 'Other');
INSERT INTO public.native (id, native) VALUES (47, 'Language');
INSERT INTO public.native (id, native) VALUES (48, 'Country');
INSERT INTO public.native (id, native) VALUES (49, 'Region');
INSERT INTO public.native (id, native) VALUES (50, 'Local');
INSERT INTO public.native (id, native) VALUES (51, '30+');
INSERT INTO public.native (id, native) VALUES (52, 'Students (all)');
INSERT INTO public.native (id, native) VALUES (53, 'Pupils (all)');
INSERT INTO public.native (id, native) VALUES (54, 'Schools (Alumni)');
INSERT INTO public.native (id, native) VALUES (55, 'School (active)');
INSERT INTO public.native (id, native) VALUES (56, 'University (Alumni)');
INSERT INTO public.native (id, native) VALUES (57, 'University (active)');
INSERT INTO public.native (id, native) VALUES (58, 'other Organizations');
INSERT INTO public.native (id, native) VALUES (59, 'Company');
INSERT INTO public.native (id, native) VALUES (60, 'Associations');
INSERT INTO public.native (id, native) VALUES (61, 'single');
INSERT INTO public.native (id, native) VALUES (62, 'vergeben');
INSERT INTO public.native (id, native) VALUES (63, 'verheiratet');
INSERT INTO public.native (id, native) VALUES (64, 'offene Beziehung');
INSERT INTO public.native (id, native) VALUES (65, 'Romanze');
INSERT INTO public.native (id, native) VALUES (66, 'was immer ich kriegen kann');
INSERT INTO public.native (id, native) VALUES (67, 'Networking');
INSERT INTO public.native (id, native) VALUES (68, 'eine Beziehung');
INSERT INTO public.native (id, native) VALUES (69, 'Dates');
INSERT INTO public.native (id, native) VALUES (70, 'Freundschaften');
INSERT INTO public.native (id, native) VALUES (71, 'unpolitisch');
INSERT INTO public.native (id, native) VALUES (72, 'sehr links');
INSERT INTO public.native (id, native) VALUES (73, 'links');
INSERT INTO public.native (id, native) VALUES (74, 'Mitte links');
INSERT INTO public.native (id, native) VALUES (75, 'liberal');
INSERT INTO public.native (id, native) VALUES (76, 'Mitte rechts');
INSERT INTO public.native (id, native) VALUES (77, 'rechts');
INSERT INTO public.native (id, native) VALUES (78, 'sehr rechts');
INSERT INTO public.native (id, native) VALUES (79, 'konservativ');
INSERT INTO public.native (id, native) VALUES (80, 'grün');
INSERT INTO public.native (id, native) VALUES (81, 'Agnostiker');
INSERT INTO public.native (id, native) VALUES (82, 'Atheist');
INSERT INTO public.native (id, native) VALUES (83, 'Buddhist');
INSERT INTO public.native (id, native) VALUES (84, 'Christ andere');
INSERT INTO public.native (id, native) VALUES (85, 'Christ Katholik');
INSERT INTO public.native (id, native) VALUES (86, 'Christ Orthodox');
INSERT INTO public.native (id, native) VALUES (87, 'Christ Protestant');
INSERT INTO public.native (id, native) VALUES (88, 'Hindu');
INSERT INTO public.native (id, native) VALUES (89, 'Jude');
INSERT INTO public.native (id, native) VALUES (90, 'Moslem');
INSERT INTO public.native (id, native) VALUES (91, 'Sikh');
INSERT INTO public.native (id, native) VALUES (92, 'Taoist');
INSERT INTO public.native (id, native) VALUES (93, 'andere');
INSERT INTO public.native (id, native) VALUES (94, 'Random');
INSERT INTO public.native (id, native) VALUES (95, 'Alphabetisch');
INSERT INTO public.native (id, native) VALUES (96, 'Student');
INSERT INTO public.native (id, native) VALUES (97, 'Schüler');
INSERT INTO public.native (id, native) VALUES (98, 'Angestellter');
INSERT INTO public.native (id, native) VALUES (99, 'Selbständig');
INSERT INTO public.native (id, native) VALUES (100, 'Auszubildender');
INSERT INTO public.native (id, native) VALUES (101, 'Im Ruhestand');
INSERT INTO public.native (id, native) VALUES (102, 'Unbestimmt');
INSERT INTO public.native (id, native) VALUES (103, 'Beamter');
INSERT INTO public.native (id, native) VALUES (104, 'Teilzeitbeschäftigt');
INSERT INTO public.native (id, native) VALUES (105, 'Bundeswehr/Zivildienst');
INSERT INTO public.native (id, native) VALUES (106, 'Hausfrau/-mann');
INSERT INTO public.native (id, native) VALUES (107, 'Nicht berufstätig');
INSERT INTO public.oauth_client_details (client_id, resource_ids, client_secret, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove) VALUES ('mobile-apps', NULL, NULL, 'api', 'password', NULL, 'ROLE_USER', 315360000, NULL, NULL, NULL);
INSERT INTO public.oauth_client_details (client_id, resource_ids, client_secret, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove) VALUES ('swagger', NULL, NULL, 'api', 'authorization_code', NULL, 'ROLE_USER', 3600, 63072000, NULL, NULL);
INSERT INTO public.oauth_client_details (client_id, resource_ids, client_secret, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove) VALUES ('toro', NULL, '$2b$12$ZvV4yO5gtyE.mt4u0VNBZ.grvJmm/S6WI1NmSXYL89pymAtISbXY2', 'api', 'client_credentials', NULL, 'ROLE_TASK_CREATOR', 3600, NULL, NULL, NULL);
INSERT INTO public.person_role (role_name, create_date) VALUES ('SUPERADMIN', now());
INSERT INTO public.person_role (role_name, create_date) VALUES ('TRANSLATOR', now());
INSERT INTO public.person_role (role_name, create_date) VALUES ('BACKENDADMIN', now());
INSERT INTO public.person_role (role_name, create_date) VALUES ('USER_IMPORT', now());
INSERT INTO public.person_role (role_name, create_date) VALUES ('USER_EXPORT', now());
INSERT INTO public.person_to_role (person_id, role_name, create_date, modify_date) VALUES (0, 'SUPERADMIN', now(), now());
INSERT INTO public.person_to_role (person_id, role_name, create_date, modify_date) VALUES (0, 'TRANSLATOR', now(), now());
INSERT INTO public.person_to_role(person_id, role_name)
    SELECT 0, 'BACKENDADMIN'
    WHERE NOT EXISTS (SELECT 1 FROM person_to_role WHERE person_id = 0 AND role_name = 'BACKENDADMIN')
    AND EXISTS (SELECT 1 FROM person_to_role WHERE person_id = 0 AND role_name = 'SUPERADMIN')
    AND EXISTS (SELECT 1 FROM customer_category WHERE customertype = 'standard')
    AND EXISTS (SELECT 1 FROM person WHERE id = 0 AND deleted = 'f');
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_BASE_DATA', 4, 0, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_DYNAMIC_ATTRIBUTE', 4, 1, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('EDUCATION_AND_WORK', 4, 2, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('MY_ENTITY_MEMBERSHIPS', 4, 3, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('WORKSTREAM', 4, 4, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_IMAGE', 5, 0, 1, 'f', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('OPTIONS', 5, 1, 1, 'f', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_BUSINESS_CONTACT', 5, 2, 2, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_PRIVATE_CONTACT', 5, 3, 2, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('PROFILE_FRIENDS', 5, 4, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('ALBUMS', 5, 5, 1, 't', now(), now());
INSERT INTO public.profile_allowed_component (component_type, "position", default_order, default_visibility, may_modify_visibility, create_date, modify_date) VALUES ('VIDEOLINK', 5, 6, 1, 't', now(), now());
INSERT INTO public.profile_attribute_config (config, create_date) VALUES ('{"modules":["SECTIONS","PERSONAL_DATA","ROLES"],"sections":[{"type":"DEFAULT","name":"contactTab_basicData","attributes":[{"type":"TEXT","name":"email","visibleOnBadge":true,"searchable":"SEARCH"},{"type":"TEXT","name":"tel","visibleOnBadge":true,"searchable":"SEARCH"},{"type":"TEXT","name":"mobile","visibleOnBadge":true,"searchable":"SEARCH"},{"type":"TEXT","name":"fax","searchable":"SEARCH"},{"type":"TEXT","name":"room","searchable":"SEARCH"},{"type":"TEXT","name":"building","searchable":"SEARCH"},{"type":"TEXT","name":"street","searchable":"SEARCH"},{"type":"TEXT","name":"plz","searchable":"SEARCH"},{"type":"TEXT","name":"city","searchable":"SEARCH"}]},{"type":"DEFAULT","name":"businessTab_basicData","attributes":[{"type":"TEXT","name":"position1","visibleOnBadge":true,"searchable":"SEARCH"},{"type":"TEXT","name":"department","searchable":"SEARCH"},{"type":"TEXT","name":"tasks","searchable":"SEARCH"},{"type":"TEXT","name":"additionalInformation","searchable":"SEARCH"}]},{"type":"DEFAULT","name":"personalTab_basicData","attributes":[{"type":"TEXT","name":"interests","searchable":"SEARCH"},{"type":"TEXT","name":"aboutme","searchable":"SEARCH"},{"type":"TEXT","name":"xing","searchable":"SEARCH"},{"type":"TEXT","name":"linkedin","searchable":"SEARCH"},{"type":"TEXT","name":"facebook","searchable":"SEARCH"},{"type":"TEXT","name":"twitter","searchable":"SEARCH"}]},{"type":"CHRONOLOGY","name":"work","attributes":[{"type":"TEXT","name":"employer","searchable":"SEARCH","maxLength":200},{"type":"TEXT","name":"website","searchable":"SEARCH","maxLength":256},{"type":"TEXT","name":"location","searchable":"SEARCH","maxLength":50},{"type":"TEXT","name":"position","searchable":"SEARCH","maxLength":50},{"type":"SELECT","name":"industry","searchable":"SEARCH","values":["1_Advertising_Communication__PR","2_Banking","3_Building__Construction","4_Mining__Quarrying","5_Education__Training","6_Chemical__Petrochemical_Industry","7_Manufacture_of_pulp_paper_and_paper_products","8_Manufacture_of_electrical_and_optical_equipment","9_Electricity_Gas__Water_Supply","10_Manufacture_of_Transport_Equipment","11_Financial_Services","12_Recreational_Cultural__Sporting_Activities","13_Medical_Health__Social_Care","14_Manufacture_of_other_nonmetallic_mineral_products","15_Wholesale_Retail_Trade","16_Handcraft_Manufacture_of_wood_and_wood_products","17_Hotels_Restaurants__Catering","18_Real_Estate","19_IT__Internet","20_Fast_Moving_Consumer_Goods_Durables","21_Agriculture_Fishing__Forestry","22_Space_and_Aerospace","23_Manufacture_of_machinery_and_equipment","24_Publishing_Printing__Reproduction","25_Medical_Technology","26_Steel_Industry","27_Food__Beverages","28_Public_Administration__Defence","29_HR_Services_Recruitment__Selection","30_Pharmaceutical_Sector","31_Other_Sectors_and_Industries","32_Other_Business_Activities__Services","33_Other_Manufacturing","34_Telecommunication_Services","35_Textiles_Clothing__Leather_Fashion","36_Distribution_Transport__Logistics","37_Legal_Consultancy__Auditing","38_Insurances","39_Research__Development"]},{"type":"SELECT","name":"occupation","searchable":"SEARCH","values":["1_IT__Telecommunication","2_Marketing__Advertising","3_Banks_Finance_Services__Insurance","4_Human_Ressources","5_Administrative_Support__Secretarial","6_Manufacturing_Building__Handcraft","7_RD_Science__Scientific_Research","8_Civil_Services","9_Design__Architecture","10_Security__Protective_Services","11_Accomodation_Catering__Tourism","12_Engineering__Technical_Jobs","13_Sales__Purchasing","14_Finance_Administration__Auditing","15_General_Management","16_Law","17_Transport__Logistics","18_Health_Medicine_Social__Fitness","19_Media__Information","20_Education__Training","21_Land_Sea_Environment__Veterinary","22_Culture__Fine_Arts"]},{"type":"SELECT","name":"jobStatus","searchable":"SEARCH","values":["1_Permanent_contract_duration_unspecified","2_Permanent_contract_duration_specified","3_Temporary","4_FreelancePermanent_contract","5_First_Job","6_Aprenticeship","7_Industrial_Placement_Internship","8_DiplomaDoctoral_Thesis","9_Student_job","10_Franchise"]},{"type":"TEXTAREA","name":"activities","searchable":"SEARCH","maxLength":1024},{"type":"MONTH_YEAR_PERIOD","name":"period","required":true}],"multiple":true}]}', now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (0, 'PROFILE_FRIENDS', 5, 4, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (-1, 'PROFILE_FRIENDS', 5, 4, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (0, 'WORKSTREAM', 4, 4, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (0, 'ALBUMS', 5, 5, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (0, 'VIDEOLINK', 5, 6, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (-1, 'WORKSTREAM', 4, 4, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (-1, 'ALBUMS', 5, 5, now(), now());
INSERT INTO public.profile_component (person_id, component_type, "position", "order", create_date, modify_date) VALUES (-1, 'VIDEOLINK', 5, 6, now(), now());
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('default_album', 'sh_default_album', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('email_notification_setting', 'sh_email_notification_setting', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity', 'sh_entity', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_component', 'sh_entity_component', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_component_open_for', 'sh_entity_component_open_for', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_dynamic_attribute', 'sh_entity_dynamic_attribute', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_link', 'sh_entity_link', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_privacy', 'sh_entity_privacy', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_to_entity_type_privacy', 'sh_entity_to_entity_type_priva', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_version', 'sh_entity_version', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_version_components', 'sh_entity_version_components', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_version_review', 'sh_entity_version_review', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('external_invitation', 'sh_external_invitation', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('like_table', 'sh_like_table', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('map_person_person', 'sh_map_person_person', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('map_person_person_invite', 'sh_map_person_person_invite', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_album', 'sh_mdl_album', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_album_image', 'sh_mdl_album_image', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_comment', 'sh_mdl_comment', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_document', 'sh_mdl_document', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_document_version', 'sh_mdl_document_version', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('mdl_video_link', 'sh_mdl_video_link', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('multi_wiki', 'sh_multi_wiki', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('multi_wiki_section_visibility', 'sh_multi_wiki_section_visibili', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('multi_wiki_version', 'sh_multi_wiki_version', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('multi_wiki_version_section', 'sh_multi_wiki_version_section', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('news_blog', 'sh_news_blog', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('person', 'sh_person', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('person_external_ids', 'sh_person_external_ids', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('person_to_role', 'sh_person_to_role', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('profile_component', 'sh_profile_component', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('raweditor_version', 'sh_raweditor_version', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('survey', 'sh_survey', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('survey_participant_answer', 'sh_survey_participant_answer', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('survey_predefined_answer', 'sh_survey_predefined_answer', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('survey_question', 'sh_survey_question', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('user_setting', 'sh_user_setting', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('wiki_editor', 'sh_wiki_editor', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('wiki_editor_backup', 'sh_wiki_editor_backup', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('wiki_editor_version', 'sh_wiki_editor_version', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('workstream_attachment', 'sh_workstream_attachment', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('workstream_entry', 'sh_workstream_entry', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('workstream_entry_attribute', 'sh_workstream_entry_attribute', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_internal_invitation', 'sh_entity_internal_invitation', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_member_role', 'sh_entity_member_role', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_recommendation', 'sh_entity_recommendation', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('entity_waitlist', 'sh_entity_waitlist', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('subscriptions', 'sh_subscriptions', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('profile_attribute', 'sh_profile_attribute', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('tasks', 'sh_tasks', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('task_list_permissions', 'sh_task_list_permissions', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('task_list', 'sh_task_list', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation', 'sh_conversation', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation_message', 'sh_conversation_message', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation_participant', 'sh_conversation_participant', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation_settings', 'sh_conversation_settings', 'f');
INSERT INTO public.shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation_attachment', 'sh_conversation_attachment', 'f');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 0, 'English');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ar', 1, '‫العربية');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 1, 'Arabic');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('az', 2, 'azərbaycan dili');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 2, 'Azerbaijani');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('bg', 3, 'български език');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 3, 'Bulgarian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('bs', 4, 'bosanski jezik');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 4, 'Bosnian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ca', 5, 'Català');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 5, 'Catalan');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('cs', 6, 'česky');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 6, 'Czech');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('da', 7, 'Dansk');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 7, 'Danish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 8, 'Deutsch');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 8, 'German');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('el', 9, 'Ελληνικά');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 9, 'Greek');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('es', 10, 'Español');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 10, 'Spanish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('fa', 11, '‫فارسی');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 11, 'Persian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('fi', 12, 'suomen kieli');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 12, 'Finnish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('fr', 13, 'Français');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 13, 'French');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ga', 14, 'Gaeilge');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 14, 'Irish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('gd', 15, 'Gàidhlig');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 15, 'Scottish Gaelic');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('hi', 16, 'हिन्दी; हिंदी');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 16, 'Hindi');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('hr', 17, 'Hrvatski');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 17, 'Croatian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('hu', 18, 'Magyar');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 18, 'Hungarian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('id', 19, 'Bahasa Indonesia');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 19, 'Indonesian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('it', 20, 'Italiano');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 20, 'Italian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ja', 21, '日本語 (にほんご／にっぽんご)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 21, 'Japanese');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ko', 22, '한국어 (韓國語); 조선말 (朝鮮語)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 22, 'Korean');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ku', 23, 'Kurdî; كوردی‎');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 23, 'Kurdish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('nl', 24, 'Nederlands');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 24, 'Dutch');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('no', 25, 'Norsk');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 25, 'Norwegian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('pl', 26, 'Polski');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 26, 'Polish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ps', 27, '‫پښتو');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 27, 'Pashto');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('pt', 28, 'Português');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 28, 'Portuguese');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('qu', 29, 'Runa Simi; Kichwa');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 29, 'Quechua');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ro', 30, 'română');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 30, 'Romanian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ru', 31, 'русский язык');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 31, 'Russian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('sk', 32, 'Slovenčina');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 32, 'Slovak');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('sl', 33, 'Slovenščina');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 33, 'Slovenian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('sq', 34, 'Shqip');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 34, 'Albanian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('sr', 35, 'српски језик');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 35, 'Serbian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('su', 36, 'Basa Sunda');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 36, 'Sundanese');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('sv', 37, 'Svenska');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 37, 'Swedish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('th', 38, 'ไทย');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 38, 'Thai');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('tl', 39, 'Tagalog');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 39, 'Tagalog');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('tr', 40, 'Türkçe');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 40, 'Turkish');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('uk', 41, 'Українська');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 41, 'Ukrainian');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('ur', 42, '‫اردو');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 42, 'Urdu');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('zu', 43, 'O''zbek; Ўзбек; أۇزبېك‎');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 43, 'Uzbek');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('vi', 44, 'Tiếng Việt');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 44, 'Vietnamese');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('zh', 45, '中文, 汉语, 漢語');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 45, 'Chinese');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 46, 'sonstige Netzwerke');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 47, 'Sprache');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 48, 'Land');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 49, 'Region');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 50, 'Lokal');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 51, 'über 30');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 52, 'Studenten (alle)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 53, 'Schüler (alle)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 54, 'Schulen (Alumni)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 55, 'Schulen (aktiv)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 56, 'Hochschulen (Alumni)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 57, 'Hochschulen (aktiv)');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 58, 'andere Organisationen');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 59, 'Unternehmen');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('de', 60, 'Vereine');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 61, 'single');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 62, 'attached');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 63, 'married');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 64, 'open relationship');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 65, 'romance');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 66, 'what ever I can get');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 67, 'networking');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 68, 'a relationship');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 69, 'dates');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 70, 'friendships');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 71, 'unpolitical');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 72, 'far left');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 73, 'left');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 74, 'left of center');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 75, 'liberal');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 76, 'right of center');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 77, 'right');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 78, 'far right');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 79, 'conservative');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 80, 'green');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 81, 'agnostic');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 82, 'atheist');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 83, 'buddhist');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 84, 'christian other');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 85, 'christian catholic');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 86, 'christian orthodox');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 87, 'christian protestant');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 88, 'hindu');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 89, 'jude');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 90, 'moslem');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 91, 'sikh');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 92, 'taoist');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 93, 'other');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 94, 'Random');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 95, 'Alphabetical');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 96, 'College Student');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 97, 'High School Student');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 98, 'Employee');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 99, 'Self-Employed');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 100, 'Apprentice');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 101, 'Pensioner');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 102, 'Undefined');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 103, 'Official');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 104, 'Part-Time Worker');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 105, 'Military or Social Service');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 106, 'Working at Home');
INSERT INTO public.translation (language_id, native_id, translation) VALUES ('en', 107, 'Not employed');
