--liquibase formatted sql
--preconditions dbms:oracle

--changeset tsubklewe:insert_initial_test_data
DELETE FROM person WHERE id IN (3,4,5,6,7,8,9,10,11,12,13,14,15);
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (3, 't', 'Tester 1', 'Test', 'Test01@Test.de', to_date('1981-11-17','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw','de', '3');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (4, 't', 'Tester 2', 'Test', 'Test02@Test.de', to_date('1981-11-18','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '4');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (5, 't', 'Tester 3', 'Test', 'Test03@Test.de', to_date('1981-11-19','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '5');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (6, 't', 'Tester 4', 'Test', 'Test04@Test.de', to_date('1981-11-20','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '6');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (7, 't', 'Tester 5', 'Test', 'Test05@Test.de', to_date('1981-11-21','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '7');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (8, 't', 'Tester 6', 'Test', 'Test06@Test.de', to_date('1981-11-22','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '8');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (9, 't', 'Tester 7', 'Test', 'Test07@Test.de', to_date('1981-11-23','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '9');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (10, 't', 'Tester 8', 'Test', 'Test08@Test.de', to_date('1981-11-24','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '10');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (11, 't', 'Tester 9', 'Test', 'Test09@Test.de', to_date('1981-11-25','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '11');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (12, 't', 'Tester 10', 'Test', 'Test10@Test.de', to_date('1981-11-26','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '12');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (13, 't', 'Tester 11', 'Test', 'Test11@Test.de', to_date('1981-11-27','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '13');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (14, 't', 'Tester 12', 'Test', 'Test12@Test.de', to_date('1981-11-28','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '14');
INSERT INTO person (id, account_active, firstname, surname, email, birthday, birthday_visibility, password_hash, language_id, hashed_id) VALUES (15, 't', 'Tester 13', 'Test', 'Test13@Test.de', to_date('1981-11-29','YYYY-MM-DD'), 'FULL', 'Lxi9P$HxAvH3GM7dShtgUW5WIeAw', 'de', '15');

DROP SEQUENCE person_seq;
CREATE SEQUENCE person_seq MINVALUE 0 START WITH 16 INCREMENT BY 1 NOCACHE;

INSERT INTO tenant (id, name) VALUES(hextoraw('0e4e3e51cbed44289b08c38b841a78b9'), 'TEST_TENANT');
-- add all test-persons to test-tenant
insert into person_tenant (person_id, tenant_id) (SELECT id, hextoraw('0e4e3e51cbed44289b08c38b841a78b9') from person where id >-1);

DELETE FROM entity WHERE id >= 0 AND id <= 20;
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (0, 'NETWORK', 'Test Netzwerk 1', NULL, NULL, NULL, NULL, 'Beschreibung Test Netzwerk 1', 'alpha, beta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (1, 'NETWORK', 'Test Netzwerk 2', NULL, NULL, NULL, NULL, 'Beschreibung Test Netzwerk 2', 'alpha, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (2, 'NETWORK', 'Test Netzwerk 3', NULL, NULL, NULL, NULL, 'Beschreibung Test Netzwerk 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (3, 'NETWORK', 'Test Subnetzwerk Netzwerk 1', NULL, NULL, NULL, NULL, 'Beschreibung Test Subnetzwerk Netzwerk 1', 'delta, beta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (4, 'NETWORK', 'Test Subnetzwerk Netzwerk 2', NULL, NULL, NULL, NULL, 'Beschreibung Test Subnetzwerk Netzwerk 2', 'delta, beta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (5, 'NETWORK', 'Test Subnetzwerk Netzwerk 3', NULL, NULL, NULL, NULL, 'Beschreibung Test Subnetzwerk Netzwerk 2', 'alpha, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (6, 'TOPIC', 'Test Topic 1', NULL, NULL, NULL, NULL, 'Beschreibung Topic 1', 'beta, delta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (7, 'TOPIC', 'Test Topic 2', NULL, NULL, NULL, NULL, 'Beschreibung Topic 2', 'gamma, alpha', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (8, 'TOPIC', 'Test Topic 3', NULL, NULL, NULL, NULL, 'Beschreibung Topic 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (9, 'WIKI', 'Test Wiki 1', NULL, NULL, NULL, NULL, 'Beschreibung Wiki 1', 'beta, delta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (10, 'WIKI', 'Test Wiki 2', NULL, NULL, NULL, NULL, 'Beschreibung Wiki 2', 'gamma, alpha', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (11, 'WIKI', 'Test Wiki 3', NULL, NULL, NULL, NULL, 'Beschreibung Wiki 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (12, 'GROUP', 'Test Group 1', NULL, NULL, NULL, NULL, 'Beschreibung Group 1', 'beta, delta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (13, 'GROUP', 'Test Group 2', NULL, NULL, NULL, NULL, 'Beschreibung Group 2', 'gamma, alpha', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (14, 'GROUP', 'Test Group 3', NULL, NULL, NULL, NULL, 'Beschreibung Group 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (15, 'APPOINTMENT', 'Test Event 1', to_timestamp('2000-11-10 14:00:00','YYYY-MM-DD HH24:MI:SS'), to_timestamp('2010-11-10 14:00:00','YYYY-MM-DD HH24:MI:SS'), NULL, 'GERMANY', 'Beschreibung Event 1', 'beta, delta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (16, 'APPOINTMENT', 'Test Event 2', to_timestamp('2000-07-07 14:00:00','YYYY-MM-DD HH24:MI:SS'), to_timestamp('2022-09-08 14:00:00','YYYY-MM-DD HH24:MI:SS'), NULL, 'GERMANY', 'Beschreibung Event 2', 'gamma, alpha', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (17, 'APPOINTMENT', 'Test Event 3', to_timestamp('2020-06-02 14:00:00','YYYY-MM-DD HH24:MI:SS'), to_timestamp('2022-07-10 14:00:00','YYYY-MM-DD HH24:MI:SS'), NULL, 'GERMANY', 'Beschreibung Event 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (18, 'PUBLICATION', 'Test Publication 1', NULL, NULL, NULL, NULL, 'Beschreibung Publication 1', 'beta, delta', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (19, 'PUBLICATION', 'Test Publication 2', NULL, NULL, NULL, NULL, 'Beschreibung Publication 2', 'gamma, alpha', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));
INSERT INTO entity (id, entity_type, name, start_at, end_at, closing_date, timezone, description,tags, tenant_id) VALUES (20, 'PUBLICATION', 'Test Publication 3', NULL, NULL, NULL, NULL, 'Beschreibung Publication 3', 'delta, gamma', hextoraw('0e4e3e51cbed44289b08c38b841a78b9'));

DROP SEQUENCE entity_seq;
CREATE SEQUENCE entity_seq MINVALUE 0 START WITH 21 INCREMENT BY 1 NOCACHE;

INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES (0, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES (0, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES (0, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES (0, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES (1, 'VISIBILITY', 'ENTITY_MEMBER');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (1, 'JOINING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (1, 'INVITING', 'ENTITY_MEMBER');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (1, 'NEWSLETTER', 'ENTITY_MEMBER');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (2, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (2, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (2, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (2, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (3, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (3, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (3, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (3, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (4, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (4, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (4, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (4, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (5, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (5, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (5, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (5, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (6, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (6, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (6, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (6, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (7, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (7, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (7, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (7, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (8, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (8, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (8, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (8, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (9, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (9, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (9, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (9, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (10, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (10, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (10, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (10, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (11, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (11, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (11, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (11, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (12, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (12, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (12, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (12, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (13, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (13, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (13, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (13, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (14, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (14, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (14, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (14, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (15, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (15, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (15, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (15, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (16, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (16, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (16, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (16, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (17, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (17, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (17, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (17, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (18, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (18, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (18, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (18, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (19, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (19, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (19, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (19, 'NEWSLETTER', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (20, 'VISIBILITY', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (20, 'JOINING', 'ALL');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (20, 'INVITING', 'LOGGED_IN');
INSERT INTO entity_privacy (entity_id, privacy_type, authority_name) VALUES  (20, 'NEWSLETTER', 'LOGGED_IN');

INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (0, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (1, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (2, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (3, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (4, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (5, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (6, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (7, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (8, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (9, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (10, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (11, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (12, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (13, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (14, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (15, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (16, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (17, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (18, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (19, 'TOPIC', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'NETWORK', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'GROUP', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'WIKI', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'APPOINTMENT', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'PUBLICATION', 'LOGGED_IN');
INSERT INTO entity_to_entity_type_privacy (entity_id, entity_type, authority_name) VALUES (20, 'TOPIC', 'LOGGED_IN');

INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,0,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,1,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,2,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,3,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,4,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,5,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,6,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,7,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,8,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,9,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,10,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,11,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,12,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,13,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,14,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,15,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,16,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,17,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,18,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,19,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,20,'ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,1,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,2,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,3,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,4,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,5,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,6,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,7,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,8,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,9,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,10,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,11,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,12,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,13,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,14,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,15,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,16,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,17,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,18,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,19,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,20,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,1,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,2,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,3,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,4,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,5,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,6,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,7,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,8,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,9,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,10,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,11,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,12,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,13,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,14,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,15,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,16,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,17,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,18,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,19,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,20,'CO_ADMIN','ADMINISTRATION');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,0,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (3,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (4,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (5,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,0,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (6,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (7,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (8,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (9,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (10,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,1,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,2,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,3,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,4,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,5,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,6,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,7,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,8,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,9,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,10,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,11,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,12,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,13,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,14,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,15,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,16,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,17,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,18,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,19,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (11,20,'MEMBER','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,1,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,2,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,3,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,4,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,5,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,6,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,7,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,8,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,9,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,10,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,11,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,12,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,13,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,14,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,15,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,16,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,17,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,18,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,19,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (12,20,'HAS_REJECTED','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,1,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,2,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,3,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,4,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,5,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,6,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,7,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,8,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,9,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,10,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,11,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,12,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,13,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,14,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,15,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,16,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,17,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,18,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,19,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (13,20,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,1,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,2,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,3,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,4,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,5,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,6,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,7,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,8,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,9,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,10,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,11,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,12,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,13,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,14,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,15,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,16,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,17,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,18,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,19,'HAS_INVITATION','MEMBERSHIP');
INSERT INTO entity_member_role (person_id, entity_id, role, workflow) VALUES (14,20,'HAS_INVITATION','MEMBERSHIP');

INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (1, 0);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (2, 0);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (3, 0);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (4, 0);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (5, 1);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (6, 1);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (7, 1);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (8, 3);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (9, 2);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (10, 8);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (11, 4);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (12, 2);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (13, 5);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (14, 6);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (14, 7);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (15, 11);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (15, 12);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (16, 2);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (17, 2);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (18, 3);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (19, 2);
INSERT INTO entity_link (entity_id, linked_entity_id) VALUES (20, 10);

DELETE FROM mdl_document_version WHERE document_id = 0;
DELETE FROM mdl_document WHERE id = 0;


DROP SEQUENCE mdl_document_version_seq;
CREATE SEQUENCE mdl_document_version_seq MINVALUE 0 START WITH 3 INCREMENT BY 1 NOCACHE;

INSERT INTO mdl_video_link(id, parent_item_id, parent_item_type, title, url, author_id, "public") VALUES(0, 0, 'ENTITY', 'Anajo - Honigmelone', 'http://www.youtube.com/watch?v=Yh5B6Z8br9o', 0, 't');

DROP SEQUENCE mdl_video_link_seq;
CREATE SEQUENCE mdl_video_link_seq MINVALUE 0 START WITH 1 INCREMENT BY 1 NOCACHE;

INSERT INTO mdl_album (id, parent_item_type, parent_item_id, module, title, owner_id) VALUES(0, 'ENTITY', 0, 't', 'Default album', null);

DROP SEQUENCE mdl_album_seq;
CREATE SEQUENCE mdl_album_seq MINVALUE 0 START WITH 1 INCREMENT BY 1 NOCACHE;

-- INSERT INTO base_property (id, property_name, converter_class, default_value, inheritance_type, container_name, last_changed, description) SELECT seq_base_property.nextval, 'Settings/Default Entity Id', 'com.freiheit.superoperty.converter.LongConverter', 0, 'F', 'systemSettings', sysdate, 'defines the default entity id.\nThe entity of the defined id will be display on the root domain as the startpage, and new registrated user without select a entity\nexplicitly will be a member of this entity by default. If you don''t want defines a default\nentity, use the id -1.' FROM dual;

INSERT INTO map_person_person (person_id, friend_id) VALUES (3,4);
INSERT INTO map_person_person (person_id, friend_id) VALUES (4,3);
INSERT INTO map_person_person (person_id, friend_id) VALUES (3,5);
INSERT INTO map_person_person (person_id, friend_id) VALUES (5,3);
INSERT INTO map_person_person (person_id, friend_id) VALUES (5,6);
INSERT INTO map_person_person (person_id, friend_id) VALUES (6,5);
INSERT INTO map_person_person (person_id, friend_id) VALUES (4,7);
INSERT INTO map_person_person (person_id, friend_id) VALUES (7,4);

INSERT INTO entity_status (id, status_name, entity_type,default_status, published_status,archived_status) SELECT entity_status_seq.nextval, 'DEFAULT', name, 't','t','f' FROM entity_type_name WHERE name IN (SELECT e.name from entity_type_name e LEFT JOIN entity_status s on e.name = s.entity_type WHERE s.status_name IS NULL);

INSERT INTO entity_version (id,entity_id, person_id,entity_status_id, version_status, major_version, minor_version, draft_version,version_type) SELECT entity_version_seq.nextval, entity_id, person_id,  status_id, version_status, major_version, minor_version, draft_version,version_type from (SELECT v.id, e.id as entity_id, emr.person_id as person_id, s.id as status_id, s.status_name as version_status ,0 AS major_version, 0 AS minor_version,1 AS draft_version,'MINOR' as version_type FROM entity e LEFT JOIN entity_version v ON e.id=v.entity_id INNER JOIN entity_status s ON s.default_status='t' AND s.entity_type=e.entity_type INNER JOIN entity_member_role emr ON e.id = emr.entity_id AND role='ADMIN' WHERE v.id IS NULL);
