--liquibase formatted sql
--preconditions dbms:oracle

--changeset tsubklewe:insert_initial_data
--preconditions onFail:MARK_RAN onError:HALT
--precondition-sql-check expectedResult:0 select count(*) from person;
--validCheckSum: 8:3c48255fb9d86cbdf47d6c0d3b070c99
/*
The init-data changelog may change after time to setup new systems according to changed configuration.
To avoid broken systems, that applied an old version of the changelog, we configure the correct checksum here.
By doing this, these systems will just ignore the changed checksum.

To generate the validCheckSum for oracle after changing this file:

Option A. If you have a local oracle-test setup:

cd juco-services
../gradlew dropAll
../gradlew test

Wait for tests to complete.
Get the new checksum from your local oracle-db:

"SELECT md5sum from databasechangelog where filename='liquibase/oracle.init_data.sql'";

Option B. If you don't hav a local oracle test setup

Submit your patch and get the new checksum from the broken test-oracle toro.log
- The message will look like this:
###
ChangeSets stimmt die Prüfsumme nicht mehr mit der Historientabelle überein.                                                                                                                                                                     │
          liquibase/oracle.init_data.sql::insert_initial_data::tsubklewe was: 8:56ca54c54113ad777bfa21bf038bd674 but is now: 8:82307e216d085ceba65934773aef7f23
###


Warning: Don't do this with normal patchsets in db.changelog.sql!!
*/

-- following tables were not dumped:
-- version
-- base_property
-- domain_property
-- properties_tmp
-- dbmaintain_scripts

insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('news','News','t','1',sysdate, sysdate);
insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('chat','Connect','t','2',sysdate,sysdate);
insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('connect','Social','t','3',sysdate,sysdate);
insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('drive','Drive','t','4',sysdate,sysdate);
insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('tasks','Tasks','t','5',sysdate,sysdate);
insert into APP (ID,NAME,IS_CORE_APP,DEFAULT_ORDER,CTIME,MTIME) values ('people','People','t','6',sysdate,sysdate);
insert into CUSTOMER_CATEGORY (CUSTOMERTYPE,CREATED_AT,MODIFIED_AT) values ('customized',sysdate,sysdate);
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('ADMIN',sysdate,'ADMINISTRATION');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('CO_ADMIN',sysdate,'ADMINISTRATION');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('MEMBER',sysdate,'MEMBERSHIP');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('HAS_REJECTED',sysdate,'MEMBERSHIP');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('HAS_SENT_JOINREQUEST',sysdate,'MEMBERSHIP');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('HAS_INVITATION',sysdate,'MEMBERSHIP');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('IS_UNDECIDED',sysdate,'MEMBERSHIP');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_IS_ATTENDING',sysdate,'EVENT');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_IS_NOT_ATTENDING',sysdate,'EVENT');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_IS_MAYBE_ATTENDING',sysdate,'EVENT');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_IS_ON_WAITINGLIST',sysdate,'EVENT');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_HAS_REJECTED_INVITATION',sysdate,'EVENT');
insert into ENTITY_MEMBER_ROLE_NAME (NAME,CREATE_DATE,WORKFLOW) values ('EVENT_IS_INVITED',sysdate,'EVENT');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'SIMPLETASK','NEW','t',sysdate,sysdate,'t','f','check_empty','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'SIMPLETASK','DONE','f',sysdate,sysdate,'t','t','ok','1');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'APPOINTMENT','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'ARTICLE','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'GROUP','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'NETWORK','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'PARTNERSITE','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'PUBLICATION','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'TOPIC','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_STATUS (ID,ENTITY_TYPE,STATUS_NAME,DEFAULT_STATUS,CREATE_DATE,MODIFY_DATE,PUBLISHED_STATUS,ARCHIVED_STATUS,ICON_TYPE,STATUS_ORDER) values (ENTITY_STATUS_SEQ.nextval,'WIKI','DEFAULT','t',sysdate,sysdate,'t','f','ok','0');
insert into ENTITY_TYPE_NAME (NAME) values ('APPOINTMENT');
insert into ENTITY_TYPE_NAME (NAME) values ('ARTICLE');
insert into ENTITY_TYPE_NAME (NAME) values ('GROUP');
insert into ENTITY_TYPE_NAME (NAME) values ('NETWORK');
insert into ENTITY_TYPE_NAME (NAME) values ('PARTNERSITE');
insert into ENTITY_TYPE_NAME (NAME) values ('PUBLICATION');
insert into ENTITY_TYPE_NAME (NAME) values ('SIMPLETASK');
insert into ENTITY_TYPE_NAME (NAME) values ('TOPIC');
insert into ENTITY_TYPE_NAME (NAME) values ('WIKI');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('0','$EMPTY$','application/octet-stream','Binary','other.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('1','doc','application/ms-word','Microsoft Word File','doc.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('2','docx','application/vnd.openxmlformats-officedocument.wordprocessingml.document','Microsoft Word File','docx.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('3','gif','image/gif','GIF Image','gif.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('4','jpg','image/jpeg','JPEG Image','jpg.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('5','jpeg','image/jpeg','JPEG Image','jpg.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('6','pdf','application/pdf','Adobe PDF File','pdf.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('7','png','image/png','PNG Image','png.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('8','pps','application/ms-powerpoint','Microsoft Powerpoint File','pps.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('9','ppt','application/ms-powerpoint','Microsoft Powerpoint File','ppt.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('10','pptx','application/vnd.openxmlformats-officedocument.presentationml.presentation','Microsoft Powerpoint File','pptx.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('11','txt','text/plain','Plain Text','txt.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('12','xls','application/ms-excel','Microsoft Excel File','xls.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('13','xlsx','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet','Microsoft Excel File','xlsx.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('14','zip','application/zip','Zip Archive','zip.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('15','odt','application/vnd.oasis.opendocument.text','OpenDocument Text','odt.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('16','odp','application/vnd.oasis.opendocument.presentation','OpenDocument Presentation','odp.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('17','ods','application/vnd.oasis.opendocument.spreadsheet','OpenDocument Spreadsheet','ods.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('18','odg','application/vnd.oasis.opendocument.graphics','OpenDocument Drawing','odg.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('19','ott','application/vnd.oasis.opendocument.text-template','OpenDocument Text Template','ott.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('20','otp','application/vnd.oasis.opendocument.presentation-template','OpenDocument Presentation Template','otp.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('21','ots','application/vnd.oasis.opendocument.spreadsheet-template','OpenDocument Spreadsheet Template','ots.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('22','otg','application/vnd.oasis.opendocument.graphics-template','OpenDocument Drawing Template','otg.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('23','html','text/html','HTML File','html.png');
insert into FILE_TYPE (ID,EXTENSION,MIME_TYPE,DESCRIPTION,ICON_URL) values ('24','htm','text/html','HTML File','html.png');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ar','Arabic','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('az','Azerbaijani','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('bg','Bulgarian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('bs','Bosnian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ca','Catalan','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('cs','Czech','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('da','Danish','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('el','Greek','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('es','Español','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('fa','Persian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('fi','Finnish','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('fr','Français','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ga','Irish','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('gd','Scottish Gaelic','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('hi','Hindi','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('hr','Croatian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('hu','Hungarian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('id','Indonesian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('it','Italiano','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ja','Japanese','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ko','Korean','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ku','Kurdish','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('nl','Dutch','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('no','Norwegian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('pl','Polski','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ps','Pashto','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('pt','Português','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('qu','Quechua','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ro','Romanian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ru','Russian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('sk','Slovak','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('sl','Slovenian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('sq','Albanian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('sr','Serbian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('su','Sundanese','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('sv','Swedish','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('th','Thai','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('tl','Tagalog','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('tr','Türkçe','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('uk','Ukrainian','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('ur','Urdu','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('zu','Uzbek','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('vi','Vietnamese','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('zh','Chinese','f');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('de','Deutsch','t');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('en','English','t');
insert into LANGUAGE (ID,NAME,TRANSLATED) values ('mt','Malti','f');
insert into PERSON (ID,LAST_LOGIN,SHOW_TEMPSTARTPAGE,ACCOUNT_ACTIVE,TITLE,FIRSTNAME,SURNAME,EMAIL,NEWMAIL,BIRTHDAY,PASSWORD_HASH,KEYWORDS,LANGUAGE_ID,PASSWORD_QUESTION,PASSWORD_ANSWER,REGISTERDATE,TERMS_ACCEPTED,IMAGE,BLOCKED,DEFAULT_TIMEZONE,MODIFIED_AT,CREATED_AT,BIRTHDAY_VISIBILITY,HASHED_ID,ADDITIONAL_TITLE,DELETED) values ('0',sysdate,'t','t',null,'Admin','Just Software AG','admin@justsoftwareag.com',null,to_date('06.10.20','DD.MM.RR'),'$2y$12$6FLXdVmYLEhCOnmIZWgSu.kqWLn3KSaVoDXRoIOQHpC9CZS6EHiMy',null,'de',null,null,sysdate,'t',null,'f',null,sysdate,sysdate,'NONE','1460108abd99ab2e07573166b61c36c3',null,'f');
insert into PERSON (ID,LAST_LOGIN,SHOW_TEMPSTARTPAGE,ACCOUNT_ACTIVE,TITLE,FIRSTNAME,SURNAME,EMAIL,NEWMAIL,BIRTHDAY,PASSWORD_HASH,KEYWORDS,LANGUAGE_ID,PASSWORD_QUESTION,PASSWORD_ANSWER,REGISTERDATE,TERMS_ACCEPTED,IMAGE,BLOCKED,DEFAULT_TIMEZONE,MODIFIED_AT,CREATED_AT,BIRTHDAY_VISIBILITY,HASHED_ID,ADDITIONAL_TITLE,DELETED) values ('-1',sysdate,'t','f',null,'deleted user','deleted user',null,null,null,null,null,null,null,null,sysdate,null,null,'f',null,sysdate,sysdate,'NONE','xxxxxxxx',null,'t');
insert into PERSON_ROLE (ROLE_NAME,CREATE_DATE) values ('SUPERADMIN',sysdate);
insert into PERSON_ROLE (ROLE_NAME,CREATE_DATE) values ('TRANSLATOR',sysdate);
insert into PERSON_TO_ROLE (PERSON_ID,ROLE_NAME,CREATE_DATE,MODIFY_DATE) values ('0','SUPERADMIN',sysdate,sysdate);
insert into PERSON_TO_ROLE (PERSON_ID,ROLE_NAME,CREATE_DATE,MODIFY_DATE) values ('0','TRANSLATOR',sysdate,sysdate);
insert into EMAIL_NOTIFICATION_SETTING (PERSON_ID,CREATE_DATE,MODIFY_DATE,NOTIFICATIONS_ENABLED) values ('-1',sysdate,sysdate,'f');
insert into EMAIL_NOTIFICATION_SETTING (PERSON_ID,CREATE_DATE,MODIFY_DATE,NOTIFICATIONS_ENABLED) values ('0',sysdate,sysdate,'f');
insert into NATIVE (ID,NATIVE) values ('0','English');
insert into NATIVE (ID,NATIVE) values ('1','Arabic');
insert into NATIVE (ID,NATIVE) values ('2','Azerbaijani');
insert into NATIVE (ID,NATIVE) values ('3','Bulgarian');
insert into NATIVE (ID,NATIVE) values ('4','Bosnian');
insert into NATIVE (ID,NATIVE) values ('5','Catalan');
insert into NATIVE (ID,NATIVE) values ('6','Czech');
insert into NATIVE (ID,NATIVE) values ('7','Danish');
insert into NATIVE (ID,NATIVE) values ('8','Deutsch');
insert into NATIVE (ID,NATIVE) values ('9','Greek');
insert into NATIVE (ID,NATIVE) values ('10','Español');
insert into NATIVE (ID,NATIVE) values ('11','Persian');
insert into NATIVE (ID,NATIVE) values ('12','Finnish');
insert into NATIVE (ID,NATIVE) values ('13','Français');
insert into NATIVE (ID,NATIVE) values ('14','Irish');
insert into NATIVE (ID,NATIVE) values ('15','Scottish Gaelic');
insert into NATIVE (ID,NATIVE) values ('16','Hindi');
insert into NATIVE (ID,NATIVE) values ('17','Croatian');
insert into NATIVE (ID,NATIVE) values ('18','Hungarian');
insert into NATIVE (ID,NATIVE) values ('19','Indonesian');
insert into NATIVE (ID,NATIVE) values ('20','Italiano');
insert into NATIVE (ID,NATIVE) values ('21','Japanese');
insert into NATIVE (ID,NATIVE) values ('22','Korean');
insert into NATIVE (ID,NATIVE) values ('23','Kurdish');
insert into NATIVE (ID,NATIVE) values ('24','Dutch');
insert into NATIVE (ID,NATIVE) values ('25','Norwegian');
insert into NATIVE (ID,NATIVE) values ('26','Polski');
insert into NATIVE (ID,NATIVE) values ('27','Pashto');
insert into NATIVE (ID,NATIVE) values ('28','Português');
insert into NATIVE (ID,NATIVE) values ('29','Quechua');
insert into NATIVE (ID,NATIVE) values ('30','Romanian');
insert into NATIVE (ID,NATIVE) values ('31','Russian');
insert into NATIVE (ID,NATIVE) values ('32','Slovak');
insert into NATIVE (ID,NATIVE) values ('33','Slovenian');
insert into NATIVE (ID,NATIVE) values ('34','Albanian');
insert into NATIVE (ID,NATIVE) values ('35','Serbian');
insert into NATIVE (ID,NATIVE) values ('36','Sundanese');
insert into NATIVE (ID,NATIVE) values ('37','Swedish');
insert into NATIVE (ID,NATIVE) values ('38','Thai');
insert into NATIVE (ID,NATIVE) values ('39','Tagalog');
insert into NATIVE (ID,NATIVE) values ('40','Türkçe');
insert into NATIVE (ID,NATIVE) values ('41','Ukrainian');
insert into NATIVE (ID,NATIVE) values ('42','Urdu');
insert into NATIVE (ID,NATIVE) values ('43','Uzbek');
insert into NATIVE (ID,NATIVE) values ('44','Vietnamese');
insert into NATIVE (ID,NATIVE) values ('45','Chinese');
insert into NATIVE (ID,NATIVE) values ('46','Other');
insert into NATIVE (ID,NATIVE) values ('47','Language');
insert into NATIVE (ID,NATIVE) values ('48','Country');
insert into NATIVE (ID,NATIVE) values ('49','Region');
insert into NATIVE (ID,NATIVE) values ('50','Local');
insert into NATIVE (ID,NATIVE) values ('51','30+');
insert into NATIVE (ID,NATIVE) values ('52','Students (all)');
insert into NATIVE (ID,NATIVE) values ('53','Pupils (all)');
insert into NATIVE (ID,NATIVE) values ('54','Schools (Alumni)');
insert into NATIVE (ID,NATIVE) values ('55','School (active)');
insert into NATIVE (ID,NATIVE) values ('56','University (Alumni)');
insert into NATIVE (ID,NATIVE) values ('57','University (active)');
insert into NATIVE (ID,NATIVE) values ('58','other Organizations');
insert into NATIVE (ID,NATIVE) values ('59','Company');
insert into NATIVE (ID,NATIVE) values ('60','Associations');
insert into NATIVE (ID,NATIVE) values ('61','single');
insert into NATIVE (ID,NATIVE) values ('62','vergeben');
insert into NATIVE (ID,NATIVE) values ('63','verheiratet');
insert into NATIVE (ID,NATIVE) values ('64','offene Beziehung');
insert into NATIVE (ID,NATIVE) values ('65','Romanze');
insert into NATIVE (ID,NATIVE) values ('66','was immer ich kriegen kann');
insert into NATIVE (ID,NATIVE) values ('67','Networking');
insert into NATIVE (ID,NATIVE) values ('68','eine Beziehung');
insert into NATIVE (ID,NATIVE) values ('69','Dates');
insert into NATIVE (ID,NATIVE) values ('70','Freundschaften');
insert into NATIVE (ID,NATIVE) values ('71','unpolitisch');
insert into NATIVE (ID,NATIVE) values ('72','sehr links');
insert into NATIVE (ID,NATIVE) values ('73','links');
insert into NATIVE (ID,NATIVE) values ('74','Mitte links');
insert into NATIVE (ID,NATIVE) values ('75','liberal');
insert into NATIVE (ID,NATIVE) values ('76','Mitte rechts');
insert into NATIVE (ID,NATIVE) values ('77','rechts');
insert into NATIVE (ID,NATIVE) values ('78','sehr rechts');
insert into NATIVE (ID,NATIVE) values ('79','konservativ');
insert into NATIVE (ID,NATIVE) values ('80','grün');
insert into NATIVE (ID,NATIVE) values ('81','Agnostiker');
insert into NATIVE (ID,NATIVE) values ('82','Atheist');
insert into NATIVE (ID,NATIVE) values ('83','Buddhist');
insert into NATIVE (ID,NATIVE) values ('84','Christ andere');
insert into NATIVE (ID,NATIVE) values ('85','Christ Katholik');
insert into NATIVE (ID,NATIVE) values ('86','Christ Orthodox');
insert into NATIVE (ID,NATIVE) values ('87','Christ Protestant');
insert into NATIVE (ID,NATIVE) values ('88','Hindu');
insert into NATIVE (ID,NATIVE) values ('89','Jude');
insert into NATIVE (ID,NATIVE) values ('90','Moslem');
insert into NATIVE (ID,NATIVE) values ('91','Sikh');
insert into NATIVE (ID,NATIVE) values ('92','Taoist');
insert into NATIVE (ID,NATIVE) values ('93','andere');
insert into NATIVE (ID,NATIVE) values ('94','Random');
insert into NATIVE (ID,NATIVE) values ('95','Alphabetisch');
insert into NATIVE (ID,NATIVE) values ('96','Student');
insert into NATIVE (ID,NATIVE) values ('97','Schüler');
insert into NATIVE (ID,NATIVE) values ('98','Angestellter');
insert into NATIVE (ID,NATIVE) values ('99','Selbständig');
insert into NATIVE (ID,NATIVE) values ('100','Auszubildender');
insert into NATIVE (ID,NATIVE) values ('101','Im Ruhestand');
insert into NATIVE (ID,NATIVE) values ('102','Unbestimmt');
insert into NATIVE (ID,NATIVE) values ('103','Beamter');
insert into NATIVE (ID,NATIVE) values ('104','Teilzeitbeschäftigt');
insert into NATIVE (ID,NATIVE) values ('105','Bundeswehr/Zivildienst');
insert into NATIVE (ID,NATIVE) values ('106','Hausfrau/-mann');
insert into NATIVE (ID,NATIVE) values ('107','Nicht berufstätig');
insert into OAUTH_CLIENT_DETAILS (CLIENT_ID,RESOURCE_IDS,CLIENT_SECRET,SCOPE,AUTHORIZED_GRANT_TYPES,WEB_SERVER_REDIRECT_URI,AUTHORITIES,ACCESS_TOKEN_VALIDITY,REFRESH_TOKEN_VALIDITY,ADDITIONAL_INFORMATION,AUTOAPPROVE) values ('swagger',null,null,'api','authorization_code',null,'ROLE_USER','3600','63072000',null,null);
insert into OAUTH_CLIENT_DETAILS (CLIENT_ID,RESOURCE_IDS,CLIENT_SECRET,SCOPE,AUTHORIZED_GRANT_TYPES,WEB_SERVER_REDIRECT_URI,AUTHORITIES,ACCESS_TOKEN_VALIDITY,REFRESH_TOKEN_VALIDITY,ADDITIONAL_INFORMATION,AUTOAPPROVE) values ('operations',null,null,'api','implicit,password',null,'ROLE_USER','2592000','63072000',null,null);
insert into OAUTH_CLIENT_DETAILS (CLIENT_ID,RESOURCE_IDS,CLIENT_SECRET,SCOPE,AUTHORIZED_GRANT_TYPES,WEB_SERVER_REDIRECT_URI,AUTHORITIES,ACCESS_TOKEN_VALIDITY,REFRESH_TOKEN_VALIDITY,ADDITIONAL_INFORMATION,AUTOAPPROVE) values ('toro',null,'fIBUu$5T/czE0Bhn05fsu5Fxnbog','api','client_credentials',null,'ROLE_TASK_CREATOR','3600',null,null,null);
insert into OAUTH_CLIENT_DETAILS (CLIENT_ID,RESOURCE_IDS,CLIENT_SECRET,SCOPE,AUTHORIZED_GRANT_TYPES,WEB_SERVER_REDIRECT_URI,AUTHORITIES,ACCESS_TOKEN_VALIDITY,REFRESH_TOKEN_VALIDITY,ADDITIONAL_INFORMATION,AUTOAPPROVE) values ('mobile-apps',null,null,'api','password',null,'ROLE_USER','315360000',null,null,null);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_BASE_DATA','4','0','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_DYNAMIC_ATTRIBUTE','4','1','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('EDUCATION_AND_WORK','4','2','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('MY_ENTITY_MEMBERSHIPS','4','3','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('WORKSTREAM','4','4','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_IMAGE','5','0','1','f',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('OPTIONS','5','1','1','f',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_BUSINESS_CONTACT','5','2','2','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_PRIVATE_CONTACT','5','3','2','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('PROFILE_FRIENDS','5','4','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('ALBUMS','5','5','1','t',sysdate,sysdate);
insert into PROFILE_ALLOWED_COMPONENT (COMPONENT_TYPE,"position",DEFAULT_ORDER,DEFAULT_VISIBILITY,MAY_MODIFY_VISIBILITY,CREATE_DATE,MODIFY_DATE) values ('VIDEOLINK','5','6','1','t',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('0','PROFILE_FRIENDS','5','4',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('-1','PROFILE_FRIENDS','5','4',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('0','WORKSTREAM','4','4',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('0','ALBUMS','5','5',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('0','VIDEOLINK','5','6',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('-1','WORKSTREAM','4','4',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('-1','ALBUMS','5','5',sysdate,sysdate);
insert into PROFILE_COMPONENT (PERSON_ID,COMPONENT_TYPE,"position","order",CREATE_DATE,MODIFY_DATE) values ('-1','VIDEOLINK','5','6',sysdate,sysdate);
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_INTERNAL_INVITATION','SH_ENTITY_INTERNAL_INVITATION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_MEMBER_ROLE','SH_ENTITY_MEMBER_ROLE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('TASKS','SH_TASKS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('TASK_LIST','SH_TASK_LIST','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('TASK_LIST_PERMISSIONS','SH_TASK_LIST_PERMISSIONS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('CONVERSATION','SH_CONVERSATION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('DEFAULT_ALBUM','SH_DEFAULT_ALBUM','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('EMAIL_NOTIFICATION_SETTING','SH_EMAIL_NOTIFICATION_SETTING','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('PROFILE_ATTRIBUTE','SH_PROFILE_ATTRIBUTE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY','SH_ENTITY','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_COMPONENT','SH_ENTITY_COMPONENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_COMPONENT_OPEN_FOR','SH_ENTITY_COMPONENT_OPEN_FOR','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('CONVERSATION_ATTACHMENT','SH_CONVERSATION_ATTACHMENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('SUBSCRIPTIONS','SH_SUBSCRIPTIONS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_DYNAMIC_ATTRIBUTE','SH_ENTITY_DYNAMIC_ATTRIBUTE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_LINK','SH_ENTITY_LINK','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_RECOMMENDATION','SH_ENTITY_RECOMMENDATION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('CONVERSATION_MESSAGE','SH_CONVERSATION_MESSAGE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_PRIVACY','SH_ENTITY_PRIVACY','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_TO_ENTITY_TYPE_PRIVACY','SH_ENTITY_TO_ENTITY_TYPE_PRIVA','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_VERSION','SH_ENTITY_VERSION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_VERSION_COMPONENTS','SH_ENTITY_VERSION_COMPONENTS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_VERSION_REVIEW','SH_ENTITY_VERSION_REVIEW','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('EXTERNAL_INVITATION','SH_EXTERNAL_INVITATION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('CONVERSATION_PARTICIPANT','SH_CONVERSATION_PARTICIPANT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('LIKE_TABLE','SH_LIKE_TABLE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('CONVERSATION_SETTINGS','SH_CONVERSATION_SETTINGS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MAP_PERSON_PERSON','SH_MAP_PERSON_PERSON','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MAP_PERSON_PERSON_INVITE','SH_MAP_PERSON_PERSON_INVITE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_ALBUM','SH_MDL_ALBUM','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_ALBUM_IMAGE','SH_MDL_ALBUM_IMAGE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_COMMENT','SH_MDL_COMMENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_DOCUMENT','SH_MDL_DOCUMENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_DOCUMENT_VERSION','SH_MDL_DOCUMENT_VERSION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('ENTITY_WAITLIST','SH_ENTITY_WAITLIST','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MDL_VIDEO_LINK','SH_MDL_VIDEO_LINK','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MULTI_WIKI','SH_MULTI_WIKI','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MULTI_WIKI_SECTION_VISIBILITY','SH_MULTI_WIKI_SECTION_VISIBILI','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MULTI_WIKI_VERSION','SH_MULTI_WIKI_VERSION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('MULTI_WIKI_VERSION_SECTION','SH_MULTI_WIKI_VERSION_SECTION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('NEWS_BLOG','SH_NEWS_BLOG','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('PERSON','SH_PERSON','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('PERSON_EXTERNAL_IDS','SH_PERSON_EXTERNAL_IDS','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('PERSON_TO_ROLE','SH_PERSON_TO_ROLE','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('PROFILE_COMPONENT','SH_PROFILE_COMPONENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('RAWEDITOR_VERSION','SH_RAWEDITOR_VERSION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('SURVEY','SH_SURVEY','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('SURVEY_PARTICIPANT_ANSWER','SH_SURVEY_PARTICIPANT_ANSWER','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('SURVEY_PREDEFINED_ANSWER','SH_SURVEY_PREDEFINED_ANSWER','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('SURVEY_QUESTION','SH_SURVEY_QUESTION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('USER_SETTING','SH_USER_SETTING','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WIKI_EDITOR','SH_WIKI_EDITOR','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WIKI_EDITOR_BACKUP','SH_WIKI_EDITOR_BACKUP','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WIKI_EDITOR_VERSION','SH_WIKI_EDITOR_VERSION','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WORKSTREAM_ATTACHMENT','SH_WORKSTREAM_ATTACHMENT','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WORKSTREAM_ENTRY','SH_WORKSTREAM_ENTRY','f');
insert into SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) values ('WORKSTREAM_ENTRY_ATTRIBUTE','SH_WORKSTREAM_ENTRY_ATTRIBUTE','f');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','0','English');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','1','Arabic');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('az','2','azərbaycan dili');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','2','Azerbaijani');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('bg','3','български език');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','3','Bulgarian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('bs','4','bosanski jezik');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','4','Bosnian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ca','5','Català');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','5','Catalan');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('cs','6','česky');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','6','Czech');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('da','7','Dansk');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','7','Danish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','8','Deutsch');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','8','German');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('el','9','Ελληνικά');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','9','Greek');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('es','10','Español');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','10','Spanish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','11','Persian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('fi','12','suomen kieli');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','12','Finnish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('fr','13','Français');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','13','French');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ga','14','Gaeilge');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','14','Irish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('gd','15','Gàidhlig');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','15','Scottish Gaelic');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','16','Hindi');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('hr','17','Hrvatski');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','17','Croatian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('hu','18','Magyar');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','18','Hungarian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('id','19','Bahasa Indonesia');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','19','Indonesian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('it','20','Italiano');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','20','Italian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ja','21','日本語 (にほんご／にっぽんご)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','21','Japanese');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ko','22','한국어 (韓國語); 조선말 (朝鮮語)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','22','Korean');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','23','Kurdish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('nl','24','Nederlands');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','24','Dutch');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('no','25','Norsk');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','25','Norwegian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('pl','26','Polski');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','26','Polish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','27','Pashto');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('pt','28','Português');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','28','Portuguese');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('qu','29','Runa Simi; Kichwa');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','29','Quechua');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ro','30','română');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','30','Romanian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('ru','31','русский язык');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','31','Russian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('sk','32','Slovenčina');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','32','Slovak');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('sl','33','Slovenščina');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','33','Slovenian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('sq','34','Shqip');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','34','Albanian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('sr','35','српски језик');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','35','Serbian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('su','36','Basa Sunda');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','36','Sundanese');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('sv','37','Svenska');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','37','Swedish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('th','38','ไทย');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','38','Thai');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('tl','39','Tagalog');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','39','Tagalog');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('tr','40','Türkçe');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','40','Turkish');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('uk','41','Українська');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','41','Ukrainian');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','42','Urdu');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','43','Uzbek');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('vi','44','Tiếng Việt');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','44','Vietnamese');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('zh','45','中文, 汉语, 漢語');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','45','Chinese');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','46','sonstige Netzwerke');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','47','Sprache');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','48','Land');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','49','Region');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','50','Lokal');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','51','über 30');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','52','Studenten (alle)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','53','Schüler (alle)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','54','Schulen (Alumni)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','55','Schulen (aktiv)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','56','Hochschulen (Alumni)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','57','Hochschulen (aktiv)');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','58','andere Organisationen');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','59','Unternehmen');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('de','60','Vereine');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','61','single');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','62','attached');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','63','married');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','64','open relationship');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','65','romance');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','66','what ever I can get');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','67','networking');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','68','a relationship');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','69','dates');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','70','friendships');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','71','unpolitical');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','72','far left');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','73','left');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','74','left of center');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','75','liberal');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','76','right of center');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','77','right');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','78','far right');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','79','conservative');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','80','green');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','81','agnostic');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','82','atheist');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','83','buddhist');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','84','christian other');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','85','christian catholic');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','86','christian orthodox');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','87','christian protestant');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','88','hindu');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','89','jude');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','90','moslem');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','91','sikh');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','92','taoist');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','93','other');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','94','Random');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','95','Alphabetical');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','96','College Student');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','97','High School Student');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','98','Employee');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','99','Self-Employed');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','100','Apprentice');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','101','Pensioner');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','102','Undefined');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','103','Official');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','104','Part-Time Worker');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','105','Military or Social Service');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','106','Working at Home');
insert into TRANSLATION (LANGUAGE_ID,NATIVE_ID,TRANSLATION) values ('en','107','Not employed');
