--liquibase formatted sql

--changeset tsubklewe:delete_property_delete_chat_messages_enabled
DELETE FROM base_property WHERE property_name = 'Settings/Feature Toggle/delete chat messages enabled';

--changeset jkaiser:create_tenant_invitation
CREATE TABLE tenant_invitation (
    PRIMARY KEY (tenant_id, tenant_invitation_code),
    tenant_id ${uuid} NOT NULL REFERENCES tenant (id) ON DELETE CASCADE,
    tenant_invitation_code ${varchar64} NOT NULL
);

--changeset holger.dewes:delete_superoperty_chat_domain_and_ejabberd_api_url
DELETE FROM base_property
WHERE container_name = 'systemSettings'
AND property_name in ('Settings/Chat/ejabberd admin rest URL', 'Settings/Chat/jabber domain');


--changeset cewers:add_tenant_id_to_entity dbms:postgresql
ALTER TABLE entity ADD COLUMN tenant_id ${uuid};
ALTER TABLE entity ADD CONSTRAINT entity_tenant_fk FOREIGN KEY (tenant_id) REFERENCES tenant (id);
ALTER TABLE sh_entity ADD COLUMN tenant_id ${uuid};

--changeset cewers:migrate_entity_tenant_postgres dbms:postgresql endDelimiter:@@
CREATE OR REPLACE FUNCTION add_tenant_id_to_children(parent_id BIGINT, parent_tenant_id UUID) RETURNS VOID AS $u$
BEGIN
    WITH RECURSIVE children AS (
        SELECT
            e.id as id
        FROM
            entity e
        WHERE
            e.id=parent_id
        UNION
            SELECT
                el.entity_id as id
            FROM
                entity_link el
            INNER JOIN children c ON el.linked_entity_id =c.id

    )
    UPDATE entity set tenant_id=parent_tenant_id where id in (
        SELECT * FROM children c where c.id !=parent_id
    ) AND tenant_id IS NULL;
END
$u$ language plpgsql;@@

CREATE OR REPLACE FUNCTION migrate_entity_tenants() RETURNS VOID AS $func$
DECLARE p record;
BEGIN
    UPDATE entity e set tenant_id=(SELECT tenant_id FROM entity_tenant et WHERE et.entity_id=e.id);

    FOR p IN SELECT e.id, e.tenant_id
              FROM entity e WHERE e. tenant_id IS NOT NULL
    LOOP
        PERFORM add_tenant_id_to_children(p.id, p.tenant_id);
    END LOOP;

END
$func$ LANGUAGE plpgsql;@@

--comment: perform entity-tenant migration - won't do anything on single-tenant systems
select migrate_entity_tenants();

--comment: migrate single tenant systems
UPDATE entity e set tenant_id=(SELECT id from tenant where default_tenant='t') where tenant_id is NULL;

--comment: make tenant_id nonnull
ALTER TABLE entity ALTER COLUMN tenant_id SET NOT NULL;

--comment: drop functions as those are not needed anymore
DROP FUNCTION migrate_entity_tenants();
DROP FUNCTION add_tenant_id_to_children(parent_id BIGINT, parent_tenant_id UUID);

--changeset cewers:add_tenant_id_to_entity dbms:oracle
ALTER TABLE entity ADD tenant_id ${uuid};
ALTER TABLE entity ADD CONSTRAINT entity_tenant_fk FOREIGN KEY (tenant_id) REFERENCES tenant (id);
ALTER TABLE sh_entity ADD tenant_id ${uuid};

--changeset cewers:migrate_entity_tenant_oracle dbms:oracle
UPDATE entity e set tenant_id=(SELECT id from tenant where default_tenant='t') where tenant_id is NULL;
ALTER TABLE entity MODIFY (tenant_id NOT NULL);

--changeset fzuellich:add_new_cycle_delay_column_to_newszoom_config
ALTER TABLE newszoom_config
    ADD cycle_delay_in_seconds ${int32} DEFAULT 8 NOT NULL;

--changeset azottnick:delete_superoperty_add_users_as_members_on_recommendation_task
DELETE FROM base_property
WHERE container_name = 'systemSettings'
AND property_name = 'Settings/Recommendation/add users to members on recommendation task';

--changeset holger.dewes:migrate_connect_ids_to_uuid_search_queues dbms:oracle
TRUNCATE TABLE chat_search_queue;
ALTER TABLE chat_search_queue MODIFY id ${uuid};
ALTER TABLE chat_search_queue MODIFY item_id ${uuid};
TRUNCATE TABLE conversation_search_queue;
ALTER TABLE conversation_search_queue MODIFY id ${uuid};
ALTER TABLE conversation_search_queue MODIFY item_id ${uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_search_queues dbms:postgresql
TRUNCATE TABLE chat_search_queue;
ALTER TABLE chat_search_queue ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE chat_search_queue ALTER item_id TYPE ${uuid} USING (${generate_uuid});
TRUNCATE TABLE conversation_search_queue;
ALTER TABLE conversation_search_queue ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE conversation_search_queue ALTER item_id TYPE ${uuid} USING (${generate_uuid});

--changeset holger.dewes:migrate_connect_ids_to_uuid_conversation_change dbms:oracle
TRUNCATE TABLE conversation_change;
ALTER TABLE conversation_change MODIFY id ${uuid};
ALTER TABLE conversation_change MODIFY conversation_id ${uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_conversation_change dbms:postgresql
TRUNCATE TABLE conversation_change;
ALTER TABLE conversation_change ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE conversation_change ALTER conversation_id TYPE ${uuid} USING (${generate_uuid});

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_columns
ALTER TABLE conversation ADD id_uuid ${uuid};
ALTER TABLE conversation ADD last_message_id ${uuid};
ALTER TABLE conversation_attachment ADD id_uuid ${uuid};
ALTER TABLE conversation_message ADD id_uuid ${uuid};
ALTER TABLE conversation_attachment ADD message_id_uuid ${uuid};
ALTER TABLE conversation_message ADD conversation_id_uuid ${uuid};
ALTER TABLE conversation_participant ADD conversation_id_uuid ${uuid};
ALTER TABLE conversation_settings ADD conversation_id_uuid ${uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_generate_all_but_messages
UPDATE conversation SET id_uuid = ${generate_uuid};
UPDATE conversation_attachment SET id_uuid = ${generate_uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_generate_messages
UPDATE conversation_message SET id_uuid = ${generate_uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_fk_all_but_messages dbms:oracle
MERGE INTO conversation_attachment ca
USING (SELECT id, id_uuid FROM conversation_message) cm ON (ca.message_id = cm.id)
WHEN MATCHED THEN UPDATE SET ca.message_id_uuid = cm.id_uuid;

MERGE INTO conversation_participant cp
USING (SELECT id, id_uuid FROM conversation) c ON (cp.conversation_id = c.id)
WHEN MATCHED THEN UPDATE SET cp.conversation_id_uuid = c.id_uuid;

MERGE INTO conversation_settings cs
USING (SELECT id, id_uuid FROM conversation) c ON (cs.conversation_id = c.id)
WHEN MATCHED THEN UPDATE SET cs.conversation_id_uuid = c.id_uuid;

--changeset holger.dewes:migrate_connect_ids_to_uuid_fk_all_but_messages dbms:postgresql
UPDATE conversation_attachment ca SET message_id_uuid = cm.id_uuid
FROM conversation_message cm WHERE ca.message_id = cm.id;

UPDATE conversation_participant cp SET conversation_id_uuid = c.id_uuid
FROM conversation c WHERE cp.conversation_id = c.id;

UPDATE conversation_settings cs SET conversation_id_uuid = c.id_uuid
FROM conversation c WHERE cs.conversation_id = c.id;

--changeset holger.dewes:migrate_connect_ids_to_uuid_fk_messages dbms:oracle
MERGE INTO conversation_message cm
USING (SELECT id, id_uuid FROM conversation) c ON (cm.conversation_id = c.id)
WHEN MATCHED THEN UPDATE SET cm.conversation_id_uuid = c.id_uuid;

--changeset holger.dewes:migrate_connect_ids_to_uuid_fk_messages dbms:postgresql
UPDATE conversation_message cm SET conversation_id_uuid = c.id_uuid
FROM conversation c WHERE cm.conversation_id = c.id;

--changeset holger.dewes:migrate_connect_ids_to_uuid_last_message_id
UPDATE conversation c
SET last_message_id = (
    SELECT id_uuid FROM conversation_message WHERE id = (
        SELECT max(id) FROM conversation_message
        WHERE conversation_id = c.id
    )
);

--changeset holger.dewes:migrate_connect_ids_to_uuid_migrated_conversation_id
CREATE TABLE migrated_conversation_id (
    original_id ${int64} NOT NULL,
    migrated_id ${uuid} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    PRIMARY KEY (original_id)
);

INSERT INTO migrated_conversation_id (original_id, migrated_id)
SELECT id, id_uuid FROM conversation;

--changeset holger.dewes:migrate_connect_ids_to_uuid_drop_cols dbms:oracle
ALTER TABLE conversation_attachment DROP COLUMN message_id CASCADE CONSTRAINTS;
ALTER TABLE conversation_participant DROP COLUMN conversation_id CASCADE CONSTRAINTS;
ALTER TABLE conversation_settings DROP COLUMN conversation_id CASCADE CONSTRAINTS;
ALTER TABLE conversation_message DROP COLUMN conversation_id CASCADE CONSTRAINTS;
ALTER TABLE conversation DROP COLUMN id CASCADE CONSTRAINTS;
ALTER TABLE conversation DROP COLUMN creation_id CASCADE CONSTRAINTS;
ALTER TABLE conversation_attachment DROP COLUMN id CASCADE CONSTRAINTS;
ALTER TABLE conversation_message DROP COLUMN id CASCADE CONSTRAINTS;
ALTER TABLE conversation_message DROP COLUMN creation_id CASCADE CONSTRAINTS;

--changeset holger.dewes:migrate_connect_ids_to_uuid_drop_cols dbms:postgresql
ALTER TABLE conversation_attachment DROP COLUMN message_id;
ALTER TABLE conversation_participant DROP COLUMN conversation_id;
ALTER TABLE conversation_settings DROP COLUMN conversation_id;
ALTER TABLE conversation_message DROP COLUMN conversation_id;
ALTER TABLE conversation DROP COLUMN id;
ALTER TABLE conversation DROP COLUMN creation_id;
ALTER TABLE conversation_attachment DROP COLUMN id;
ALTER TABLE conversation_message DROP COLUMN id;
ALTER TABLE conversation_message DROP COLUMN creation_id;

--changeset holger.dewes:migrate_connect_ids_to_uuid_rename_cols
ALTER TABLE conversation RENAME COLUMN id_uuid TO id;
ALTER TABLE conversation_attachment RENAME COLUMN id_uuid TO id;
ALTER TABLE conversation_message RENAME COLUMN id_uuid TO id;
ALTER TABLE conversation_attachment RENAME COLUMN message_id_uuid TO message_id;
ALTER TABLE conversation_message RENAME COLUMN conversation_id_uuid TO conversation_id;
ALTER TABLE conversation_participant RENAME COLUMN conversation_id_uuid TO conversation_id;
ALTER TABLE conversation_settings RENAME COLUMN conversation_id_uuid TO conversation_id;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_pk_constraints
ALTER TABLE conversation ADD CONSTRAINT conversation_pk PRIMARY KEY (id);
ALTER TABLE conversation_attachment ADD CONSTRAINT conv_attachment_pk PRIMARY KEY (id);
ALTER TABLE conversation_message ADD CONSTRAINT conv_message_pk PRIMARY KEY (id);
ALTER TABLE conversation_participant ADD CONSTRAINT conv_participant_pk UNIQUE (conversation_id, participant_id);
ALTER TABLE conversation_settings ADD CONSTRAINT conv_settings_pk PRIMARY KEY (conversation_id, participant_id);

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_not_null_constraints_all_but_messages dbms:oracle
ALTER TABLE conversation_attachment MODIFY message_id NOT NULL;
ALTER TABLE conversation_participant MODIFY conversation_id NOT NULL;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_not_null_constraints_all_but_messages dbms:postgresql
ALTER TABLE conversation_attachment ALTER message_id SET NOT NULL;
ALTER TABLE conversation_participant ALTER conversation_id SET NOT NULL;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_not_null_constraints_messages dbms:oracle
ALTER TABLE conversation_message MODIFY conversation_id NOT NULL;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_not_null_constraints_messages dbms:postgresql
ALTER TABLE conversation_message ALTER conversation_id SET NOT NULL;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_fk_constraints_all_but_messages
ALTER TABLE conversation_attachment ADD CONSTRAINT conv_attachment_msg_fk
FOREIGN KEY (message_id) REFERENCES conversation_message(id) ON DELETE CASCADE;

ALTER TABLE conversation_participant ADD CONSTRAINT conv_participant_conv_fk
FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE;

ALTER TABLE conversation_settings ADD CONSTRAINT conv_settings_conv_fk
FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE;

--changeset holger.dewes:migrate_connect_ids_to_uuid_add_fk_constraints_messages
ALTER TABLE conversation_message ADD CONSTRAINT conv_message_conv_fk
FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE;

--changeset holger.dewes:migrate_connect_ids_to_uuid_recreate_indexes
CREATE INDEX conv_attachment_msg_fk_idx ON conversation_attachment (message_id);
CREATE INDEX cm_convid_cdate_idx ON conversation_message (conversation_id, create_date DESC);

--changeset holger.dewes:migrate_connect_ids_to_uuid_drop_sequences
DROP SEQUENCE chat_search_queue_seq;
DROP SEQUENCE conversation_seq;
DROP SEQUENCE conversation_attachment_seq;
DROP SEQUENCE conversation_change_seq;
DROP SEQUENCE conversation_message_seq;
DROP SEQUENCE conversation_search_queue_seq;

--changeset holger.dewes:migrate_connect_ids_to_uuid_shadow_tables dbms:oracle
TRUNCATE TABLE sh_conversation;
ALTER TABLE sh_conversation MODIFY id ${uuid};
ALTER TABLE sh_conversation DROP COLUMN creation_id;
ALTER TABLE sh_conversation ADD last_message_id ${uuid};

TRUNCATE TABLE sh_conversation_attachment;
ALTER TABLE sh_conversation_attachment MODIFY id ${uuid};
ALTER TABLE sh_conversation_attachment MODIFY message_id ${uuid};

TRUNCATE TABLE sh_conversation_message;
ALTER TABLE sh_conversation_message MODIFY id ${uuid};
ALTER TABLE sh_conversation_message MODIFY conversation_id ${uuid};
ALTER TABLE sh_conversation_message DROP COLUMN creation_id;

TRUNCATE TABLE sh_conversation_participant;
ALTER TABLE sh_conversation_participant MODIFY conversation_id ${uuid};

TRUNCATE TABLE sh_conversation_settings;
ALTER TABLE sh_conversation_settings MODIFY conversation_id ${uuid};

--changeset holger.dewes:migrate_connect_ids_to_uuid_shadow_tables dbms:postgresql
TRUNCATE TABLE sh_conversation;
ALTER TABLE sh_conversation ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE sh_conversation DROP COLUMN creation_id;
ALTER TABLE sh_conversation ADD last_message_id ${uuid};

TRUNCATE TABLE sh_conversation_attachment;
ALTER TABLE sh_conversation_attachment ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE sh_conversation_attachment ALTER message_id TYPE ${uuid} USING (${generate_uuid});

TRUNCATE TABLE sh_conversation_message;
ALTER TABLE sh_conversation_message ALTER id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE sh_conversation_message ALTER conversation_id TYPE ${uuid} USING (${generate_uuid});
ALTER TABLE sh_conversation_message DROP COLUMN creation_id;

TRUNCATE TABLE sh_conversation_participant;
ALTER TABLE sh_conversation_participant ALTER conversation_id TYPE ${uuid} USING (${generate_uuid});

TRUNCATE TABLE sh_conversation_settings;
ALTER TABLE sh_conversation_settings ALTER conversation_id TYPE ${uuid} USING (${generate_uuid});

--changeset sebastian.fleischer:delete_multicast_feature_toggle
DELETE FROM base_property WHERE property_name = 'Settings/Feature Toggle/chatViaMulticastEnabled' AND container_name = 'systemSettings';

--changeset jkaiser:add_column_tenant_subscription_to_entity
ALTER TABLE entity ADD tenant_subscription_type ${varchar255};
ALTER TABLE sh_entity ADD tenant_subscription_type ${varchar255};

--changeset vinh.phu.phan:add_keep_current_tab_url_field
ALTER TABLE additional_app_info ADD keep_current_tab_url ${bool} DEFAULT ${false} NOT NULL;

--changeset peter.heinicke:delete_export_item_event_table dbms:postgresql
DROP TABLE IF EXISTS export_item_event_queue;
DROP SEQUENCE IF EXISTS export_item_event_queue_seq;

--changeset peter.heinicke:delete_export_item_event_table dbms:oracle endDelimiter:/
BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE export_item_event_queue';
EXCEPTION
    WHEN OTHERS THEN
        IF SQLCODE != -942 THEN
            RAISE;
        END IF;
END;
/

BEGIN
    EXECUTE IMMEDIATE 'DROP SEQUENCE export_item_event_queue_seq';
EXCEPTION
    WHEN OTHERS THEN
        IF SQLCODE != -2289 THEN
            RAISE;
        END IF;
END;
/

--changeset cewers:allow_tenant_ids_as_visibility_role dbms:postgresql
ALTER TABLE item_visibility_role ALTER role_name TYPE ${varchar255};

--changeset cewers:allow_tenant_ids_as_visibility_role dbms:oracle
ALTER TABLE item_visibility_role MODIFY role_name ${varchar255};

--changeset holger.dewes:migrate_custom_app_icons dbms:postgresql
UPDATE additional_app_info
SET icon_url = substring(icon_url from '([^/]+)$')
WHERE app_id IN (SELECT id FROM app WHERE is_core_app = 'f');

ALTER TABLE additional_app_info RENAME icon_url TO icon;

--changeset holger.dewes:migrate_custom_app_icons dbms:oracle
UPDATE additional_app_info
SET icon_url = REGEXP_SUBSTR(icon_url, '([^/]+)$', 1, 1, 'c', 1)
WHERE app_id IN (SELECT id FROM app WHERE is_core_app = 'f');

ALTER TABLE additional_app_info RENAME COLUMN icon_url TO icon;

--changeset holger.dewes:delete_superoperty_social_native_navigation
DELETE FROM base_property
WHERE container_name = 'systemSettings'
AND property_name = 'Settings/mobile/social native navigation';

--changeset alexander.zottnick:add_indexes_to_conversation_participant_table
CREATE INDEX conpart_del_partid_convid_idx ON conversation_participant (deleted, participant_id, conversation_id);
CREATE INDEX conpart_del_convid_partid_idx ON conversation_participant (deleted, conversation_id, participant_id);

--changeset gero.baron:deactivate_just-admin_on_systems_that_were_created_prior_to_12.3_release dbms:oracle
INSERT INTO base_property (id, property_name, description, inheritance_type, default_value, container_name, converter_class)
    SELECT seq_base_property.nextval, 'Settings/Feature Toggle/admin/admin tenant management enabled ', 'Toggle for enabling tenant management via admin app', 'F', 'false', 'systemSettings', 'com.freiheit.superoperty.converter.BooleanConverter' from dual
    WHERE NOT EXISTS (SELECT 1 from base_property WHERE property_name = 'Settings/Feature Toggle/admin/admin tenant management enabled ' AND container_name = 'systemSettings')

--changeset gero.baron:deactivate_just-admin_on_systems_that_were_created_prior_to_12.3_release dbms:postgresql
INSERT INTO base_property (id, property_name, description, inheritance_type, default_value, container_name, converter_class)
    SELECT nextval('seq_base_property'), 'Settings/Feature Toggle/admin/admin tenant management enabled ', 'Toggle for enabling tenant management via admin app', 'F', 'false', 'systemSettings', 'com.freiheit.superoperty.converter.BooleanConverter'
    WHERE NOT EXISTS (SELECT 1 from base_property WHERE property_name = 'Settings/Feature Toggle/admin/admin tenant management enabled ' AND container_name = 'systemSettings')
    AND EXISTS (SELECT 1 from juco_version WHERE id > 0);

--changeset vinh.phu.phan:delete_superoperty_block_internet_explorer_and_legacy_edge
DELETE FROM base_property
WHERE container_name = 'systemSettings'
AND property_name = 'Settings/Feature Toggle/blockInternetExplorerAndLegacyEdge';

--changeset christian.ewers:activate_ada_by_default
UPDATE base_property set default_value='true' WHERE property_name = 'Settings/Feature Toggle/admin/admin tenant management enabled ' and container_name = 'systemSettings';

--changeset tsubklewe:drop_db_patch_version_table
DROP TABLE db_patch_version;

--changeset tsubklewe:drop_greeting_table
DROP TABLE greeting;

--changeset sf:remove_persons_without_tenants_from_chat
INSERT INTO conversation_change
SELECT ${generate_uuid}, conversation_id, participant_id, 'LEFT', ${now} FROM conversation_participant
WHERE participant_id IN (
    SELECT id FROM person
    LEFT JOIN person_tenant ON id = person_id
    WHERE tenant_id IS NULL
)
AND deleted = 'f';

UPDATE conversation_participant
SET deleted = 't',
    modify_date = ${now}
WHERE participant_id IN (
    SELECT id FROM person
    LEFT JOIN person_tenant ON id = person_id
    WHERE tenant_id IS NULL
)
AND deleted = 'f';

--changeset sf:drop_shadow_trigger dbms:postgresql
--comment: drop the triggers because columns of the tables were altered and they don't work anymore.
--comment: Also they will be recreated in the postprocessing step
DROP TRIGGER IF EXISTS conversation_message_ad ON conversation_message;
DROP TRIGGER IF EXISTS conversation_settings_ad ON conversation_settings;
DROP TRIGGER IF EXISTS conversation_participant_ad ON conversation_participant;
DROP TRIGGER IF EXISTS conversation_ad ON conversation;

--changeset sf:drop_shadow_trigger dbms:oracle endDelimiter:/
BEGIN
    EXECUTE IMMEDIATE 'DROP TRIGGER CONVERSATION_MESSAGE_BD';
    EXECUTE IMMEDIATE 'DROP TRIGGER CONVERSATION_SETTINGS_BD';
    EXECUTE IMMEDIATE 'DROP TRIGGER CONVERSATION_PARTICIPANT_BD';
    EXECUTE IMMEDIATE 'DROP TRIGGER CONVERSATION_BD';
EXCEPTION
    WHEN OTHERS THEN
        IF SQLCODE != -4080 THEN
            RAISE;
        END IF;
END;
/

--changeset sf:simple_backup_for_abandoned_chats dbms:postgresql
SELECT * INTO conversation_message_chat_tenant_migration_backup FROM conversation_message
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
));

SELECT * INTO conversation_settings_chat_tenant_migration_backup FROM conversation_settings
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
));

SELECT * INTO conversation_participant_chat_tenant_migration_backup FROM conversation_participant
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
));

SELECT * INTO conversation_chat_tenant_migration_backup FROM conversation
WHERE id IN (SELECT id
             FROM conversation c
             WHERE NOT EXISTS (
                 SELECT 1
                 FROM conversation_participant
                 WHERE conversation_id = c.id
                 AND   deleted = 'f'
));

--changeset sf:delete_abandoned_chats dbms:postgresql
DELETE FROM conversation_message
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
                          ));

DELETE FROM conversation_settings
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
                          ));

DELETE FROM conversation_participant
WHERE conversation_id IN (SELECT id
                          FROM conversation c
                          WHERE NOT EXISTS (
                              SELECT 1
                              FROM conversation_participant
                              WHERE conversation_id = c.id
                              AND   deleted = 'f'
                          ));

DELETE FROM conversation
WHERE id IN (SELECT id
             FROM conversation c
             WHERE NOT EXISTS (
                 SELECT 1
                 FROM conversation_participant
                 WHERE conversation_id = c.id
                 AND   deleted = 'f'
             ));

--changeset sf:add_tenant_id_to_conversation dbms:postgresql
ALTER TABLE conversation ADD tenant_id ${uuid};

UPDATE conversation SET tenant_id = single_tenant.id
FROM (SELECT id
      FROM tenant
      LIMIT 1) AS single_tenant
WHERE NOT EXISTS (
    SELECT 1
    FROM (SELECT COUNT(*) AS tenant_count FROM tenant) number_of_tenants
    WHERE tenant_count > 1
);

UPDATE conversation SET tenant_id = tenant_ids.max_tenant
FROM (SELECT cp.conversation_id,
          (SELECT max_tenant.max_tenant FROM
              (SELECT pt2.tenant_id AS max_tenant, t.ctime, COUNT(*) AS max_tenant_count
              FROM conversation_participant cp2
              JOIN person_tenant pt2 ON cp2.participant_id = pt2.person_id
              JOIN tenant t ON t.id = pt2.tenant_id
              WHERE cp2.conversation_id = cp.conversation_id
              GROUP BY max_tenant, t.ctime
              ORDER BY max_tenant_count DESC, t.ctime ASC LIMIT 1) max_tenant )
      FROM conversation_participant cp
      GROUP BY cp.conversation_id) tenant_ids
WHERE EXISTS (
    SELECT 1
    FROM (SELECT COUNT(*) AS tenant_count FROM tenant) number_of_tenants
    WHERE tenant_count > 1
)
AND id = tenant_ids.conversation_id;

ALTER TABLE conversation ALTER tenant_id SET NOT NULL;

--changeset sf:add_tenant_id_to_conversation dbms:oracle
ALTER TABLE conversation ADD tenant_id ${uuid};
--changeset sf:fill_tenant_id_in_conversation dbms:oracle
UPDATE conversation SET tenant_id = (SELECT id FROM tenant WHERE ROWNUM <= 1);
--changeset sf:make_tenant_id_in_conversation_not_nullable dbms:oracle
ALTER TABLE conversation MODIFY tenant_id NOT NULL;

--changeset sf:add_conversation_tenant_id_to_shadow_table
ALTER TABLE sh_conversation ADD tenant_id ${uuid};

--changeset sf:remove_participants_from_chats_with_incorrect_tenant dbms:postgresql
INSERT INTO conversation_change
SELECT ${generate_uuid}, conversation_id, participant_id, 'LEFT', ${now} FROM
    (SELECT participant_id, conversation_id FROM
        (SELECT participant_id, deleted, conversation_id, c.tenant_id,
            (SELECT 1 FROM person_tenant pt WHERE pt.person_id = participant_id AND pt.tenant_id = c.tenant_id) has_correct_tenant
            FROM conversation_participant
            JOIN conversation c ON c.id = conversation_id) has_correct_tenants
        WHERE has_correct_tenant IS NULL
        AND deleted = 'f') participants_to_remove;

UPDATE conversation_participant cp
SET deleted = 't',
    modify_date = ${now}
FROM (SELECT participant_id, conversation_id FROM
            (SELECT participant_id, deleted, conversation_id, c.tenant_id,
                    (SELECT 1 FROM person_tenant pt WHERE pt.person_id = participant_id AND pt.tenant_id = c.tenant_id) has_correct_tenant
                    FROM conversation_participant
                    JOIN conversation c ON c.id = conversation_id) has_correct_tenants
            WHERE has_correct_tenant IS NULL
            AND deleted = 'f') participants_to_remove
WHERE cp.participant_id = participants_to_remove.participant_id
AND cp.conversation_id = participants_to_remove.conversation_id;


--changeset christian.ewers:drop_unused_superoperty_settings
DELETE FROM base_property
WHERE container_name = 'systemSettings'
AND property_name in ('Settings/Invitation/invite email max number of recipients', 'Settings/EmailPattern/invite email pattern');

--changeset christian.ewers:delete_INVITING_EXTERNAL_from_privacy_settings
DELETE FROM entity_privacy where privacy_type='INVITING_EXTERNAL';

--changeset christian.ewers:delete_ada_feature_toggle
DELETE FROM base_property WHERE property_name = 'Settings/Feature Toggle/admin/admin tenant management enabled ' AND container_name = 'systemSettings';

--changeset christian.ewers:drop_external_invitation
DROP TABLE external_invitation;
DROP TABLE sh_external_invitation;
DELETE FROM shadow_table where lower(table_name)='external_invitation';

--changeset christian.ewers:drop_default_layout_entity_table
DROP TABLE default_layout_entity;

--changeset christian.ewers:drop_external_and_subdomains_from_entity
ALTER TABLE entity DROP COLUMN subdomain;
ALTER TABLE entity DROP COLUMN subdomain_deactivated;
ALTER TABLE entity DROP COLUMN external_domain;

ALTER TABLE sh_entity DROP COLUMN subdomain;
ALTER TABLE sh_entity DROP COLUMN subdomain_deactivated;
ALTER TABLE sh_entity DROP COLUMN external_domain;

--changeset christian.ewers:drop_old_app_writer_toggles
DELETE FROM base_property WHERE property_name = 'Settings/Drive/only tenant managers may create shares' AND container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/People/tenantMembersMayCreateUserGroups' AND container_name = 'systemSettings';

--changeset baron:create_table_poll
CREATE TABLE poll (
    id ${varchar255} NOT NULL PRIMARY KEY,
    question ${varchar1024} NOT NULL,
    allow_multiple_answers ${bool} NOT NULL,
    parent_id ${varchar255} NOT NULL,
    tenant_id ${uuid} NOT NULL
);
${execute} ctime_mtime_columns('poll');

--changeset baron:create_table_poll_answer
CREATE TABLE poll_answer (
    id ${uuid} NOT NULL PRIMARY KEY,
    text ${varchar1024} NOT NULL,
    poll_id ${varchar255} NOT NULL REFERENCES poll (id) ON DELETE CASCADE
);
${execute} ctime_mtime_columns('poll_answer');

--changeset baron:create_table_poll_answer_vote
CREATE TABLE poll_answer_vote (
    PRIMARY KEY (poll_answer_id, profile_id),
    poll_answer_id ${uuid} NOT NULL REFERENCES poll_answer (id) ON DELETE CASCADE,
    profile_id ${varchar255} NOT NULL
);
${execute} ctime_mtime_columns('poll_answer_vote');

--changeset sebastian.fleischer:externalize_conversation_read_date
CREATE TABLE conversation_participant_read_date (
    conversation_id ${uuid} NOT NULL REFERENCES conversation (id) ON DELETE CASCADE,
    participant_id ${int64} NOT NULL,
    read_date ${timestamp} NOT NULL,
    PRIMARY KEY (conversation_id, participant_id)
);

--changeset sebastian.fleischer:externalize_conversation_last_mail_sent
CREATE TABLE conversation_participant_last_mail_sent (
    conversation_id ${uuid} NOT NULL REFERENCES conversation (id) ON DELETE CASCADE,
    participant_id ${int64} NOT NULL,
    last_mail_sent ${timestamp} NOT NULL,
    PRIMARY KEY (conversation_id, participant_id)
);

--changeset sebastian.fleischer:migrate_conversation_participant_data
INSERT INTO conversation_participant_read_date(conversation_id, participant_id, read_date)
    SELECT conversation_id, participant_id, read_date
    FROM conversation_participant;

INSERT INTO conversation_participant_last_mail_sent(conversation_id, participant_id, last_mail_sent)
    SELECT conversation_id, participant_id, last_mail_sent
    FROM conversation_participant
    WHERE last_mail_sent IS NOT NULL;

--changeset sebastian.fleischer:cleanup_conversation_participant_columns
ALTER TABLE conversation_participant DROP COLUMN read_date;
ALTER TABLE conversation_participant DROP COLUMN last_mail_sent;

ALTER TABLE sh_conversation_participant DROP COLUMN read_date;
ALTER TABLE sh_conversation_participant DROP COLUMN last_mail_sent;

--changeset baron:alter_table_poll_answer_add_column_position_oracle dbms:oracle
ALTER TABLE poll_answer ADD position ${int32} NOT NULL;
--changeset baron:alter_table_poll_answer_add_column_position_postgresql dbms:postgresql
ALTER TABLE poll_answer ADD COLUMN position ${int32} NOT NULL;

--changeset vinh.phu.phan:add_author_index_to_conversation_message
CREATE INDEX cm_convid_from_pid_idx ON conversation_message (conversation_id, from_person_id);

--changeset christian.ewers:drop_default_tenant_column
ALTER TABLE tenant DROP COLUMN default_tenant;

--changeset alexander.zottnick:add_user_group_table
CREATE TABLE user_group (
    PRIMARY KEY (group_id),
    group_id ${uuid} NOT NULL,
    name ${varchar64} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    is_all_tenant_users_group ${bool} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    modified_at ${timestamp} DEFAULT ${now} NOT NULL
);

CREATE TABLE user_group_member (
    PRIMARY KEY (group_id, person_id),
    group_id ${uuid} NOT NULL,
    person_id ${int32} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL
);

CREATE INDEX ugm_group_id_idx ON user_group_member (group_id);

--changeset christian.ewers:delete_operations_oauth_client
DELETE FROM oauth_client_details where client_id='operations';

--changeset sebastian.fleischer:create_conversation_user_group
CREATE TABLE conversation_user_group (
    conversation_id ${uuid} NOT NULL REFERENCES conversation (id) ON DELETE CASCADE,
    user_group_id ${uuid} NOT NULL REFERENCES user_group (group_id),
    create_date ${timestamp} DEFAULT ${now} NOT NULL,
    modify_date ${timestamp} DEFAULT ${now} NOT NULL,
    deleted ${bool} DEFAULT ${false} NOT NULL,
    deleted_with_conversation ${bool} DEFAULT ${false} NOT NULL,
    PRIMARY KEY (conversation_id, user_group_id)
);

CREATE INDEX cpg_conversation_id_idx ON conversation_user_group (conversation_id);

CREATE TABLE sh_conversation_user_group (
    conversation_id ${uuid},
    user_group_id ${uuid},
    create_date ${timestamp},
    modify_date ${timestamp},
    deleted ${bool},
    deleted_with_conversation ${bool},
    DELETE_ACTION_ID ${int64},
    FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

--changeset sebastian.fleischer:add_conversation_user_group_to_shadow_tables dbms:postgresql
INSERT INTO shadow_table (table_name, shadow_table_name, delete_action_mandatory) VALUES ('conversation_user_group','sh_conversation_user_group','f');

--changeset sebastian.fleischer:add_conversation_user_group_to_shadow_tables dbms:oracle
INSERT INTO SHADOW_TABLE (TABLE_NAME, SHADOW_TABLE_NAME, DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION_USER_GROUP','SH_CONVERSATION_USER_GROUP','F');

--changeset vinh.phu.phan:add_index_to_conversation_user_group_user_group_id
CREATE INDEX cug_user_group_id_idx ON conversation_user_group (user_group_id);

--changeset christian.ewers:delete_newsblog
DELETE FROM search_index_queue where item_type = 'NEWSBLOG_ARTICLE';
DELETE FROM item_event_queue where type='NEWSBLOG_UPDATED';
DELETE FROM shadow_table where lower(table_name)='news_blog';
DELETE FROM mdl_album WHERE parent_item_type='NEWSBLOG_ARTICLE';
DELETE FROM mdl_comment WHERE parent_item_id LIKE 'NEWSBLOG_ARTICLE,%';
DROP TABLE news_blog;
DROP TABLE sh_news_blog;

--changeset christian.ewers:drop_newsblog_seq dbms:postgresql
drop sequence if exists newsblog_seq cascade;

--changeset christian.ewers:drop_newsblog_seq dbms:oracle
DROP SEQUENCE news_blog_seq;

--changeset christian.ewers:drop_news_blog_ad_function dbms:postgresql
DROP FUNCTION IF EXISTS news_blog_ad_fn() CASCADE;
-- we don't have fixed names for shadow-table functions in oracle

--changeset christian.ewers:drop_newsblog_entity_component
delete from entity_component where component_type ='NEWSBLOG';

--changeset vinh.phu.phan:delete_mobile_toggle_edit_profiles_enabled
DELETE FROM base_property WHERE property_name = 'Settings/mobile/edit profiles enabled' AND container_name = 'systemSettings';

--changeset christian.ewers:drop_more_newsblog_stuff
DELETE from workstream_entry where type in ('NEWSBLOG_ARTICLE_COMMENTED', 'NEWSBLOG_ARTICLE_CREATED', 'NEWSBLOG_ARTICLE_UPDATED');
DELETE FROM like_table WHERE item_id LIKE ('NEWSBLOG%');

--changeset christian.ewers:delete_newsblog_privacy_settings
DELETE FROM entity_component_open_for where component_type = 'NEWSBLOG';

--changeset baron:delete_workstream_attachment_without_poll
DELETE FROM workstream_attachment WHERE item_id LIKE ('POLL,%') AND item_id NOT IN (SELECT p.id from poll p);

--changeset tsubklewe:delete_no_cookies_translation
DELETE from domain_property where base_property IN (SELECT id from base_property where property_name = 'Login/Constants/noCookiesInfo');
DELETE FROM base_property where property_name = 'Login/Constants/noCookiesInfo';

--changeset azottnick:lengthen_user_group_name dbms:oracle
ALTER TABLE user_group MODIFY name ${varchar255};

--changeset azottnick:lengthen_user_group_name dbms:postgresql
ALTER TABLE user_group ALTER COLUMN name type ${varchar255};

--changeset maxse:add_deepl_key_to_tenant dbms:postgresql
ALTER TABLE tenant ADD COLUMN deepl_key ${varchar255};

--changeset maxse:add_deepl_key_to_tenant dbms:oracle
ALTER TABLE tenant ADD deepl_key ${varchar255};

--changeset azottnick:activate_user_groups_in_chat_by_default
DELETE FROM base_property WHERE property_name = 'Settings/Feature Toggle/chatUserGroupMode' and container_name = 'systemSettings';

--changeset sf:drop_backup_tables_of_tenant_migration_in_connect dbms:postgresql
DROP TABLE IF EXISTS conversation_message_chat_tenant_migration_backup;
DROP TABLE IF EXISTS conversation_settings_chat_tenant_migration_backup;
DROP TABLE IF EXISTS conversation_participant_chat_tenant_migration_backup;
DROP TABLE IF EXISTS conversation_chat_tenant_migration_backup;

--changeset christian.ewers:allow_multiple_redirect_uris dbms:postgresql
ALTER TABLE oauth_client_details ALTER COLUMN web_server_redirect_uri TYPE ${varchar1024};

--changeset christian.ewers:allow_multiple_redirect_uris dbms:oracle
ALTER TABLE oauth_client_details MODIFY web_server_redirect_uri ${varchar1024};

--changeset tsubklewe:remove_update_processor
DELETE FROM juco_version_update_process WHERE process = 'UPDATE_WIKI_DRIVE_MEDIA_IDS';

--changeset azottnick:remove_keep_current_tab_url_field
ALTER TABLE additional_app_info DROP COLUMN keep_current_tab_url;

--changeset azottnick:add_open_in_same_tab_field
ALTER TABLE additional_app_info ADD open_in_same_tab ${bool} DEFAULT ${false} NOT NULL;

--changeset christian.ewers:delete_documents_of_newsblog_articles
DELETE FROM drive_document_item WHERE parent LIKE 'NEWSBLOG_ARTICLE,%';

--changeset vinh.phu.phan:remove_superoperty_translations
DELETE FROM domain_property WHERE base_property IN (SELECT id FROM base_property WHERE container_name = 'messages');
DELETE FROM base_property WHERE container_name = 'messages';
DELETE FROM base_property WHERE property_name = 'Settings/use customer specfic translation domains' AND container_name = 'systemSettings';
DROP TABLE customer_domain;

--changeset vinh.phu.phan:remove_used_email_themes
DELETE FROM theme_attribute WHERE attribute_type IN ('EMAIL_SHADED_BOX_COLOR', 'EMAIL_BACKGROUND_COLOR');

--changeset tsubklewe:new_default_profile_config dbms:postgresql
--preconditions onFail:MARK_RAN onError:HALT
--precondition-sql-check expectedResult:0 select count(*) from juco_version;
UPDATE profile_attribute_config SET config = '{"modules":["SECTIONS","PERSONAL_DATA","ROLES"],"sections":[{"type":"DEFAULT","name":"contactTab_basicData","attributes":[{"type":"TEXT","name":"email","searchable":"SEARCH"},{"type":"TEXT","name":"tel","visibleOnBadge":true,"searchable":"SEARCH"},{"type":"TEXT","name":"mobile","searchable":"SEARCH"},{"type":"TEXT","name":"fax","searchable":"SEARCH"},{"type":"TEXT","name":"room","searchable":"SEARCH"},{"type":"TEXT","name":"building","searchable":"SEARCH"},{"type":"TEXT","name":"street","searchable":"SEARCH"},{"type":"TEXT","name":"plz","searchable":"SEARCH"},{"type":"TEXT","name":"city","searchable":"SEARCH"}]},{"type":"DEFAULT","name":"businessTab_basicData","attributes":[{"type":"TEXT","name":"position1","visibleOnBadge":true,"searchable":"SEARCH","clickable":true},{"type":"TEXT","name":"department","visibleOnBadge":true,"searchable":"FACET","clickable":true},{"type":"TEXT","name":"tasks","searchable":"SEARCH"},{"type":"TEXT","name":"additionalInformation","searchable":"SEARCH"}]}],"hiddenPersonFields":["person.home-city","person.current-city","person.home-country","person.current-country","person.title","person.additionalTitle","person.timezone","person.birthday"],"restrictedPersonFields":[]}', create_date = now();

--changeset tsubklewe:update_default_hiddenPersonFields dbms:postgresql
DELETE FROM base_property WHERE property_name = 'Settings/profile/hiddenPersonFields' AND container_name = 'systemSettings' AND default_value = 'person.home-city,person.current-city,person.home-country,person.current-country,person.title,person.additionalTitle,person.timezone';

--changeset peter.heinicke:reset_login_theme_attributes
DELETE FROM theme_attribute WHERE attribute_type IN ('NG_LOGIN_TEXT_COLOR', 'NG_LOGIN_BUTTON_BACKGROUND_COLOR', 'NG_LOGIN_BUTTON_TEXT_COLOR');
