<#macro textComponent><#local content><#nested></#local><#if !blank(content)><@ab>${content}<@br /></@ab></#if></#macro>
<#-- container -->
<#macro container subject=subject><#nested /></#macro>
<#-- header -->
<#macro headerComponent header=header><@textComponent><@escape value=header.platformName /> <<@url />></@textComponent></#macro>
<#-- image with name -->
<#macro imageWithNameComponent name url imagePath="unusedPlaceHolder"><@textComponent>${name}: <${url}></@textComponent></#macro>
<#-- html editor -->
<#macro htmlEditorContentsComponent contents=contents><#list contents as content><@htmlEditorContentComponent content=content /></#list></#macro>
<#-- single html editor -->
<#macro htmlEditorContentComponent content>
<#if !blank(content.headline)><@textComponent><@escape value=content.headline /></@textComponent>
</#if><@textComponent><@userhtml html=content.htmlContent /></@textComponent>
</#macro>
<#-- button -->
<#macro buttonComponent text url><@textComponent>${text} <${url}></@textComponent></#macro>
<#-- footer -->
<#macro footerComponent short=false footer=footer>
<#if !short><@textComponent><@trans key="EmailConstants.emailNotificationInformation" params=[escapef(footer.platformName)] /></@textComponent></#if>
<#list footer.unsubscriptionLinks as link><@textComponent><@trans key="LikeMessages.cancelNotifications" params=[escapef(link.text)] />:
<${link.link}></@textComponent></#list>
<#if !short><@textComponent><@trans key="EmailConstants.modifyEmailNotificationSettings" />: <<@url token="SETTINGS" />></@textComponent></#if>
<@textComponent><@trans key="EmailConstants.customFooter" /></@textComponent>
</#macro>
<#-- short summary -->
<#macro shortSummaryComponent><@textComponent><#nested/></@textComponent></#macro>
<#-- optional message -->
<#macro optionalMessageComponent><@textComponent><#nested/></@textComponent></#macro>
<#-- chat message -->
<#macro chatMessagesComponent chatMessages=chatMessages><#if chatMessages?has_content><@textComponent><#list chatMessages as message>
<@escape value=message.date /> <@escape value=message.author.name />:
<@escape value=message.textContent />
</#list></@textComponent></#if></#macro>
