<#include "../htmlmacros.ftl">

<#macro contentBox width=600 padding=30>
    <tr>
        <td>
            <div style="border: 1px solid rgba(0, 0, 0, 0.2); border-radius: 5px; width: ${width}px">
                <@table width=width-2*padding align="center">
                    <@vspacetr height=padding />
                    <#nested />
                    <@vspacetr height=padding />
                </@table>
            </div>
        </td>
    </tr>
</#macro>

<@container>
    <#include "*/header_html.ftl">
    <@vspacetr height=50 />
    <#if header.logoPath??>
        <tr>
            <td align="center">
                <img height="65" class="banner" border="0" style="display: block; height: 65px;" src="<@storageimage path=header.logoPath />" alt="<@escape value=header.platformName />" />
            </td>
        </tr>
        <@vspacetr height=20 />
    </#if>
    <#-- Notifications -->
    <tr>
        <td align="center">
            <@table align="center" width="600" class="container590">
                <tr>
                    <td align="center">
                        <@table width="600" align="center" class="container580">
                            <tr>
                                <td align="center" style="color: ${theme.textColor}; font-weight: bold; <@fontstyle size=22 />" class="title_color">
                                    <@escape value=headline />
                                </td>
                            </tr>
                            <@vspacetr height=60 />
                            <#list notificationMailModels as notification>
                                <@contentBox>
                                    <tr>
                                        <td align="center">
                                            <table width="530" align="center" class="container580">
                                                <tr valign="middle">
                                                    <td width="40" height="40" align="left">
                                                       <@table width="40" align="left" bgcolor="${notification.appBackgroundColor}" style="border-radius: 5px;">
                                                           <tr valign="middle">
                                                               <td valign="middle" width="40" height="40" align="center" style="line-height:7px;" >
                                                                <a href="${buttonUrl}">
                                                                    <img width="30" border="0" style="display: block; width: 30px;" src="<@storageimage path="${notification.appIconPath}" />" alt="<@escape value=notification.appId />" />
                                                                </a>
                                                               </td>
                                                           </tr>
                                                       </@table>
                                                    </td>
                                                    <td align="center">
                                                        <@table align="right" width="490" >
                                                            <tr>
                                                                <td align="left">
                                                                    <a href="${buttonUrl}" style="padding-left: 5px; color: #404040 !important; <@fontstyle size=13 />">
                                                                        <@escape value=notification.appName />
                                                                    </a>
                                                                </td>
                                                                <td align="left" style="text-align: right; width: 150px;">
                                                                    <a href="${buttonUrl}" style="color: #737373 !important; <@fontstyle size=13 />">
                                                                        <@escape value=notification.timestamp />
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        </@table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <@vspacetr height=16 />
                                    <tr>
                                        <td align="center">
                                            <@table width="530" align="center" class="container580">
                                                <tr>
                                                    <td align="left">
                                                        <a href="${buttonUrl}" style="color: ${theme.textColor}; font-weight: bold; font-size: 32px; line-height: 44px;">
                                                            <@escape value=notification.title />
                                                        </a>
                                                    </td>
                                                </tr>
                                                <@vspacetr height=16 />
                                                <tr>
                                                    <td align="left">
                                                        <a href="${buttonUrl}" style="color: ${theme.linkColor}; font-size: 16px; line-height: 26px;">
                                                            <@escape value=notification.text />
                                                        </a>
                                                    </td>
                                                </tr>
                                                <#if notification.secondaryText?? >
                                                <@vspacetr height=16 />
                                                <tr>
                                                    <td align="left">
                                                        <a href="${buttonUrl}" style="color: #A0A0A0 !important; font-size: 16px; line-height: 26px;">
                                                            <@escape value=notification.secondaryText />
                                                        </a>
                                                    </td>
                                                </tr>
                                                </#if>
                                                <@vspacetr height=30 />
                                                <tr>
                                                    <td align="right">
                                                        <a href="${buttonUrl}" style="color: ${theme.lightLinkTextColor}; font-size: 16px; line-height: 26px;" class="lightlinktextcolor">
                                                            <@trans key="EmailMessages.readNotification" />
                                                        </a>
                                                    </td>
                                                </tr>
                                            </@table>
                                        </td>
                                    </tr>
                                </@contentBox>
                                <#if notification_has_next>
                                    <@vspacetr height=25 />
                                </#if>
                            </#list>
                        </@table>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>

    <@vspacetr height=50 />

    <#-- und 3 weitere Benachritigungen -->
    <#if additionalNotificationCount gt 0>
    <tr>
        <td align="center">
            <@table align="center" width="500" class="container580">
                <tr>
                    <td align="center">
                        <a href="${buttonUrl}" style="color: ${theme.lightLinkTextColor} !important; text-decoration: underline !important; font-size: 16px; line-height: 26px;" class="lightlinktextcolor">
                            <@trans key="EmailMessages.andNumberOfAdditionalUnreadMessages" params=[
                                            additionalNotificationCount
                            ] />
                        </a>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    </#if>

    <@vspacetr height=50 />

    <tr>
        <td align="center">
            <@table align="center" width="470" class="container580">
                <tr>
                    <td align="center" style="color: #000000; <@fontstyle size=13 />">
                        <@trans key="EmailMessages.emailFooterText" />
                    </td>
                </tr>
            </@table>
        </td>
    </tr>

    <#include "*/footer_html.ftl">

    <tr>
        <td align="center">
            <@table align="center" width="560" class="container580">
                <tr>
                    <td align="center" style="<@fontstyle size=12 height=24 />">
                        <a style="color: #737373 !important; text-decoration:underline !important;" href="<@url token="SETTINGS" />"><@trans key="EmailConstants.modifyEmailNotificationSettings" /></a>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=60 />
</@container>
