<#include "../htmlmacros.ftl">

<#function conversationUrlf id>
    <#local result><@url token="CHAT" params=["conversation", "id=" + id.id] /></#local>
    <#return result />
</#function>

<@container>
    <#include "*/header_html.ftl">
    <@vspacetr height=70 />
    <#if header.logoPath??>
        <tr>
            <td align="center">
                <img height="65" class="banner" border="0" style="display: block; height: 65px;" src="<@storageimage path=header.logoPath />" alt="<@escape value=header.platformName />" />
            </td>
        </tr>
        <@vspacetr height=20 />
    </#if>
    <#-- text -->
    <tr>
        <td align="center">
            <@table align="center" width="590" class="container590">
                <tr>
                    <td align="center">
                        <@table width="590" align="center" class="container580">
                            <tr>
                                <td align="center" style="color: ${theme.textColor}; font-weight: bold; <@fontstyle size=22 />" class="title_color">
                                    <#if (numberOfUnreadMessages) == 1>
                                        <@trans key="EmailMessages.oneNewMessageInConversationHeadline" />
                                    <#else>
                                        <@trans key="EmailMessages.multipleNewMessagesInConversationHeadline" />
                                    </#if>
                                </td>
                            </tr>
                            <@vspacetr height=60 />
                            <tr>
                                <td align="center" style="color: ${theme.linkColor}; <@fontstyle size=16 />" class="title_color">
                                <#if (numberOfUnreadMessages) == 1>
                                    <@trans key="EmailMessages.oneNewMessageInConversationText" params=[
                                        "<b>" + escapef(title) + "</b>"
                                    ] />
                                <#else>
                                    <@trans key="EmailMessages.multipleNewMessagesInConversationText" params=[
                                          "<b>" + escapef(title) + "</b>",
                                          numberOfUnreadMessages
                                      ]  />
                                </#if>
                                </td>
                            </tr>
                        </@table>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=10 />

    <@justButtonComponent
      text=transf("EmailMessages.newMessagesInConversationButton")
      url=conversationUrlf(conversationId)
    />

    <@vspacetr height=30 />
    <tr>
        <td align="center">
            <@table align="center" width="470" class="container580">
                <tr>
                    <td align="center" style="color: #000000; <@fontstyle size=13 />">
                        <@trans key="EmailMessages.emailFooterText" />
                    </td>
                </tr>
            </@table>
        </td>
    </tr>

    <#include "*/footer_html.ftl">

    <tr>
        <td align="center">
            <@table align="center" width="560" class="container580">
                <tr>
                    <td align="center" style="color: #737373; <@fontstyle size=12 height=24 />">
                        <@trans key="EmailMessages.messageContentPrivacyReasons" />
                    </td>
                </tr>
                <tr>
                    <td align="center" style="<@fontstyle size=12 height=24 />">
                        <a style="color: #737373 !important; text-decoration:underline !important;" href="<@url token="SETTINGS" />"><@trans key="EmailConstants.modifyEmailNotificationSettings" /></a>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=60 />
</@container>
