<#include "../textmacros.ftl">

<#function conversationUrlf id>
    <#local result><@url token="CHAT" params=["conversation", "id=" + id.id] /></#local>
    <#return result />
</#function>

<@container>
<#include "*/header.ftl">
<@textComponent><@escape value=header.platformName /></@textComponent>

<@textComponent>
<#if (numberOfUnreadMessages) == 1>
    <@trans key="EmailMessages.oneNewMessageInConversationHeadline" />
<#else>
    <@trans key="EmailMessages.multipleNewMessagesInConversationHeadline" />
</#if>

<@escape value="==========================================" />
</@textComponent>

<@textComponent>
<#if (numberOfUnreadMessages) == 1>
    <@trans key="EmailMessages.oneNewMessageInConversationText" params=[
        escapef(title)
    ] />
<#else>
    <@trans key="EmailMessages.multipleNewMessagesInConversationText" params=[
          escapef(title),
          numberOfUnreadMessages
      ]  />
</#if>
</@textComponent>

<@buttonComponent
    text=transf("EmailMessages.newMessagesInConversationButton")
    url=conversationUrlf(conversationId)
/>

<@textComponent>
<@escape value="==========================================" />

<@trans key="EmailMessages.emailFooterText" />
</@textComponent>

<@textComponent><@trans key="EmailConstants.modifyEmailNotificationSettings" />: <<@url token="SETTINGS" />></@textComponent>
<#include "*/footer.ftl">
</@container>
