<#-- component to show a single or multiple html editor contents -->
<#macro htmlEditorContentsComponent contents=contents>
    <#list contents as content>
        <@htmlEditorContentComponent content=content />
    </#list>
</#macro>

<#macro htmlEditorContentComponent content>
<#if !blank(content.headline) || !blank(content.htmlContent)>
    <tr>
        <td align="center">
            <@table align="center" width="590" class="container590 bg_color">
                <tr>
                    <td align="center">
                        <@table align="center" width="560" class="container580">
                            <@vspacetr />
                            <tr>
                                <td align="left">
                                    <@table align="left" width="560" style="table-layout: fixed;" class="container580">
                                        <#if !blank(content.headline)>
                                            <@vspacetr />
                                            <tr>
                                                <td align="center" style="color: ${theme.textColor}; <@fontstyle size=20 />" class="cta-header title_color">
                                                    <@escape value=content.headline />
                                                </td>
                                            </tr>
                                        </#if>
                                        <#if !blank(content.htmlContent)>
                                            <#if !blank(content.headline)>
                                                <@vspacetr />
                                            </#if>
                                            <tr>
                                                <td align="left" style="color: ${theme.textColor}; <@fontstyle size=13 height=20 />" class="text_color">
                                                    <@userhtml html=content.htmlContent />
                                                </td>
                                            </tr>
                                        </#if>
                                    </@table>
                                </td>
                            </tr>
                            <@vspacetr />
                        </@table>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=10 />
</#if>
</#macro>
