<#include "../htmlmacros.ftl">

<@container>
    <#include "*/header_html.ftl">
    <@vspacetr height=70 />
    <#if header.logoPath??>
        <tr>
            <td align="center">
                <img height="65" class="banner" border="0" style="display: block; height: 65px;" src="<@storageimage path=header.logoPath />" alt="<@escape value=header.platformName />" />
            </td>
        </tr>
        <@vspacetr height=20 />
    </#if>
    <#-- text -->
    <tr>
        <td align="center">
            <@table align="center" width="590" class="container590">
                <tr>
                    <td align="center">
                        <@table width="590" align="center" class="container580">
                            <tr>
                                <td align="center" style="color: ${theme.textColor}; font-weight: bold; <@fontstyle size=22 />" class="title_color">
                                    <@trans key="EmailMessages.multipleNewMessagesInChatsHeadline" params=[
                                     unreadMessageCount
                                     ]  />
                                </td>
                            </tr>
                            <@vspacetr height=60 />
                            <tr>
                                <td align="center" style="color: ${theme.linkColor}; <@fontstyle size=16 />" class="title_color">
                                    <@trans key="EmailMessages.newMessagesInChatsText" />
                                </td>
                            </tr>
                            <#list chatMailModels as chat>
                                <tr>
                                    <td align="center">
                                        <a href="${chat.chatUrl}" style="color: #000000 !important; font-size: 16px; line-height: 26px;">
                                            <b><@escape value=chat.title + " (" + chat.unreadMessageCount + ")" /></b>
                                        </a>
                                    </td>
                                </tr>
                            </#list>
                        </@table>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=10 />

    <@justButtonComponent
      text=transf("EmailMessages.newMessagesInChatsButton")
      url=buttonUrl
    />

    <@vspacetr height=30 />
    <tr>
        <td align="center">
            <@table align="center" width="470" class="container580">
                <tr>
                    <td align="center" style="color: #000000; <@fontstyle size=13 />">
                        <@trans key="EmailMessages.emailFooterText" />
                    </td>
                </tr>
            </@table>
        </td>
    </tr>

    <#include "*/footer_html.ftl">

    <tr>
        <td align="center">
            <@table align="center" width="560" class="container580">
                <tr>
                    <td align="center" style="color: #737373; <@fontstyle size=12 height=24 />">
                        <@trans key="EmailMessages.messageContentPrivacyReasons" />
                    </td>
                </tr>
                <tr>
                    <td align="center" style="<@fontstyle size=12 height=24 />">
                        <a style="color: #737373 !important; text-decoration:underline !important;" href="<@url token="SETTINGS" />"><@trans key="EmailConstants.modifyEmailNotificationSettings" /></a>
                    </td>
                </tr>
            </@table>
        </td>
    </tr>
    <@vspacetr height=60 />
</@container>
