/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.superoperty;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class OracleEmptyStringTypeHandlerCallback
implements TypeHandlerCallback {
    private static final String DB_EMPTY_STRING = "$EMPTY$";
    private static final String EMPTY_STRING = "";

    protected void setValue(@Nonnull ParameterSetter setter, @Nonnull String parameter) throws SQLException {
        if (parameter == null) {
            setter.setString(null);
        } else if (parameter.isEmpty()) {
            setter.setString(DB_EMPTY_STRING);
        } else {
            setter.setString(parameter);
        }
    }

    public final void setParameter(ParameterSetter setter, Object parameter) throws SQLException {
        if (parameter == null) {
            setter.setNull(1);
        } else {
            if (!(parameter instanceof String)) {
                throw new IllegalArgumentException("Wrong Type supplied: " + parameter.getClass() + " expected java.lang.String");
            }
            String value = (String)parameter;
            this.setValue(setter, value);
        }
    }

    public final String valueOf(String s) {
        return DB_EMPTY_STRING.equals(s) ? EMPTY_STRING : s;
    }

    public final String getResult(ResultGetter getter) throws SQLException {
        String result = this.valueOf(getter.getString());
        if (getter.wasNull()) {
            return null;
        }
        return result;
    }
}

