/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls.persistence.model;

import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.polls.model.pollid.PollId;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PollDb {
    private final PollId _id;
    private final String _question;
    private final boolean _allowMultipleAnswers;
    private final ItemId _parentId;
    private final TenantId _tenantId;

    public PollDb(PollId id, String question, boolean allowMultipleAnswers, ItemId parentId, TenantId tenantId) {
        this._id = id;
        this._question = question;
        this._allowMultipleAnswers = allowMultipleAnswers;
        this._parentId = parentId;
        this._tenantId = tenantId;
    }

    public PollId getId() {
        return this._id;
    }

    public String getQuestion() {
        return this._question;
    }

    public boolean isAllowMultipleAnswers() {
        return this._allowMultipleAnswers;
    }

    public ItemId getParentId() {
        return this._parentId;
    }

    public TenantId getTenantId() {
        return this._tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollDb pollDb = (PollDb)o;
        if (this._allowMultipleAnswers != pollDb._allowMultipleAnswers) {
            return false;
        }
        if (!this._id.equals(pollDb._id)) {
            return false;
        }
        if (!this._question.equals(pollDb._question)) {
            return false;
        }
        return this._tenantId.equals(pollDb._tenantId);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._question, this._allowMultipleAnswers, this._parentId, this._tenantId);
    }

    public String toString() {
        return "PollDb{_id=" + this._id + ", _question='" + this._question + "', _allowMultipleAnswers=" + this._allowMultipleAnswers + ", _parentId=" + this._parentId + ", _tenantId=" + this._tenantId + "}";
    }
}

