/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls.persistence.mapper;

import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.polls.model.PollAnswerId;
import de.justsoftware.polls.model.pollid.PollId;
import de.justsoftware.polls.persistence.model.PollDb;
import de.justsoftware.polls.persistence.model.PollFindVotesDb;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@ParametersAreNonnullByDefault
@Mapper
public interface PollMapper {
    @Insert(value={"INSERT INTO poll_answer (id, position, text, poll_id)", "VALUES (#{answerId}, #{position}, #{text}, #{pollId})"})
    public void insertAnswer(@Param(value="answerId") PollAnswerId var1, @Param(value="position") int var2, @Param(value="text") String var3, @Param(value="pollId") PollId var4);

    @Insert(value={"INSERT INTO poll (id, question, allow_multiple_answers, parent_id, tenant_id)", "VALUES (#{pollId}, #{question}, #{allowMultipleAnswers}, #{parentId.sqlString}, #{tenantId})"})
    public void insertPoll(@Param(value="pollId") PollId var1, @Param(value="question") String var2, @Param(value="allowMultipleAnswers") boolean var3, @Param(value="parentId") ItemId var4, @Param(value="tenantId") TenantId var5);

    @Insert(value={"<script>", "INSERT INTO poll_answer_vote (poll_answer_id, profile_id)", "VALUES (#{answerId}, #{profileId.sqlString})", "</script>"})
    public void insertVotes(@Param(value="answerId") PollAnswerId var1, @Param(value="profileId") ProfileId var2);

    @Delete(value={"<script>", "DELETE FROM poll_answer_vote", "WHERE profile_id = #{profileId.sqlString}", "AND poll_answer_id IN (SELECT id FROM poll_answer WHERE poll_id = #{pollId})", "</script>"})
    public void deleteVotes(@Param(value="pollId") PollId var1, @Param(value="profileId") ProfileId var2);

    @Delete(value={"DELETE FROM poll WHERE id = #{pollId}"})
    public void deletePoll(PollId var1);

    @Select(value={"SELECT * FROM poll WHERE id = #{pollId}"})
    @CheckForNull
    public PollDb findPoll(@Param(value="pollId") PollId var1);

    @Select(value={"SELECT id FROM poll WHERE parent_id = #{parentId} order by ctime desc"})
    @CheckForNull
    public List<PollId> findPollIdByParenId(@Param(value="parentId") String var1);

    @ConstructorArgs(value={@Arg(javaType=PollAnswerId.class, column="id"), @Arg(javaType=int.class, column="position"), @Arg(javaType=String.class, column="text"), @Arg(javaType=String.class, column="profile_id")})
    @Select(value={"SELECT poll_answer.id, poll_answer.position, poll_answer.text, poll_answer_vote.profile_id FROM poll_answer", "LEFT JOIN poll_answer_vote", "ON poll_answer.id=poll_answer_vote.poll_answer_id", "WHERE poll_answer.poll_id = #{pollId}", "ORDER BY poll_answer.position ASC"})
    public List<PollFindVotesDb> findVotes(PollId var1);
}

