/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls.persistence;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.polls.exception.AlreadyExistsException;
import de.justsoftware.polls.exception.NotFoundException;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.PollAnswer;
import de.justsoftware.polls.model.PollAnswerId;
import de.justsoftware.polls.model.pollid.PollId;
import de.justsoftware.polls.persistence.mapper.PollMapper;
import de.justsoftware.polls.persistence.model.PollDb;
import de.justsoftware.polls.persistence.model.PollFindVotesDb;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class PollDAO {
    private final PollMapper _mapper;

    @Autowired
    public PollDAO(PollMapper mapper) {
        this._mapper = mapper;
    }

    public Poll createPoll(Poll poll) {
        PollDb pollDb = this._mapper.findPoll(poll.getId());
        if (pollDb != null) {
            throw new AlreadyExistsException("Poll with id '" + poll.getId() + "' already exists!");
        }
        this._mapper.insertPoll(poll.getId(), poll.getQuestion(), poll.isAllowMultipleAnswers(), poll.getParentId(), poll.getTenantId());
        poll.getAnswers().forEach(answer -> this._mapper.insertAnswer(answer.getId(), answer.getPosition(), answer.getText(), poll.getId()));
        return poll;
    }

    public void createVotes(Set<PollAnswerId> pollAnswerIds, ProfileId profileId) {
        pollAnswerIds.forEach(answerId -> this._mapper.insertVotes((PollAnswerId)answerId, profileId));
    }

    public void deleteVotes(PollId pollId, ProfileId profileId) {
        this._mapper.deleteVotes(pollId, profileId);
    }

    public PollId deletePoll(PollId pollId) {
        this._mapper.deletePoll(pollId);
        return pollId;
    }

    public Optional<Poll> findPoll(PollId pollId) {
        PollDb pollDb = this._mapper.findPoll(pollId);
        if (pollDb == null) {
            return Optional.empty();
        }
        List<PollFindVotesDb> votesDbs = this._mapper.findVotes(pollId);
        LinkedHashMap<PollAnswerId, Set<ProfileId>> answersToVotes = this.organizeQueryResults(votesDbs);
        ImmutableSet answers = (ImmutableSet)answersToVotes.entrySet().stream().map(this.queryResultToPollAnswers(votesDbs)).collect(ImmutableSet.toImmutableSet());
        return Optional.of(new Poll(pollId, pollDb.getQuestion(), (ImmutableSet<PollAnswer>)answers, pollDb.isAllowMultipleAnswers(), pollDb.getParentId(), pollDb.getTenantId()));
    }

    public Poll getPoll(PollId pollId) {
        return this.findPoll(pollId).orElseThrow(() -> new NotFoundException("Poll with '" + pollId + "' does not exist!"));
    }

    @Nonnull
    public ItemId getPollParent(PollId pollId) {
        PollDb pollDb = this._mapper.findPoll(pollId);
        if (pollDb == null) {
            throw new NotFoundException("Poll with '" + pollId + "' does not exist!");
        }
        return pollDb.getParentId();
    }

    @Nonnull
    private LinkedHashMap<PollAnswerId, Set<ProfileId>> organizeQueryResults(List<PollFindVotesDb> votesDbs) {
        LinkedHashMap<PollAnswerId, Set<ProfileId>> answersToVotes = new LinkedHashMap<PollAnswerId, Set<ProfileId>>();
        votesDbs.forEach(result -> {
            PollAnswerId answerId = result.getAnswerId();
            Optional<ProfileId> profileId = Optional.ofNullable(ProfileId.parse(result.getProfileId()));
            if (answersToVotes.containsKey(answerId)) {
                Set existingProfileIds = (Set)answersToVotes.get(answerId);
                HashSet updatedProfileIds = new HashSet(existingProfileIds);
                profileId.ifPresent(updatedProfileIds::add);
                answersToVotes.put(answerId, Collections.unmodifiableSet(updatedProfileIds));
            } else {
                answersToVotes.put(answerId, profileId.map(Set::of).orElseGet(Set::of));
            }
        });
        return answersToVotes;
    }

    @Nonnull
    private Function<Map.Entry<PollAnswerId, Set<ProfileId>>, PollAnswer> queryResultToPollAnswers(List<PollFindVotesDb> votesDbs) {
        return resultEntry -> {
            PollAnswerId answerId = (PollAnswerId)resultEntry.getKey();
            Set profileIds = (Set)resultEntry.getValue();
            PollFindVotesDb voteDb = votesDbs.stream().filter(pollFindVotesDb -> pollFindVotesDb.getAnswerId().equals(answerId)).findFirst().orElseThrow(RuntimeException::new);
            return new PollAnswer(answerId, voteDb.getPosition(), voteDb.getText(), profileIds);
        };
    }
}

