/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.zookeeper.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import de.justsoftware.onx.zookeeper.JwtKeyConfiguration;
import de.justsoftware.onx.zookeeper.JwtSigningKeyConfiguration;
import de.justsoftware.onx.zookeeper.LTRSearchConfiguration;
import de.justsoftware.onx.zookeeper.OpenIdLoginConfiguration;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"production"})
@ParametersAreNonnullByDefault
public class ZookeeperConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final int ZOOKEEPER_BASE_SLEEP_TIME_MS = 1000;
    private static final int ZOOKEEPER_MAX_RETRIES = 10;
    private static final String ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY = "/just/config/common/jwt/jwtSigningKey";

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"curator"})
    public CuratorFramework curator(@Value(value="${zookeeper.connectString}") String zookeeperConnectString) {
        return CuratorFrameworkFactory.newClient((String)zookeeperConnectString, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"jwtPublicKeyNodeCache"})
    public NodeCache jwtPublicKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/config/common/jwt/publicKey");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"jwtPrivateKeyNodeCache"})
    public NodeCache jwtPrivateKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/config/common/jwt/privateKey");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"jwtSigningKeyNodeCache"})
    public NodeCache jwtSigningKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY);
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"justSearchUpcomingFeatureStore"})
    public NodeCache justSearchUpcomingFeatureStore(CuratorFramework curator) {
        return new NodeCache(curator, "/just/search/ltr/featureStoreName/justSearchUpcomingFeatureStore");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"justSearchModel"})
    public NodeCache justSearchModel(CuratorFramework curator) {
        return new NodeCache(curator, "/just/search/ltr/modelStoreName/justSearchModel");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"justSearchLtrServiceEndpointUrl"})
    public NodeCache justSearchLtrServiceEndpointUrl(CuratorFramework curator) {
        return new NodeCache(curator, "/just/search/ltr/service/endpointURL");
    }

    @Nonnull
    @Bean(name={"jwtKeyConfiguration"})
    public JwtKeyConfiguration jwtConfiguration(final @Qualifier(value="jwtPublicKeyNodeCache") NodeCache jwtPublicKeyNodeCache, final @Qualifier(value="jwtPrivateKeyNodeCache") NodeCache jwtPrivateKeyNodeCache) {
        return new JwtKeyConfiguration(){

            @Override
            public byte[] getPublicKey() {
                return ZookeeperConfiguration.getBase64BytesFromNodeCache(jwtPublicKeyNodeCache);
            }

            @Override
            public byte[] getPrivateKey() {
                return ZookeeperConfiguration.getBase64BytesFromNodeCache(jwtPrivateKeyNodeCache);
            }

            @Override
            public void addChangeListener(JwtKeyConfiguration.JwtConfigurationListener listener) {
                Runnable collectingListener = () -> {
                    byte[] privateKey = this.getPrivateKey();
                    byte[] publicKey = this.getPublicKey();
                    if (privateKey == null || privateKey.length == 0) {
                        LOGGER.debug("no private key configured... ignoring jwt config changes");
                        return;
                    }
                    if (publicKey == null || publicKey.length == 0) {
                        LOGGER.debug("no public key configured... ignoring jwt config changes");
                        return;
                    }
                    listener.onChange(publicKey, privateKey);
                };
                ZookeeperConfiguration.addListener(jwtPublicKeyNodeCache, collectingListener);
                ZookeeperConfiguration.addListener(jwtPrivateKeyNodeCache, collectingListener);
            }
        };
    }

    @Nonnull
    @Bean(name={"jwtSigningKeyConfiguration"})
    public JwtSigningKeyConfiguration jwtSigningKeyConfiguration(@Qualifier(value="jwtSigningKeyNodeCache") NodeCache jwtSigningKeyNodeCache, CuratorFramework curator) {
        return () -> {
            byte[] keyBytes = ZookeeperConfiguration.getBase64BytesFromNodeCache(jwtSigningKeyNodeCache);
            if (keyBytes != null) {
                LOGGER.debug("Loaded signing jwt key from zookeeper");
                return Optional.of(keyBytes);
            }
            keyBytes = SecureRandomUtil.randomBytes(32);
            ACLBackgroundPathAndBytesable createBuilder = (ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
            try {
                createBuilder.forPath(ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY, Base64.getEncoder().encode(keyBytes));
            }
            catch (Exception e) {
                LOGGER.error("Error storing signing JWT key in zookeeper", (Throwable)e);
                return Optional.empty();
            }
            LOGGER.debug("Stored signing jwt key into zookeeper");
            return Optional.ofNullable(keyBytes);
        };
    }

    @Nonnull
    @Bean(name={"ltrSearchConfiguration"})
    public LTRSearchConfiguration ltrSearchConfiguration(final @Qualifier(value="justSearchUpcomingFeatureStore") NodeCache justSearchUpcomingFeatureStore, final @Qualifier(value="justSearchModel") NodeCache justSearchModel, final @Qualifier(value="justSearchLtrServiceEndpointUrl") NodeCache justSearchLtrServiceEndpointUrl) {
        return new LTRSearchConfiguration(){

            @Override
            public String getJustSearchUpcomingFeatureStoreName() {
                return ZookeeperConfiguration.getStringFromNodeCache(justSearchUpcomingFeatureStore);
            }

            @Override
            public String getJustSearchModelStoreName() {
                return ZookeeperConfiguration.getStringFromNodeCache(justSearchModel);
            }

            @Override
            public String getJustSearchLtrServiceEndpointUrl() {
                return ZookeeperConfiguration.getStringFromNodeCache(justSearchLtrServiceEndpointUrl);
            }
        };
    }

    @Bean(destroyMethod="close")
    public OpenIdLoginConfiguration openIdLoginConfig(CuratorFramework curator) throws Exception {
        NodeCache secretCache = new NodeCache(curator, "/just/config/common/just_login/client_secret");
        final TreeCache justLoginCache = new TreeCache(curator, "/just/config/common/just_login");
        justLoginCache.start();
        return new OpenIdLoginConfiguration(){

            @Override
            @CheckForNull
            public String getOpenIdLoginMobileClientId() {
                return Optional.ofNullable(justLoginCache.getCurrentData("/just/config/common/just_login/client_id_mobile")).map(x$0 -> ZookeeperConfiguration.getStringValue(x$0)).orElse(null);
            }

            @Override
            public String getOpenIdLoginClientId() {
                return Optional.ofNullable(justLoginCache.getCurrentData("/just/config/common/just_login/client_id")).map(x$0 -> ZookeeperConfiguration.getStringValue(x$0)).orElse(null);
            }

            @Override
            public String getOpenIdLoginClientSecret() {
                return Optional.ofNullable(justLoginCache.getCurrentData("/just/config/common/just_login/client_secret")).map(x$0 -> ZookeeperConfiguration.getStringValue(x$0)).orElse(null);
            }

            @Override
            public void close() throws Exception {
                justLoginCache.close();
            }
        };
    }

    @CheckForNull
    private static String getStringValue(ChildData childData) {
        return Strings.emptyToNull((String)new String(childData.getData(), Charsets.UTF_8).trim());
    }

    @CheckForNull
    private static String getStringFromNodeCache(NodeCache cache) {
        byte[] bytes = ZookeeperConfiguration.getBytesFromNodeCache(cache);
        return bytes != null ? Strings.emptyToNull((String)new String(bytes, Charsets.UTF_8).trim()) : null;
    }

    @CheckForNull
    private static byte[] getBytesFromNodeCache(NodeCache cache) {
        ChildData currentData = cache.getCurrentData();
        return currentData != null ? currentData.getData() : null;
    }

    @CheckForNull
    private static byte[] getBase64BytesFromNodeCache(NodeCache cache) {
        byte[] bytes = ZookeeperConfiguration.getBytesFromNodeCache(cache);
        return bytes != null ? org.springframework.security.crypto.codec.Base64.decode((byte[])bytes) : null;
    }

    @CheckForNull
    private static String getPathOfNodeCache(NodeCache cache) {
        ChildData currentData = cache.getCurrentData();
        return currentData != null ? currentData.getPath() : null;
    }

    private static void addListener(NodeCache cache, Runnable listener) {
        NodeCacheListener ncl = () -> {
            try {
                listener.run();
            }
            catch (RuntimeException re) {
                LOGGER.error("processing change on " + ZookeeperConfiguration.getPathOfNodeCache(cache) + " raised exception: ", (Throwable)re);
            }
        };
        cache.getListenable().addListener((Object)ncl);
        try {
            ncl.nodeChanged();
        }
        catch (Exception e) {
            LOGGER.error("processing initial value on path " + ZookeeperConfiguration.getPathOfNodeCache(cache) + " raised exception: ", (Throwable)e);
        }
    }
}

