/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.AbstractItem;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import javax.annotation.Nonnull;

public class WorkstreamItem
extends AbstractItem<WorkstreamMessageId> {
    public static final Function<DBWorkstreamMessage, WorkstreamItem> FROM_DB_WORKSTREAM_MESSAGE = new NullPermeableFunction<DBWorkstreamMessage, WorkstreamItem>(){

        @Override
        protected WorkstreamItem applySafe(DBWorkstreamMessage input) {
            return new WorkstreamItem(input);
        }
    };
    public static final Function<WorkstreamItem, DBWorkstreamMessage> TO_DB_WORKSTREAM_MESSAGE = new NullPermeableFunction<WorkstreamItem, DBWorkstreamMessage>(){

        @Override
        protected DBWorkstreamMessage applySafe(WorkstreamItem input) {
            return input.getMessage();
        }
    };
    private final DBWorkstreamMessage _message;

    public WorkstreamItem(@Nonnull DBWorkstreamMessage message) {
        super(StaticComponentType.WORKSTREAM, message.getId(), message.getOriginItemId());
        this._message = message;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public WorkstreamMessageType getType() {
        return this.getMessage().getType();
    }

    @Nonnull
    public DBWorkstreamMessage getMessage() {
        return this._message;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("message", (Object)this.getMessage()).toString();
    }
}

