/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.polls.model.PollCreateModel;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import java.util.Date;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MicroblogPostingEditModel
extends AbstractImmutableEqualsObject {
    private final WorkstreamMessageId _messageId;
    private final String _title;
    private final String _text;
    private final String _quillDelta;
    private final Date _scheduledPublishedDate;
    private final Boolean _pinned;
    private final ImmutableList<? extends Attachment> _addedAttachments;
    private final ImmutableList<ItemId> _deletedAttachments;
    private final ItemId _coverPictureId;
    private final PollCreateModel _poll;

    public MicroblogPostingEditModel(WorkstreamMessageId messageId, String title, String text, String quillDelta, @Nullable Date scheduledPublishedDate, @Nullable Boolean pinned, ImmutableList<? extends Attachment> addedAttachments, ImmutableList<ItemId> deletedAttachments, @Nullable ItemId coverPictureId, @Nullable PollCreateModel poll) {
        super(new Object[0]);
        this._messageId = messageId;
        this._title = title;
        this._text = text;
        this._quillDelta = quillDelta;
        this._scheduledPublishedDate = Dates.clone(scheduledPublishedDate);
        this._pinned = pinned;
        this._addedAttachments = addedAttachments;
        this._deletedAttachments = deletedAttachments;
        this._coverPictureId = coverPictureId;
        this._poll = poll;
    }

    @Nonnull
    public WorkstreamMessageId getMessageId() {
        return this._messageId;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getText() {
        return this._text;
    }

    @Nonnull
    public String getQuillDelta() {
        return this._quillDelta;
    }

    @Nonnull
    public Optional<Date> getScheduledPublishedDate() {
        return Optional.ofNullable(Dates.clone(this._scheduledPublishedDate));
    }

    @CheckForNull
    public Boolean getPinned() {
        return this._pinned;
    }

    @Nonnull
    public ImmutableList<? extends Attachment> getAddedAttachments() {
        return this._addedAttachments;
    }

    @Nonnull
    public ImmutableList<ItemId> getDeletedAttachments() {
        return this._deletedAttachments;
    }

    @CheckForNull
    public ItemId getCoverPictureId() {
        return this._coverPictureId;
    }

    @CheckForNull
    public PollCreateModel getPoll() {
        return this._poll;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("messageId", (Object)this._messageId).add("title", (Object)this._title).add("text", (Object)this._text).add("quillDelta", (Object)this._quillDelta).add("scheduledPublishedDate", (Object)this._scheduledPublishedDate).add("pinned", (Object)this._pinned).add("addedAttachments", this._addedAttachments).add("deletedAttachments", this._deletedAttachments).add("coverPictureId", (Object)this._coverPictureId).add("poll", (Object)this._poll).toString();
    }
}

