/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.polls.model.PollCreateModel;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import java.util.Date;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MicroblogPostingCreateModel
extends AbstractImmutableEqualsObject {
    private final ItemId _originId;
    private final String _title;
    private final String _text;
    private final String _quillDelta;
    private final Date _scheduledPublishedDate;
    private final boolean _pinned;
    private final ImmutableList<Attachment> _attachments;
    private final ItemId _coverPictureId;
    private final PollCreateModel _poll;

    public MicroblogPostingCreateModel(ItemId originId, String title, String text, String quillDelta, @Nullable Date scheduledPublishedDate, boolean pinned, ImmutableList<? extends Attachment> attachments, @Nullable ItemId coverPictureId, @Nullable PollCreateModel poll) {
        super(new Object[0]);
        this._originId = originId;
        this._title = title;
        this._text = text;
        this._quillDelta = quillDelta;
        this._scheduledPublishedDate = Dates.clone(scheduledPublishedDate);
        this._pinned = pinned;
        this._attachments = ImmutableList.copyOf(attachments);
        this._coverPictureId = coverPictureId;
        this._poll = poll;
    }

    @Nonnull
    public ItemId getOriginId() {
        return this._originId;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getText() {
        return this._text;
    }

    @Nonnull
    public String getQuillDelta() {
        return this._quillDelta;
    }

    @Nonnull
    public Optional<Date> getScheduledPublishDate() {
        return Optional.ofNullable(Dates.clone(this._scheduledPublishedDate));
    }

    @Nonnull
    public boolean isPinned() {
        return this._pinned;
    }

    @Nonnull
    public ImmutableList<Attachment> getAttachments() {
        return this._attachments;
    }

    @CheckForNull
    public ItemId getCoverPictureId() {
        return this._coverPictureId;
    }

    @CheckForNull
    public PollCreateModel getPoll() {
        return this._poll;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("originId", (Object)this._originId).add("title", (Object)this._title).add("text", (Object)this._text).add("quillDelta", (Object)this._quillDelta).add("scheduledPublishedDate", (Object)this._scheduledPublishedDate).add("pinned", this._pinned).add("attachments", this._attachments).add("coverPictureId", (Object)this._coverPictureId).add("poll", (Object)this._poll).toString();
    }
}

