/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.HasComments;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MicroblogPosting
extends AbstractWorkstreamMessage<ItemId>
implements HasComments {
    public static final String TEXT_KEY = "text";
    public static final String QUILL_DELTA_KEY = "quill_delta";
    public static final String EDITED_AT_KEY = "edited_at";
    public static final String EDITED_BY_KEY = "edited_by";
    public static final String TITLE_KEY = "title";
    private static final long serialVersionUID = 1L;
    private final String _title;
    private final String _text;
    private final String _quillDelta;
    private final ImmutableList<Attachment> _attachments;
    private final boolean _mayComment;
    private final PersonTeaserModel _editedBy;
    private final Date _editedAt;

    public MicroblogPosting(DBWorkstreamMessage m, PersonTeaserModel author, @Nullable PersonTeaserModel editedBy, @Nullable PersonTeaserModel pinAuthor, ImmutableSet<Action> may, boolean mayComment, ImmutableList<Attachment> attachments) {
        super(m, author, pinAuthor, may);
        this._editedBy = editedBy;
        this._title = m.getAttribute(TITLE_KEY);
        this._text = m.getAttribute(TEXT_KEY);
        this._quillDelta = m.getAttribute(QUILL_DELTA_KEY);
        this._attachments = attachments;
        this._editedAt = MicroblogPosting.getEditedAt(m);
        this._mayComment = mayComment;
    }

    @Override
    public Date getPublishedAt() {
        return Dates.clone(this._publishedAt);
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitMicroblogPosting(this);
    }

    public String getText() {
        return this._text;
    }

    public String getQuillDelta() {
        return this._quillDelta;
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.MICROBLOG_POSTING;
    }

    @Override
    public ImmutableList<Attachment> getAttachments() {
        return this._attachments != null ? this._attachments : ImmutableList.of();
    }

    public String getTitle() {
        return this._title;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add(TITLE_KEY, (Object)this._title).add(TEXT_KEY, (Object)this._text).add("attachments", this._attachments).add("editedBy", (Object)this._editedBy).add("editedAt", (Object)this._editedAt).toString();
    }

    @Override
    public ItemId getCommentParentId() {
        return this.getId();
    }

    @Override
    public boolean mayComment() {
        return this._mayComment;
    }

    @CheckForNull
    public PersonTeaserModel getEditedBy() {
        return this._editedBy;
    }

    @CheckForNull
    public Date getEditedAt() {
        return Dates.clone(this._editedAt);
    }

    @CheckForNull
    public static PersonId getEditedBy(DBWorkstreamMessage message) {
        return PersonId.parse(message.getAttribute(EDITED_BY_KEY));
    }

    @CheckForNull
    public static Date getEditedAt(DBWorkstreamMessage m) {
        String editedAtAttribute = m.getAttribute(EDITED_AT_KEY);
        if (editedAtAttribute == null) {
            return null;
        }
        Long editedAt = Long.valueOf(editedAtAttribute);
        if (editedAt == null) {
            return null;
        }
        return new Date(editedAt);
    }
}

