/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageCommented
extends AbstractActivityWorkstreamMessage<GlobalId> {
    public static final String IMAGE_ID_KEY = "image_id";
    private static final long serialVersionUID = 1L;
    private final AlbumImageId _imageId;
    private String _imageName;
    private AlbumId _albumId;
    private String _albumName;

    public ImageCommented(PersonId authorId, AlbumImageId imageId, @Nonnull GlobalId originId) {
        super(authorId, originId, new Date());
        this._imageId = imageId;
    }

    public ImageCommented(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, @Nullable AlbumImageId imageId, @Nullable String imageName, @Nullable AlbumId albumId, @Nullable String albumName) {
        super(m, author, may);
        this._imageId = imageId;
        this._imageName = imageName;
        this._albumId = albumId;
        this._albumName = albumName;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitImageCommented(this);
    }

    public AlbumImageId getImageId() {
        return this._imageId;
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ALBUM_IMAGE_COMMENTED;
    }

    public String getImageName() {
        return this._imageName;
    }

    public AlbumId getAlbumId() {
        return this._albumId;
    }

    public String getAlbumName() {
        return this._albumName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("imageId", (Object)this._imageId).add("imageName", (Object)this._imageName).add("albumId", (Object)this._albumId).add("albumName", (Object)this._albumName).toString();
    }
}

