/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityNewMembership
extends AbstractActivityWorkstreamMessage<EntityId> {
    private static final long serialVersionUID = 1L;
    private final EntityType _entityType;
    private final String _entityName;

    public EntityNewMembership(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, @Nonnull String name, @Nonnull EntityType entityType) {
        super(m, author, may);
        this._entityName = name;
        this._entityType = entityType;
    }

    public EntityNewMembership(@Nonnull PersonId personId, @Nonnull EntityId id, @Nonnull String name, @Nonnull EntityType type) {
        super(personId, id, new Date());
        this._entityName = name;
        this._entityType = type;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitEntityNewMembership(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ENTITY_NEW_MEMBERSHIP;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Nonnull
    public String getEntityName() {
        return this._entityName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("entityType", (Object)this._entityType).add("entityName", (Object)this._entityName).toString();
    }
}

