/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DriveDocumentNewVersion
extends AbstractActivityWorkstreamMessage<ItemId> {
    public static final String DOCUMENT_NAME_KEY = "document_name";
    public static final String DOCUMENT_VERSION_KEY = "document_version";
    private static final long serialVersionUID = 1L;
    private final DriveDocumentId _documentId;
    private final String _documentName;
    private final int _version;

    public DriveDocumentNewVersion(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, DriveDocumentId documentId, String documentName, int version) {
        super(m, author, may);
        this._documentId = documentId;
        this._documentName = documentName;
        this._version = version;
    }

    public DriveDocumentNewVersion(@Nullable PersonId authorId, ItemId originId, DriveDocumentId documentId, String documentName, int version, Date createDate) {
        super(authorId, originId, createDate);
        this._documentId = documentId;
        this._documentName = documentName;
        this._version = version;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitDriveDocumentNewVersion(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.DRIVE_DOCUMENT_NEW_VERSION;
    }

    @Nonnull
    public DriveDocumentId getDocumentId() {
        return this._documentId;
    }

    @Nonnull
    public String getDocumentName() {
        return this._documentName;
    }

    @Override
    public String toString() {
        return this.superToString().add("documentId", (Object)this._documentId).add("documentName", (Object)this._documentName).add("version", this._version).toString();
    }

    public int getVersion() {
        return this._version;
    }
}

