/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.attachments;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentVisitor;
import de.justsoftware.onx.workstream.shared.model.attachments.LinkAttachment;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InternalLinkAttachment
extends LinkAttachment {
    private static final long serialVersionUID = 1L;
    private GlobalId _linkedId;
    private String _title;

    @Deprecated
    public InternalLinkAttachment() {
    }

    public InternalLinkAttachment(String url, @Nullable String title, String faviconUrl, @Nullable GlobalId linkedId) {
        super(url);
        this._title = title;
        this._linkedId = linkedId;
    }

    public InternalLinkAttachment(LinkId linkId, String url, @Nullable String title, @Nullable GlobalId linkedId) {
        super(linkId, url);
        this._title = title;
        this._linkedId = linkedId;
    }

    @CheckForNull
    public GlobalId getLinkedId() {
        return this._linkedId;
    }

    @Override
    public <T> T accept(AttachmentVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("linkedId", (Object)this._linkedId).add("title", (Object)this._title);
    }

    @Override
    public String getTitle(LocalizedMessages localizedMessages) {
        return (String)MoreObjects.firstNonNull((Object)this._title, (Object)this.getUrl());
    }

    @Override
    public String getRawTitle() {
        return this._title;
    }

    @Nonnull
    public String getUrlCleaned() {
        String url = this.getUrl();
        return url.startsWith("#") ? url.substring(1) : url;
    }
}

