/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.attachments;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveTempId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentType;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DriveDocumentAttachment
implements Attachment {
    private static final long serialVersionUID = 1L;
    private DriveDocumentId _id;
    private String _name;
    private DriveTempId _tempId;
    private long _fileSize;
    private int _likeCount;
    private int _commentCount;
    private String _mimeType;

    @Deprecated
    public DriveDocumentAttachment() {
    }

    public DriveDocumentAttachment(DriveDocumentId id, String name, long fileSize, String mimeType, int likeCount, int commentCount) {
        this._id = id;
        this._name = name;
        this._mimeType = mimeType;
        this._fileSize = fileSize;
        this._likeCount = likeCount;
        this._commentCount = commentCount;
    }

    public DriveDocumentAttachment(DriveTempId tempId, String name, String mimeType) {
        this._tempId = tempId;
        this._name = name;
        this._mimeType = mimeType;
    }

    @Override
    public <T> T accept(AttachmentVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Override
    public DriveDocumentId getId() {
        return this._id;
    }

    @Override
    public AttachmentType getType() {
        return AttachmentType.DRIVE_DOCUMENT;
    }

    @Override
    public int getLikeCount() {
        return this._likeCount;
    }

    @Override
    public int getCommentCount() {
        return this._commentCount;
    }

    public void setId(DriveDocumentId id) {
        this._id = id;
    }

    @CheckForNull
    public DriveTempId getTempId() {
        return this._tempId;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("tempId", (Object)this._tempId).add("likeCount", this._likeCount).add("commentCount", this._commentCount).add("mimeType", (Object)this._mimeType).add("fileSize", this._fileSize).toString();
    }

    @CheckForNull
    public String getMimeType() {
        return this._mimeType;
    }
}

