/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageTypeVisitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="members of enums aren't serialized")
public enum WorkstreamMessageType implements WorkstreamFilterMessageType
{
    ENTITY_CREATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitEntityCreated();
        }
    }),
    ENTITY_NEW_MEMBERSHIP(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitEntityNewMembership();
        }
    }),
    ENTITY_DESCRIPTION_UPDATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitEntityDescriptionUpdated();
        }
    }),
    MICROBLOG_POSTING(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitMicroblogPosting();
        }
    }),
    ALBUM_CREATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitAlbumCreated();
        }
    }),
    ALBUM_IMAGE_CREATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitAlbumImageCreated();
        }
    }),
    ALBUM_IMAGE_COMMENTED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitAlbumImageCommented();
        }
    }),
    WIKI_VERSION_CREATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitWikiVersionCreated();
        }
    }),
    DRIVE_DOCUMENT_NEW_VERSION(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitDriveDocumentNewVersion();
        }
    }),
    DRIVE_DOCUMENT_COMMENT(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitDriveDocumentComment();
        }
    }),
    DOCUMENT_COMMENT(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitUnsupportedType();
        }
    }),
    VIDEOLINK_CREATED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitVideolinkCreated();
        }
    }),
    VIDEOLINK_COMMENTED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitVideolinkCommented();
        }
    }),
    ENTITY_VERSION_PUBLISHED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitEntityVersionPublished();
        }
    }),
    ENTITY_PARENTS_CHANGED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitEntityParentsChanged();
        }
    }),
    SURVEY_PUBLISHED(new Acceptor(){

        @Override
        public <T> T accept(WorkstreamMessageTypeVisitor<T> visitor) {
            return visitor.visitSurveyPublished();
        }
    });

    private static final ImmutableSet<WorkstreamMessageType> SUPPORTED_TYPES;
    private final ImmutableSet<WorkstreamMessageType> _messageTypes = ImmutableSet.of((Object)this);
    private final Acceptor _acceptor;

    private WorkstreamMessageType(Acceptor acceptor) {
        this._acceptor = acceptor;
    }

    @Nonnull
    public static ImmutableSet<WorkstreamMessageType> supportedValues() {
        return SUPPORTED_TYPES;
    }

    @Nonnull
    public <T> T accept(@Nonnull WorkstreamMessageTypeVisitor<T> visitor) {
        return this._acceptor.accept(visitor);
    }

    @Override
    public ImmutableSet<WorkstreamMessageType> getMessageTypes() {
        return this._messageTypes;
    }

    static {
        SUPPORTED_TYPES = FluentIterable.from((Object[])WorkstreamMessageType.values()).filter(type -> type != DOCUMENT_COMMENT).toSet();
    }

    private static interface Acceptor {
        @Nonnull
        public <T> T accept(@Nonnull WorkstreamMessageTypeVisitor<T> var1);
    }
}

