/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.workstream.shared.model.MultiWorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterContext;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class WorkstreamFilterModel
implements Serializable {
    public static final String CFG_ALL_ENTITIES = "ALL_ENTITIES";
    public static final WorkstreamFilterModel ALL = new WorkstreamFilterModel(new WorkstreamFilterId("ALL"), WorkstreamFilterContext.ALL, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of(), 30);
    public static final WorkstreamFilterModel HERE = new WorkstreamFilterModel(new WorkstreamFilterId("HERE"), WorkstreamFilterContext.HERE, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of(), 30);
    public static final WorkstreamFilterModel MICROBLOG = new WorkstreamFilterModel(new WorkstreamFilterId("MICROBLOG"), WorkstreamFilterContext.ALL, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of((Object)MultiWorkstreamFilterMessageType.MICROBLOG), 30);
    public static final WorkstreamFilterModel FEED = new WorkstreamFilterModel(new WorkstreamFilterId("FEED"), WorkstreamFilterContext.ALL, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of((Object)MultiWorkstreamFilterMessageType.ALL_ACTIVITIES), 30);
    private static final long serialVersionUID = 1L;
    private final WorkstreamFilterId _id;
    private final WorkstreamFilterContext _context;
    private final ImmutableSet<String> _origins;
    private final ImmutableSet<? extends WorkstreamFilterMessageType> _messageTypes;
    private final int _maxCount;

    public WorkstreamFilterModel(WorkstreamFilterId id, WorkstreamFilterContext context, ImmutableSet<String> origins, ImmutableSet<? extends WorkstreamFilterMessageType> messageTypes, int maxCount) {
        this._id = id;
        this._context = context;
        this._origins = origins;
        this._messageTypes = messageTypes;
        this._maxCount = maxCount;
    }

    @Nonnull
    public WorkstreamFilterId getId() {
        return this._id;
    }

    @Nonnull
    public WorkstreamFilterContext getContext() {
        return this._context;
    }

    @Nonnull
    public ImmutableSet<String> getOrigins() {
        return this._origins;
    }

    @Nonnull
    public ImmutableSet<? extends WorkstreamFilterMessageType> getMessageTypes() {
        return this._messageTypes;
    }

    public int getMaxCount() {
        return this._maxCount;
    }

    @Nonnull
    public WorkstreamFilterModel cloneWithMessageTypes(ImmutableSet<? extends WorkstreamFilterMessageType> messageTypes) {
        return new WorkstreamFilterModel(this._id, this._context, this._origins, messageTypes, this._maxCount);
    }

    @Nonnull
    public WorkstreamFilterModel cloneWithOrigins(ImmutableSet<String> origins) {
        return new WorkstreamFilterModel(this._id, this._context, origins, this._messageTypes, this._maxCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("context", (Object)this._context).add("origin", this._origins).add("messageType", this._messageTypes).add("maxCount", this._maxCount).toString();
    }

    @Nonnull
    public static WorkstreamFilterModel getByIdOrDefault(@Nullable WorkstreamFilterId filterId, @Nonnull WorkstreamFilterListModel filters) {
        ImmutableMap<WorkstreamFilterId, WorkstreamFilterModel> filterMap = filters.getFilters();
        if (filterId == null) {
            return (WorkstreamFilterModel)filterMap.get(filters.getDefaultfilter());
        }
        WorkstreamFilterModel res = (WorkstreamFilterModel)filterMap.get(filterId);
        if (res != null) {
            return res;
        }
        return (WorkstreamFilterModel)filterMap.get(filters.getDefaultfilter());
    }
}

