/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumCreated;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumImageCreated;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentComment;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentNewVersion;
import de.justsoftware.onx.workstream.shared.model.messages.EntityCreated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityDescriptionUpdated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityNewMembership;
import de.justsoftware.onx.workstream.shared.model.messages.EntityParentsChanged;
import de.justsoftware.onx.workstream.shared.model.messages.EntityVersionPublished;
import de.justsoftware.onx.workstream.shared.model.messages.ImageCommented;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.SurveyPublished;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCommented;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCreated;
import de.justsoftware.onx.workstream.shared.model.messages.WikiVersionCreated;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import javax.annotation.Nonnull;

public class StringForMessageVisitor
implements MessageVisitor<String> {
    private static final StringForMessageWrapper NAME_WRAPPER = new StringForMessageWrapper(){

        @Override
        public String wrapEntity(String name, EntityType entityType, EntityId entityId) {
            return name;
        }

        @Override
        public String wrapPerson(String name, PersonId personId) {
            return name;
        }

        @Override
        public String wrapAlbum(String name, AlbumId albumId) {
            return name;
        }

        @Override
        public String wrapPicture(String name, AlbumImageId imageId) {
            return name;
        }

        @Override
        public String wrapDocument(String name, DocumentId documentId) {
            return name;
        }

        @Override
        public String wrapDriveDocument(String name, DriveDocumentId documentId) {
            return name;
        }

        @Override
        public String wrapVideolink(String name, VideolinkId videolinkId) {
            return name;
        }

        @Override
        public String wrapSurvey(String title, SurveyId surveyId) {
            return title;
        }

        @Override
        public String postProcess(String result) {
            return result;
        }
    };
    protected final LocalizedMessages _localizedMessages;
    protected final StringForMessageWrapper _wrapper;

    public StringForMessageVisitor(@Nonnull LocalizedMessages localizedMessages, @Nonnull StringForMessageWrapper wrapper) {
        this._localizedMessages = localizedMessages;
        this._wrapper = wrapper;
    }

    public StringForMessageVisitor(@Nonnull LocalizedMessages localizedMessages) {
        this(localizedMessages, NAME_WRAPPER);
    }

    @Nonnull
    protected final String wrapAuthor(@Nonnull WorkstreamMessage m) {
        return this.wrapAuthor(m, " ");
    }

    @Nonnull
    protected String wrapAuthor(@Nonnull WorkstreamMessage m, @Nonnull String suffix) {
        String authorName = m.getAuthorName();
        return this._wrapper.wrapPerson(StringUtil.isBlank(authorName) ? this._localizedMessages.workstreamConstants().unknownAuthor() : authorName, m.getAuthorId()) + suffix;
    }

    @Override
    public String visitEntityCreated(EntityCreated m) {
        EntityType entityType = m.getEntityType();
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.entityMessages(entityType).feedMessageEntityCreated(this._wrapper.wrapEntity(m.getEntityName(), entityType, (EntityId)m.getOriginId()), entityType));
    }

    @Override
    public String visitEntityNewMembership(EntityNewMembership m) {
        EntityType entityType = m.getEntityType();
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.entityMessages(entityType).feedMessageNewMembership(this._wrapper.wrapEntity(m.getEntityName(), entityType, (EntityId)m.getOriginId()), entityType));
    }

    @Nonnull
    protected String createMicroblogPostingString(@Nonnull MicroblogPosting m, @Nonnull String authorDelimiter) {
        return this._wrapper.postProcess(this.wrapAuthor(m, authorDelimiter) + StringUtil.defaultIfBlank(m.getText(), ""));
    }

    @Override
    public String visitMicroblogPosting(MicroblogPosting m) {
        return this.createMicroblogPostingString(m, " ");
    }

    @Override
    public String visitAlbumCreated(AlbumCreated m) {
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.albumMessages().feedMessageAlbumCreated(this._wrapper.wrapAlbum(m.getAlbumTitle(), m.getAlbumId())));
    }

    @Override
    public String visitAlbumImageCreated(AlbumImageCreated m) {
        String author = this.wrapAuthor(m);
        String album = this._wrapper.wrapAlbum(m.getAlbumName(), m.getAlbumId());
        String result = StringUtil.isBlank(m.getImageName()) ? this._localizedMessages.albumMessages().feedMessageUnnamedImageCreated(album, this._wrapper.wrapPicture(this._localizedMessages.albumConstants().picture(), m.getImageId())) : this._localizedMessages.albumMessages().feedMessageNamedImageCreated(album, this._wrapper.wrapPicture(m.getImageName(), m.getImageId()));
        return this._wrapper.postProcess(author + result);
    }

    @Override
    public String visitWikiVersionCreated(WikiVersionCreated m) {
        EntityType entityType = m.getEntityType();
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.entityMessages(entityType).feedMessageNewWikiVersion(m.getVersion(), this._wrapper.wrapEntity(m.getEntityName(), entityType, (EntityId)m.getOriginId()), entityType));
    }

    @Override
    public String visitDriveDocumentNewVersion(DriveDocumentNewVersion m) {
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.documentMessages().feedMessageOneNewDocumentInEntity());
    }

    @Override
    public String visitDriveDocumentComment(DriveDocumentComment m) {
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.documentMessages().feedMessageDocumentCommented(this._wrapper.wrapDriveDocument(m.getDocumentName(), m.getDocumentId())));
    }

    @Override
    public String visitVideolinkCreated(VideolinkCreated m) {
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.videolinkMessages().feedMessageNamedVideoNew(this._wrapper.wrapVideolink(m.getVideoTitle(), m.getVideolinkId())));
    }

    @Override
    public String visitVideolinkCommented(VideolinkCommented m) {
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.videolinkMessages().feedMessageNamedVideoCommented(this._wrapper.wrapVideolink(m.getVideoTitle(), m.getVideolinkId())));
    }

    @Override
    public String visitImageCommented(ImageCommented m) {
        String author = this.wrapAuthor(m);
        String albumName = this._wrapper.wrapAlbum(m.getAlbumName(), m.getAlbumId());
        String result = StringUtil.isBlank(m.getImageName()) ? this._localizedMessages.albumMessages().feedMessageUnamedImageCommented(albumName, this._wrapper.wrapPicture(this._localizedMessages.albumConstants().picture(), m.getImageId())) : this._localizedMessages.albumMessages().feedMessageNamedImageCommented(albumName, this._wrapper.wrapPicture(m.getImageName(), m.getImageId()));
        return this._wrapper.postProcess(author + result);
    }

    @Override
    public String visitEntityDescriptionUpdated(EntityDescriptionUpdated m) {
        EntityType entityType = m.getEntityType();
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.entityMessages(entityType).feedDescriptionUpdated(this._wrapper.wrapEntity(m.getEntityName(), entityType, (EntityId)m.getOriginId()), entityType));
    }

    @Override
    public String visitEntityVersionPublished(EntityVersionPublished m) {
        EntityType entityType = m.getEntityType();
        Object msg = this._localizedMessages.entityMessages(entityType).feedPublishedEntityVersion(m.getVersionString(), entityType);
        String changeMessage = m.getChangeMessage();
        if (!StringUtil.isBlank(changeMessage)) {
            msg = (String)msg + " " + this._localizedMessages.entityMessages(entityType).feedPublishedEntityVersionChangeMessage(changeMessage);
        }
        return this._wrapper.postProcess(this.wrapAuthor(m) + (String)msg);
    }

    @Override
    public String visit(EntityParentsChanged m) {
        EntityType entityType = m.getEntityType();
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.entityMessages(entityType).feedEntityParentsChanged(this._wrapper.wrapEntity(m.getEntityName(), entityType, (EntityId)m.getOriginId()), entityType));
    }

    @Override
    public String visitSurveyPublished(SurveyPublished m) {
        String surveyName = this._wrapper.wrapSurvey(m.getSurveyTitle(), m.getSurveyId());
        return this._wrapper.postProcess(this.wrapAuthor(m) + this._localizedMessages.surveyMessages().feedMessageSurveyCreated(surveyName));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localizedMessages", (Object)this._localizedMessages).toString();
    }

    public static interface StringForMessageWrapper {
        @Nonnull
        public String wrapEntity(@Nonnull String var1, @Nonnull EntityType var2, @Nonnull EntityId var3);

        @Nonnull
        public String wrapPerson(@Nonnull String var1, @Nonnull PersonId var2);

        @Nonnull
        public String wrapAlbum(@Nonnull String var1, @Nonnull AlbumId var2);

        @Nonnull
        public String wrapPicture(@Nonnull String var1, @Nonnull AlbumImageId var2);

        @Nonnull
        public String wrapDocument(@Nonnull String var1, @Nonnull DocumentId var2);

        @Nonnull
        public String wrapDriveDocument(@Nonnull String var1, @Nonnull DriveDocumentId var2);

        @Nonnull
        public String wrapVideolink(@Nonnull String var1, @Nonnull VideolinkId var2);

        @Nonnull
        public String wrapSurvey(@Nonnull String var1, @Nonnull SurveyId var2);

        @Nonnull
        public String postProcess(@Nonnull String var1);
    }
}

