/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamReadDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IbatisWorkstreamReadDAO
implements WorkstreamReadDAO {
    private final IbatisStatementBuilder _ibatisBuilder;

    @ParametersAreNonnullByDefault
    @Autowired
    public IbatisWorkstreamReadDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("WorkstreamRead");
    }

    @Override
    public void markRead(PersonId personId, ItemId itemId, DateTime readDate) {
        ImmutableMap data = ImmutableMap.of((Object)"personId", (Object)personId, (Object)"itemId", (Object)itemId, (Object)"readDate", (Object)readDate);
        if (this._ibatisBuilder.update("updateMarkRead").param(data) <= 0) {
            try {
                this._ibatisBuilder.insert("insertMarkRead").param(data);
            }
            catch (DAOException e) {
                this._ibatisBuilder.update("updateMarkRead").param(data);
            }
        }
    }

    @Override
    public ImmutableTable<PersonId, ItemId, DateTime> getByPersonsAndItems(SetMultimap<? extends PersonId, ? extends ItemId> personsAndItems) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getByPersonsAndItems").partition(personsAndItems.entries())).asTable("personId", "itemId", "readDate");
    }

    @Override
    public void deleteReadEntries(Set<PersonId> personIds, Set<? extends ItemId> itemIds) {
        this._ibatisBuilder.delete("deleteByPersons").partition(personIds);
        this._ibatisBuilder.delete("deleteByItems").partition(itemIds);
    }
}

