/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.workstream.integration.persistence.ScheduledWorkstreamMessageDAO;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IbatisScheduledWorkstreamMessageDAO
implements ScheduledWorkstreamMessageDAO {
    private final IbatisStatementBuilder _ibatisBuilder;
    private final TransactionHelper _transactionHelper;

    @ParametersAreNonnullByDefault
    @Autowired
    public IbatisScheduledWorkstreamMessageDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("ScheduledWorkstreamMessage");
        this._transactionHelper = transactionHelper;
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getScheduledWorkstreamMessagesByIds(Set<WorkstreamMessageId> messageIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getById").partition(messageIds)).asMap("key", "value");
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getScheduledWorkstreamMessages(@Nonnull Date dateToPublish) {
        return this._ibatisBuilder.select("getByPublishDate").param(dateToPublish).asMap("key", "value");
    }

    @Override
    public void deletePublishedEntries(@Nonnull Set<WorkstreamMessageId> workstreamMessageIds) {
        this._ibatisBuilder.delete("deleteEntriesByIds").partition(workstreamMessageIds);
    }

    @Override
    public void scheduleForPublication(Set<WorkstreamMessageId> idsToSchedule, Date publishDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisBuilder.batch(sqlMapClient -> {
            this.updatePublicationDatesBatched(idsToSchedule, publishDate);
            this.insertPublicationDatesBatched(idsToSchedule, publishDate);
        }));
    }

    private void updatePublicationDatesBatched(Set<WorkstreamMessageId> idsToSchedule, Date publishDate) {
        idsToSchedule.forEach(id -> this._ibatisBuilder.update("updatePublishDate").param("id", id, "publishDate", publishDate));
    }

    private void insertPublicationDatesBatched(Set<WorkstreamMessageId> idsToSchedule, Date publishDate) {
        idsToSchedule.forEach(id -> this._ibatisBuilder.insertDbSpecific("insertScheduledMessage").param("id", id, "publishDate", publishDate));
    }
}

