/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.workstream.business.WorkstreamScheduleService;
import de.justsoftware.onx.workstream.integration.persistence.ScheduledWorkstreamMessageDAO;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Date;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class WorkstreamScheduleServiceImpl
implements WorkstreamScheduleService {
    private final ScheduledWorkstreamMessageDAO _dao;

    @Autowired
    public WorkstreamScheduleServiceImpl(ScheduledWorkstreamMessageDAO dao) {
        this._dao = dao;
    }

    @Override
    public void scheduleWorkstreamMessageForPublication(WorkstreamMessageId messageId, Date publishDate) {
        this._dao.scheduleForPublication((Set<WorkstreamMessageId>)ImmutableSet.of((Object)messageId), publishDate);
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getScheduledByPublishDate(Date publishDate) {
        return this._dao.getScheduledWorkstreamMessages(publishDate).keySet();
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getScheduledMessagesByMessageIds(Set<WorkstreamMessageId> messageIds) {
        return this._dao.getScheduledWorkstreamMessagesByIds(messageIds);
    }

    @Override
    public void removeScheduledPublicationDates(Set<WorkstreamMessageId> messageIds) {
        this._dao.deletePublishedEntries(messageIds);
    }
}

