/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.onx.workstream.business.WorkstreamReadMonitor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamReadMonitorImpl
implements WorkstreamReadMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(WorkstreamReadMonitorImpl.class);
    private final ConcurrentHashMultiset<WorkstreamReadMonitor.What> _counters = ConcurrentHashMultiset.create();
    private final ScheduledExecutorService _executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("WorkstreamReadMonitor-%d").build());

    @PostConstruct
    public void init() {
        this._counters.clear();
        this._executorService.scheduleAtFixedRate(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._counters.toString());
            }
        }, 1L, 10L, TimeUnit.SECONDS);
        this._counters.clear();
        this._executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Daily Workstream Read Log Reset:\n" + WorkstreamReadMonitorImpl.this._counters.toString());
                }
                WorkstreamReadMonitorImpl.this._counters.clear();
            }
        }, 1L, 1L, TimeUnit.DAYS);
    }

    @Override
    public void count(WorkstreamReadMonitor.What what) {
        this.count(what, 1);
    }

    @Override
    public void count(WorkstreamReadMonitor.What what, int times) {
        this._counters.add((Object)what, times);
    }

    @PreDestroy
    public void destroy() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._executorService, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }
}

