/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.workstream.business.WorkstreamReadMediator;
import de.justsoftware.onx.workstream.business.WorkstreamReadService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class WorkstreamReadMediatorImpl
implements WorkstreamReadMediator {
    private final WorkstreamService _workstreamService;
    private final WorkstreamReadService _workstreamReadService;
    private final ItemService _itemService;

    @Autowired
    public WorkstreamReadMediatorImpl(WorkstreamService workstreamService, WorkstreamReadService workstreamReadService, ItemService itemService) {
        this._workstreamService = workstreamService;
        this._workstreamReadService = workstreamReadService;
        this._itemService = itemService;
    }

    @Override
    @Nonnull
    public Map<ItemId, Integer> getNumberOfUnreadMessagesByUserAndItemId(ImmutableSet<ItemId> items, SearchAuthorizationCheckContext authCtx) {
        Function<ItemId, Integer> unreadMessageCount = id -> this.countUnreadEntries((ItemId)id, authCtx);
        return (Map)items.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), unreadMessageCount));
    }

    private int countUnreadEntries(ItemId id, SearchAuthorizationCheckContext authCtx) {
        Date lastReadDate = this._workstreamReadService.getLastWorkstreamReadDateForUser(id, authCtx);
        if (lastReadDate == null) {
            return 0;
        }
        Item<ItemId> targetItem = InvalidIdServiceException.check(this._itemService.getById(id));
        ImmutableSet<WorkstreamMessageId> unreadMessages = this._workstreamService.getAllNewMessagesByOthersSince(targetItem, lastReadDate, authCtx);
        return unreadMessages.size();
    }
}

