/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.business.EntityPermissionService;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.DriveAction;
import de.justsoftware.onx.drive.business.ItemPrivacyProducer;
import de.justsoftware.onx.workstream.business.WorkstreamMessageVisibilityPublisher;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingPublishedEvent;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class WorkstreamMessageVisibilityPublisherImpl
implements WorkstreamMessageVisibilityPublisher,
ServerEventHandler {
    private static final int CHUNK_SIZE = 100;
    private final ItemPrivacyProducer _itemPrivacyProducer;
    private final EntityPermissionService _entityPermissionsService;
    private final WorkstreamDAO _workstreamDAO;

    @Autowired
    public WorkstreamMessageVisibilityPublisherImpl(ItemPrivacyProducer itemPrivacyProducer, EntityPermissionService entityPermissionsService, WorkstreamDAO workstreamDAO) {
        this._itemPrivacyProducer = itemPrivacyProducer;
        this._entityPermissionsService = entityPermissionsService;
        this._workstreamDAO = workstreamDAO;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleMicroblogPostingPublished(MicroblogPostingPublishedEvent event) {
        this.sendDelete((Set<? extends ItemId>)ImmutableSet.of((Object)event.getWorkstreamMessageId()));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onItemDeleted(ItemDeletedEvent e) {
        GlobalId itemId = e.getItemId();
        if (itemId instanceof WorkstreamMessageId) {
            this.sendDelete((Set<? extends ItemId>)ImmutableSet.of((Object)itemId));
        }
    }

    private void sendDelete(Set<? extends ItemId> itemIds) {
        if (this._itemPrivacyProducer.isReady()) {
            itemIds.forEach(this._itemPrivacyProducer::sendDelete);
        }
    }

    @Override
    public void publishVisibilityForScheduledPost(WorkstreamMessageId messageId, ItemId parentId) {
        this.publishVisibilityForScheduledPosts((Set<WorkstreamMessageId>)ImmutableSet.of((Object)messageId), parentId);
    }

    private void publishVisibilityForScheduledPosts(Set<WorkstreamMessageId> messageIds, ItemId parentId) {
        if (!this._itemPrivacyProducer.isReady() || !(parentId instanceof EntityId)) {
            return;
        }
        EntityId entityId = (EntityId)parentId;
        BoolExpr expressionForWorkstreamPost = (BoolExpr)this._entityPermissionsService.expressionsForEntityFunction((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<DriveAction>)ImmutableSet.of((Object)((Object)DriveAction.DRIVE_DOCUMENT_WRITE))).apply(entityId).get((Object)DriveAction.DRIVE_DOCUMENT_WRITE);
        ImmutableMap messageReadPermissions = ImmutableMap.of((Object)((Object)DriveAction.DRIVE_DOCUMENT_READ), (Object)expressionForWorkstreamPost);
        messageIds.forEach(arg_0 -> this.lambda$publishVisibilityForScheduledPosts$0((Map)messageReadPermissions, arg_0));
    }

    @Override
    public void publishVisibilityForScheduledPosts(Set<EntityId> parentIds) {
        ImmutableSetMultimap<EntityId, WorkstreamMessageId> scheduledWorkstreamIds = this._workstreamDAO.getAllScheduledWorkstreamIds(parentIds);
        scheduledWorkstreamIds.keySet().forEach(entityId -> {
            ImmutableSet messageIds = scheduledWorkstreamIds.get(entityId);
            this.publishVisibilityForScheduledPosts((Set<WorkstreamMessageId>)messageIds, (ItemId)entityId);
        });
    }

    @Override
    public void publishVisibilitiesForPublishedPosts(Set<EntityId> parentIds) {
        if (parentIds.isEmpty()) {
            return;
        }
        this._workstreamDAO.forAllPublishedWorkstreamMessages(100, parentIds, this::sendDelete);
    }

    private /* synthetic */ void lambda$publishVisibilityForScheduledPosts$0(Map messageReadPermissions, WorkstreamMessageId messageId) {
        this._itemPrivacyProducer.send(messageId, messageReadPermissions);
    }
}

